! source file: /den/eby/UVic_ESCM/2.6/source/common/atmos.F

      subroutine atmos

!----------------------------------------------------------------------
!     simple data atmosphere
!----------------------------------------------------------------------

      implicit none

      include "param.h"
      include "csbc.h"
      include "ctdbc.h"
      include "tmngr.h"
      include "switch.h"
      include "mapsbc.h"
      include "ndcon.h"

      integer i, iou, j, je, js, m, n, ntrec

      real damp1, damp2, realdays, wnext

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.

!     express model time in days after start of S.B.C. by adding time
!     of I.C. to current model time then subtract time at start of
!     S.B.C.. Note that "itemptime" was allocated in settmngr and is
!     only needed as a temporary.
!     need to add "dt" to the model time because the call to
!     atmos precedes the time stepping loop which calls mom, so the
!     model time has not yet been incremented when atmos executes.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call addtime (initial, imodeltime, itemptime)
        call addtime (itemptime, idt, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
      enddo

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n)
     &,    ntdrec(n), period(n), method, inextd(n), iprevd(n)
     &,    wprev(n), rdtdbc(n), inextm(n), iprevm(n))

      enddo

!-----------------------------------------------------------------------
!     read in data for each S.B.C. when necessary
!-----------------------------------------------------------------------

      n = 1
      do m=1,numsbc

        if ( m .eq. itaux ) then
!         x component of windstress
          call get_tdsbc (n, 'data/taux_mth.nc', 'taux', itaux
     &,     rdtdbc(n), 0.1, 0.)

        elseif ( m .eq. itauy ) then
!         y component of windstress
          call get_tdsbc (n, 'data/tauy_mth.nc', 'tauy', itauy
     &,     rdtdbc(n), 0.1, 0.)

        elseif ( m .eq. iws ) then
!         surface wind speed
          call get_tdsbc (n, 'data/ws_mth.nc', 'ws', iws
     &,     rdtdbc(n), 0.01, 0.)

        elseif ( m .eq. iwx ) then
!         x component of advecting wind
          call get_tdsbc (n, 'data/wx_mth.nc', 'wx', iwx
     &,     rdtdbc(n), 0.01, 0.)

        elseif ( m .eq. iwy ) then
!         y component of advecting wind
          call get_tdsbc (n, 'data/wy_mth.nc', 'wy', iwy
     &,     rdtdbc(n), 0.01, 0.)

        endif

      enddo

      return
      end

      subroutine get_tdsbc (n, file, name, index, read, scalar, offset)

      implicit none

      include "param.h"
      include "csbc.h"
      include "ctdbc.h"
      include "mapsbc.h"

      character (*) :: file, name
      integer i, index, iou, j, ntrec, n
      logical read
      real offset, scalar, time, wnext

      if (read) then
        time = 0.
        ntrec = 1
        call openfile (file, time, ntrec, iou)
        call getvara (name, iou, imt*jmt, (/1,1,inextd(n)/)
     &,   (/imt,jmt,1/), obc(1,1,n,inextm(n)), scalar, offset)
        call closefile (iou)
      endif
      wnext = c1-wprev(n)
      do j=1,jmt
        do i=1,imt
          sbcocn(i,j,index) = wprev(n)*obc(i,j,n,iprevm(n))
     &                      + wnext*obc(i,j,n,inextm(n))
        enddo
      enddo
      n = n + 1

      return
      end

