! source file: /den/eby/UVic_ESCM/2.6/source/embm/cembm.h
!====================== include file "cembm.h" =========================

!     parameters for use in the energy balance model (also see atm.h)

!     addflux    = logical flag for adding only even mode fluxes
!     nats       = number of atmospheric time steps since mixing
!     namix      = time steps between mixing (set in atmos.in)
!     lf         = time step flag (1=>leapfrog, 2=>forward)
!     ntats      = time step counter for time averaging
!     niats      = number of ice advection sub time steps
!     nivts      = time steps between recalculating ice velocities
!     nivc       = time step counter for nivts
!     ns         = number of subcycles for advection and diffusion
!     pyear      = calendar year (set in atmos.in, -/+ = BC/AD)
!     dtatm      = time step for atmosphere (set in atmos.in)
!     dts        = time step (2*dtatm=>leapfrog, dtatm=>forward)
!     co2ccn     = CO2 concentration
!     co2ccni    = initial CO2 concentration
!     anthro     = radiative forcing by CO2
!     co2yri     = last year of initial CO2 concentration
!     co2yrf     = first year of final CO2 concentration
!     co2rate    = rate of increase (linear or exponential)
!     co2for     = CO2 forcing term (in units of heat flux)
!     scatter    = proportion of solar scattered by the atmosphere
!     solarconst = solar constant (g/s**3)
!     ssp        = sea surface pressure (g/cm/s**2)
!     cdatm      = drag coefficient (dimensionless)
!     cpatm      = atmospheric heat capacity (cm**2/s**2/K)
!     ht         = scale height for temperature
!     hq         = scale height for specific humidity
!     rhoatm     = density of air at sea surface (g/cm**3)
!     rhoocn     = representative sea surface density
!     esocn      = ocean emissivity times Stefan's constant
!     vlocn      = latent heat of vaporization of water
!     socn       = constant ocean salinity
!     cdice      = drag coefficient (dimensionless)
!     dampice    = time scale for freezing first layer under ice (days)
!     rhoice     = ice density (g/cm**3)
!     rhosno     = snow density (g/cm**3)
!     esice      = ice emissivity times Stefan's constant
!     slice      = latent heat of sublimation of ice
!     flice      = latent heat of fusion of ice (cm**2/s**2)
!     condice    = ice conductivity (g*cm/s**3/K)
!     tsno       = air temperature for accumulating snow
!     hsno_max   = maximum snow depth
!     avetime    = time for averaging fluxes
!     totaltime  = total time for long term averages
!     dtoih      = total net heat flux through top of atmosphere
!     rlapse     = lapse rate (K/cm)
!     diffactor  = temperature(precip) diffusion factor
!     soilmax    = soil water field capacity (cm)
!     eslnd      = land emissivity time Stefan's constant
!     pass       = atmospheric transmission coefficient (%/100)
!     cs_alb     = clear sky atmospheric albedo (%/100)
!     ice_calb   = ice coalbedo (%/100)
!     sno_calb   = snow coalbedo (%/100)
!     pcfactor   = precip - cloud correlation factor ( %/100)
!     wfactor    = wind reduction factor ( %/100)

      logical addflux

      common /cembm_l/ addflux

      integer nats, namix, lf, ntats, niats, nivts, nivc, ns

      common /cembm_i/ nats, namix, lf, ntats, niats, nivts, nivc, ns

      real pyear, dtatm, dts, co2ccn, co2ccni, anthro, co2yri, co2yrf
      real co2rate, co2for, scatter, solarconst, ssp, cdatm, cpatm
      real rhoatm, rhoocn, esocn, vlocn, socn, cdice, dampice
      real rhoice, ht, hq, rhosno, esice, slice, flice, condice, tsno
      real hsno_max, avetime, totaltime, dtoih, rlapse, diffactor
      real soilmax, eslnd, pass, cs_alb, ice_calb, sno_calb, pcfactor
      real wfactor

      common /cembm_r/ pyear, dtatm, dts, co2ccn, co2ccni, anthro
      common /cembm_r/ co2yri, co2yrf, co2rate, co2for, scatter
      common /cembm_r/ solarconst, ssp, cdatm, cpatm, rhoatm, rhoocn
      common /cembm_r/ esocn, vlocn, socn, cdice, dampice
      common /cembm_r/ rhoice, ht, hq, rhosno, esice, slice, flice
      common /cembm_r/ condice, tsno, hsno_max, avetime, totaltime
      common /cembm_r/ dtoih, rlapse, diffactor, soilmax, eslnd, pass
      common /cembm_r/ cs_alb, ice_calb, sno_calb, pcfactor, wfactor

!     ntatia     = number of time averaged time step integrals
!     tai_sat    = average integrated surface air temperature
!     tai_shum   = average integrated surface specific humidity
!     tai_hfx    = average integrated surface heat flux
!     tai_sfx    = average integrated surface salt flux
!     tai_oice   = average integrated sea ice volume
!     tai_snow   = average integrated snow volume
!     tai_lice   = average integrated land ice volume
!     tai_co2ccn = average integrated CO2 concentration
!     tai_maxit  = average maximum iterations for atmospheric solver

      integer ntatia

      common /cembm_i/ ntatia

      real tai_sat, tai_shum, tai_hfx, tai_sfx, tai_oice, tai_snow
      real tai_lice, tai_co2ccn, tai_maxit

      common /cembm_r/ tai_sat, tai_shum, tai_hfx, tai_sfx, tai_oice
      common /cembm_r/ tai_snow, tai_lice, tai_co2ccn, tai_maxit

