! source file: /den/eby/UVic_ESCM/2.6/source/common/csbc.h
!====================== include file "csbc.h" ==========================

!                    surface boundary conditions (S.B.C.)

!     numsbc  = total number of S.B.C. this is the sum of the
!               atmosphere S.B.C. and ocean S.B.C. fields.

!     sbcocn  = S.B.C. fields.

!     dampts  = time scale for damping surface tracers (days) to data
!     dampdz  = ocean level thickness for converting newtonian damping
!               to a surface flux

!     ntspos  = number of time steps per ocean segment

!     sbcname  = S.B.C. character string names (eg: "SST", "taux", etc)
!               note that these character strings should be changed with
!               care since they are used to identify fields for special
!               treatment

!     dunits  = dimensional units for S.B.C. (eg: "deg C")

!     mapsbc  = indices for relating how S.B.C. fields are stored
!               within arrays "sbcocn" and "sbcatm"
!               eg: m = mapsbc(n) where sbcocn(,,m) is S.B.C. "n"

!     author:      r. c. pacanowski      e-mail=> rcp@gfdl.gov

      integer numsbc
      parameter (numsbc = 7

     &                   + 2

     &                   + 4

     &                      )

      integer mapsbc, numpas, ntspos, ntspas
      common /csbc_i/ mapsbc(numsbc), numpas, ntspos, ntspas

      real sbcocn, dampts, dampdz, subflux, subz
      common /csbc_r/ sbcocn(imt,jmt,numsbc)
      common /csbc_r/ dampts(nt), dampdz(nt)

