! source file: /den/eby/UVic_ESCM/2.6/source/embm/embm.F
      subroutine embm

!=======================================================================

!     The atmospheric energy mositure balance model (EMBM) is based
!     primarily on the work of Augustus Fanning.

!     Fanning, A.F. and A.J. Weaver, An atmospheric energy-moisture
!       balance model: climatology, interpentadal climate change,
!       and coupling to an ocean general circulation model,
!       J. Geophys. Res., 101, 15,111-15,128, 1996

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "size.h"
      include "cembm.h"

      integer n

!-----------------------------------------------------------------------
!     increment counter and set the time step type
!-----------------------------------------------------------------------

      nats = nats + 1
      if (nats .gt. namix) then
        lf = 2
        dts = dtatm
        nats = 1
      else
        lf = 1
        dts = 2.0*dtatm
      endif

      addflux = .true.

      if (mod(nats,2) .ne. 0) addflux = .false.

!-----------------------------------------------------------------------
!     calculate fluxes at tau
!-----------------------------------------------------------------------

      call fluxes (1, imt, 1, jmt)

!-----------------------------------------------------------------------
!     compute ice fluxes at tau and ice thickness and area at tau+1
!-----------------------------------------------------------------------

      call ice (1, imt, 1, jmt)

!-----------------------------------------------------------------------
!     compute atmospheric tracers at tau+1. start with humidity so that
!     the precipitation flux can be calculated for latent heat
!-----------------------------------------------------------------------

      call solve (2)
      call precipitate (1, imt, 1, jmt)
      call solve (1)
      do n=3,nat
        call solve (n)
      enddo

!-----------------------------------------------------------------------
!     calculate the total atmospheric fluxes for coupling
!-----------------------------------------------------------------------

      if (addflux) call sum_flux (1, imt, 1, jmt)

!-----------------------------------------------------------------------
!     accumulate time average atmospheric data
!-----------------------------------------------------------------------

      if (addflux) call ta_atm_snap (1, imt, 1, jmt, 1)

!-----------------------------------------------------------------------
!     accumulate time average integral atmospheric data
!-----------------------------------------------------------------------

      if (addflux) call ta_atm_tsi (1)

      return
      end

      subroutine sum_flux (is, ie, js, je)

!=======================================================================
!     sum fluxes over atmospheric time steps
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"
      include "levind.h"

      include "ice.h"

      include "csbc.h"
      include "mapsbc.h"

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1

      real fa

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      do j=jsp1,jem1

        do i=isp1,iem1
          if (kmt(i,j) .gt. 0) then
            flux(i,j,1) = flux(i,j,1) + dts*(dnswr(i,j) - uplwr(i,j)
     &                  - upltnt(i,j) - upsens(i,j))

            flux(i,j,2) = flux(i,j,2) + dts*(precip(i,j) - evap(i,j))

            flux(i,j,nat+1) = flux(i,j,nat+1) + dts*sbcocn(i,j,itaux)
            flux(i,j,nat+2) = flux(i,j,nat+2) + dts*sbcocn(i,j,itauy)

            flux(i,j,nat+1) = flux(i,j,nat+1) + dts*xint(i,j)
            flux(i,j,nat+2) = flux(i,j,nat+2) + dts*yint(i,j)

          endif

          accp(i,j) = accp(i,j) + dts*precip(i,j)

        enddo
      enddo

      totaltime = totaltime + dts
      avetime = avetime + dts

      return
      end
