! source file: /den/eby/UVic_ESCM/2.6/source/mom/fdift.h
!====================== include file "fdift.h" =========================

!     finite difference numerics for tracers

!     author:      r. c. pacanowski      e-mail=> rcp@gfdl.gov
!=======================================================================

!-----------------------------------------------------------------------
!     advective terms
!-----------------------------------------------------------------------

      ADV_Tx(i,k,j) = (adv_fe(i,k,j) - adv_fe(i-1,k,j))*cstdxt2r(i,j)

      ADV_Ty(i,k,j,jrow,n) = (adv_vnt(i,k,j)*(t(i,k,j,n,tau)
     &  + t(i,k,j+1,n,tau)) - adv_vnt(i,k,j-1)*(t(i,k,j-1,n,tau)
     &  + t(i,k,j,n,tau)))*cstdyt2r(jrow)

      ADV_Tz(i,k,j) = (adv_fb(i,k-1,j) - adv_fb(i,k,j))*dzt2r(k)

!-----------------------------------------------------------------------
!     diffusive terms
!-----------------------------------------------------------------------

!     zonal component

      DIFF_Tx(i,k,j) = (diff_fe(i,  k,j)*tmask(i+1,k,j)
     &  - diff_fe(i-1,k,j)*tmask(i-1,k,j))*cstdxtr(i,j)

!     meridional component

      DIFF_Ty(i,k,j,jrow,n) = ahc_north(jrow)*tmask(i,k,j+1)
     &  *(t(i,k,j+1,n,taum1) - t(i,k,j,n,taum1)) - ahc_south(jrow)
     &  *tmask(i,k,j-1)*(t(i,k,j,n,taum1) - t(i,k,j-1,n,taum1))

!     vertical component

      DIFF_Tz(i,k,j) = (diff_fb(i,k-1,j) - diff_fb(i,k,j))*dztr(k)

