! source file: /den/eby/UVic_ESCM/2.6/source/common/file_names.F
      subroutine file_names
!=======================================================================
!     edit this routine to change file names or add directories to file
!     names. names may also be modified by editing a filenames file.
!     the filenames file will only be written to, if it already exists.
!     if you want an example of the format required, touch the file and
!     change one file below (with put names) to write the change.
!     changes from file filenames take precedence over changes below.

!     an old file name (first argument to put_names) will be replaced by
!     a new file name (second argument to put_names) when the iomngr or
!     mpp_io routines try to open a file which starts with the old file
!     name. if the start of the file matches more than one old name, the
!     first match (in the order of calls to put_names) will be used. if
!     the file name is longer than the old file name (but matches at the
!     beginning), only the matched section is replaced by the new file
!     name. if the new or old name is blank, the change is ignored.

!     caution: if an old file name is found at the start of more than
!     one file name, more than the intended file name may be changed.
!     for example the single call to put_names:
!       call put_names ('particles', 'x')
!     would change all files starting with "particles..." to "x..."
!     including changing "particles_initial..." to "x_initial..."
!     if you do not want to change "particles_initial...", you can do
!     the following (the order is important):
!       call put_names ('particles_initial', 'particles_initial')
!       call put_names ('particles', 'x')
!     you may want to use this feature to redirect many files at once.
!     for example:
!       call put_names ('t', 't_files/t')
!     would cause all files beginning with t to be read or written from
!     the directory t_files (unless a particular 't...' file was
!     renamed with put_names before this call).

!     author:      m.eby                 e-mail=> eby@uvic.ca
!=======================================================================

      implicit none

      integer max_num_files
      parameter (max_num_files=200)

      character(80) :: old_file_names, new_file_names
      common /files_c/ old_file_names(max_num_files)
      common /files_c/ new_file_names(max_num_files)

      integer num_files
      common /files_i/ num_files

      integer iou, ios, n
      character(len=80) old_file_name, new_file_name, text
      logical exists

      num_files = 0
      text = 'old file name followed by new (see file_names.F)'

      inquire (file='filenames', exist=exists)
      if (exists) then
!       read file name changes from filenames
        call getunit (iou, 'filenames','formatted sequential rewind')
        do n=1,max_num_files
          read (iou, '(a)', IOSTAT=ios) old_file_name
          if (old_file_name /= text .and. ios == 0) then
            write(*,'(a)') '==> Warning: error reading file names'
            exit
          endif
          read (iou, '(a/a)', IOSTAT=ios) old_file_name, new_file_name
          if (ios > 0) exit
          call put_names (old_file_name, new_file_name)
        enddo
        call relunit (iou)
      endif

      print*, 'The following files will be renamed:'

      call put_names ('wy.nc', 'data/wy.nc')
      call put_names ('wx.nc', 'data/wx.nc')
      call put_names ('wsa.nc', 'data/wsa.nc')
      call put_names ('wsa.nc', 'data/wsa.nc')
      call put_names ('ws.nc', 'data/ws.nc')
      call put_names ('tbar.nc', 'data/tbar.nc')
      call put_names ('tauy.nc', 'data/tauy.nc')
      call put_names ('taux.nc', 'data/taux.nc')
      call put_names ('sf_alb.dta', 'data/sf_alb.dta')
      call put_names ('sst.nc', 'data/sst.nc')
      call put_names ('sss.nc', 'data/sss.nc')
      call put_names ('rivers.map', 'data/rivers.map')
      call put_names ('kmt.map', 'data/kmt.map')
      call put_names ('region_masks', 'data/region_masks')
      call put_names ('region_masks.out', 'data/region_masks.out')
      call put_names ('lat.nc', 'data/lat.nc')
      call put_names ('kmt.nc', 'data/kmt.nc')
      call put_names ('hflx.nc', 'data/hflx.nc')
      call put_names ('grid.nc', 'data/grid.nc')
      call put_names ('elev.nc', 'data/elev.nc')

!     write file name changes to filenames
      if (exists) then
        call getunit (iou, 'filenames','formatted sequential rewind')
        do n=1,num_files
          write (iou, '(a)') text
          write (iou, '(a/a)') old_file_names(n), new_file_names(n)
        enddo
        call relunit (iou)
      endif

      end subroutine file_names

      subroutine put_names (old_file_name, new_file_name)
!=======================================================================
!     put file names in the appropriate array location

!     input:
!     old_file_name = old file name
!     new_file_name = new file name

!     output:
!     old_file_names = updated array of old file names
!     new_file_names = updated array of new file names
!     num_files      = number of renamed files

!     author:      m.eby                 e-mail=> eby@uvic.ca
!=======================================================================

      implicit none

      integer max_num_files
      parameter (max_num_files=200)

      character(80) :: old_file_names, new_file_names
      common /files_c/ old_file_names(max_num_files)
      common /files_c/ new_file_names(max_num_files)

      integer num_files
      common /files_i/ num_files

      integer n
      character (len=*) old_file_name, new_file_name

      do n=1,num_files
        if (trim(old_file_name) == trim(old_file_names(n))) then
          new_file_name = ''
        endif
      enddo

      if (trim(old_file_name) == '') new_file_name = ''

      if (new_file_name /= '') then
        num_files = num_files + 1
        old_file_names(num_files) = trim(old_file_name)
        new_file_names(num_files) = trim(new_file_name)
        print*, '  ',trim(old_file_name),' renamed ',trim(new_file_name)
      endif

      end subroutine put_names

      function new_file_name (old_file_name)

!=======================================================================
!     provides a new file name if the beginning of the old file name is
!     matched with a name from the old_file_names array. old and new
!     file names are set in the set_file_names routine. if a match is
!     not found, then the old file name is used.

!     input:
!     old_file_name = old file name

!     output:
!     new_file_name = new file name

!     author:      m.eby                 e-mail=> eby@uvic.ca
!=======================================================================

      implicit none

      integer max_num_files
      parameter (max_num_files=200)

      character(80) :: old_file_names, new_file_names, new_file_name
      common /files_c/ old_file_names(max_num_files)
      common /files_c/ new_file_names(max_num_files)

      integer num_files
      common /files_i/ num_files

      integer i, j, k, m, n
      character (len=*) old_file_name

      i = 0
      do n=1,num_files
        i = index(old_file_name, trim(old_file_names(n)))
        if (i == 1) then
          j = len_trim(old_file_name)
          k = len_trim(old_file_names(n))
          m = len_trim(new_file_names(n))
          new_file_name = trim(new_file_names(n))
          if (j > k) new_file_name(m+1:m+1+j-k) = old_file_name(k+1:j)
          exit
        endif
      enddo

      if (i == 0) new_file_name = trim(old_file_name)

      end function new_file_name
