! source file: /den/eby/UVic_ESCM/2.6/source/embm/fluxes.F
      subroutine fluxes (is, ie, js, je)

!=======================================================================
!     calculate energy and moisture fluxes
!     based on code by a.fanning

!     Note: evaporation and precipitation are in g cm-2 s-1
!           and humidities are in g g-1

!     for Thompson and Warren outgoing radiation (see: Thompson S.J.,
!     and S.G. Warren 'parameterization of outgoing ...'J. Atmos. Sci.,
!     39, 2667-2680, 1982.

!     "uvic_embm_land" option based on code by d.matthews

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"
      include "levind.h"
      include "csbc.h"
      include "mapsbc.h"

      integer i, ie, iem1, imax, is, isp1, iter
      integer j, je, jem1, jmax, js, jsp1, maxit

      real b00, b10, b20, b01, b11, b21, b02, b12, b22, b03, b13, b23
      real dalt, Dalton, delta, df, dt, dultnt, dulwr, dusens
      real emax, f, fa, fb, ff, fg, fh, fl, fm, ql, rh
      real rhrh, scrit, tair, tl, tlold, tol, ultnt, ulwr, usens, wspd

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

!-----------------------------------------------------------------------
!     set appropriate constants
!-----------------------------------------------------------------------

      fa = 3.80116e03/ssp
      fb = 0.94*rhoatm*cpatm

!     Thomson and Warren constants

      b00 = 2.43414e2
      b10 = -3.47968e1
      b20 = 1.02790e1
      b01 = 2.60065
      b11 = -1.62064
      b21 = 6.34856e-1
      b02 = 4.40272e-3
      b12 = -2.26092e-2
      b22 = 1.12265e-2
      b03 = -2.05237e-5
      b13 = -9.67e-5
      b23 = 5.62925e-5

      do j=jsp1,jem1
        do i=isp1,iem1

!-----------------------------------------------------------------------
!          set the incoming short wave
!-----------------------------------------------------------------------

          dnswr(i,j) = solins(j)*a_calb(i,j)*pass*s_calb(i,j)

!-----------------------------------------------------------------------
!          set wind speed
!-----------------------------------------------------------------------

          wspd = sbcocn(i,j,iws)

!-----------------------------------------------------------------------
!         calculate saturation specific humidity at surface air temp
!-----------------------------------------------------------------------

          tair = at(i,j,2,1) - elev(i,j)*rlapse
          ssh(i,j) = fa*exp(17.67*tair/(tair + 243.5))
          rh = max(c0, min(c1, at(i,j,2,2)/(ssh(i,j) + epsln)))

!-----------------------------------------------------------------------
!         calculate outgoing longwave radiation
!-----------------------------------------------------------------------

          rhrh = rh*rh
          outlwr(i,j) = 1.0e3*(b00 + b10*rh + b20*rhrh
     &                + (b01 + b11*rh + b21*rhrh)*tair
     &                + (b02 + b12*rh + b22*rhrh)*tair**2
     &                + (b03 + b13*rh + b23*rhrh)*tair**3)
     &                - anthro

          if (kmt(i,j) .gt. 0) then

!-----------------------------------------------------------------------
!          calculations only for ocean points
!-----------------------------------------------------------------------

            dt = surf(i,j,1) - at(i,j,2,1)
            fg = Dalton(dt, wspd)*wspd

!-----------------------------------------------------------------------
!           calculate evaporation or sublimation (ensure it is positive)
!-----------------------------------------------------------------------

            evap(i,j) = max(c0, rhoatm*fg*(surf(i,j,2) - at(i,j,2,2)))
            upltnt(i,j) = vlocn*evap(i,j)

!-----------------------------------------------------------------------
!           calculate upward sensible heat flux
!-----------------------------------------------------------------------

            upsens(i,j) = fb*fg*(dt)

!-----------------------------------------------------------------------
!           calculate upward longwave re-radiation
!-----------------------------------------------------------------------

            uplwr(i,j) = esocn*(surf(i,j,1) + 273.15)**4

     &                 - esatm(j)*(at(i,j,2,1) + 273.15)**4

          else

            evap(i,j) = 0.0
            upltnt(i,j) = 0.0
            upsens(i,j) = 0.0
            uplwr(i,j) = dnswr(i,j)

          endif

        enddo
      enddo

      return
      end

      subroutine precipitate (is, ie, js, je)

!=======================================================================
!     calculate precipitation explicitly and update humidity
!     based on code by a.fanning

!     "uvic_embm_land" option based on code by d.matthews

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "scalar.h"
      include "cembm.h"
      include "atm.h"
      include "levind.h"

      include "ice.h"

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1, k, n

      real fa, fb, qmax, rate, tair, soiltemp, pson, psot

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

!-----------------------------------------------------------------------
!     set appropriate constants
!-----------------------------------------------------------------------

      fa = rhoatm*hq/dts
      fb = dts/rhosno

!     rate is a maximum snow melt rate (cm/day/C)
      rate =  0.5

      k = 0
      do j=jsp1,jem1
        do i=isp1,iem1

!-----------------------------------------------------------------------
!         check if specific humidity is greater than saturation
!-----------------------------------------------------------------------

          qmax = 0.85*ssh(i,j)
          if (at(i,j,2,2) .gt. qmax) then
            precip(i,j) = fa*(at(i,j,2,2) - qmax)
            at(i,j,2,2) = qmax
          else
            precip(i,j) = 0.0
            if (at(i,j,2,2) .lt. 0.0) then
              at(i,j,2,2) = 0.0
              write(stdout,*) '=>Warning: negative q(i,j) at ', i, j
            endif
          endif

!-----------------------------------------------------------------------
!         calculate snowfall (hsno at tau was set in the ice model)
!-----------------------------------------------------------------------

!         tair may be adjusted by a snowfall offset temperature tsno

          tair = at(i,j,2,1) - tsno - elev(i,j)*rlapse
          psno(i,j) = 0.0

          if (tair .le. c0 .and. hsno(i,j,2) .lt. hsno_max)
     &      psno(i,j) = min(precip(i,j), hsno_max - hsno(i,j,2))
          if (kmt(i,j) .gt. 0) then
!           only allow snow where there is sea ice
            psno(i,j) = psno(i,j)*aice(i,j,2)
            hsno(i,j,2) = hsno(i,j,2) + fb*psno(i,j)
            if (addflux) flux(i,j,2) = flux(i,j,2) - dts*psno(i,j)
          else

!           melt snow over land if atmosphere is above freezing
            if (tair .gt. c0 .and. hsno(i,j,2) .gt. c0)
     &        psno(i,j) = max(-hsno(i,j,2)/fb, -rate*secday*tair)

            hsno(i,j,2) = hsno(i,j,2) + fb*psno(i,j)
          endif

        enddo
      enddo

      call embmbc (psno)

      call embmbc (hsno(1,1,2))

!-----------------------------------------------------------------------
!     calculate river runoff from continents
!-----------------------------------------------------------------------

      call rivmodel

      return
      end

      function Dalton (dt, ws)
!=======================================================================
!     calculate the Dalton number based on stability criterion
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      real Dalton, dt, ws

      Dalton = 1.0022e-3 + 8.22e-5*(dt) + 2.66e-6*ws
      if (Dalton .lt. 6.0e-05) Dalton = 6.0e-05
      if (Dalton .gt. 2.2e-03) Dalton = 2.2e-03

      return
      end

      subroutine co2forc
!=======================================================================
!     calculate CO2 forcing
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "cembm.h"
      include "tmngr.h"
      include "switch.h"

      real yr

!-----------------------------------------------------------------------
!     set concentration
!-----------------------------------------------------------------------

      co2ccn = co2ccni

!-----------------------------------------------------------------------
!     current CO2 concentration is assumed to be 350 ppm
!     relative forcing (anthro) is added to current forcing
!-----------------------------------------------------------------------

      anthro = co2for*alog(co2ccn/350.0)

      return
      end
