! source file: /den/eby/UVic_ESCM/2.6/source/common/gosbc.F
      subroutine gosbc

!=======================================================================
!     calculate the average fluxes for next ocean time step
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"
      include "levind.h"
      include "csbc.h"
      include "mapsbc.h"

      integer i, j, nc, num

      real fa, fb, fc

!-----------------------------------------------------------------------
!     calculate average net fluxes. convert heat flux to cal/cm**2/s
!     from kW/m**2 and fresh water flux (cm/s) to an apparent salt
!     flux (g/cm**2/s) using global ocean average salinity, socn
!-----------------------------------------------------------------------

      fa = 2.389e-8/avetime
      fb = -socn/avetime
      fc = 1.0/avetime
      num = 0
      do j=2,jmtm1
        do i=2,imtm1
          if (kmt(i,j) .gt. 0) then

            sbcocn(i,j,ihflx) = fa*flux(i,j,1)
            sbcocn(i,j,ipme) = fb*flux(i,j,2)

            sbcocn(i,j,itaux) = fc*flux(i,j,nat+1)
            sbcocn(i,j,itauy) = fc*flux(i,j,nat+2)

          endif
        enddo
      enddo
      call setbcx (sbcocn(1,1,ihflx), imt, jmt)
      call setbcx (sbcocn(1,1,ipme), imt, jmt)
      call setbcx (sbcocn(1,1,itaux), imt, jmt)
      call setbcx (sbcocn(1,1,itauy), imt, jmt)

      return
      end
