! source file: /den/eby/UVic_ESCM/2.6/source/ice/ice.F
      subroutine ice (is, ie, js, je)

!=======================================================================
!     calling routine for ice model subroutines

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "ice.h"

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      if (nivc .eq. 1) then

!-----------------------------------------------------------------------
!       find latitudes with ice for dynamic calculations
!-----------------------------------------------------------------------

        call icelats (is, ie, js, je)

!-----------------------------------------------------------------------
!       calculate velocities with elastic-viscous-plastic rheology
!-----------------------------------------------------------------------

        if (nseg .ne. 0) call evp (is, ie, js, je)

      endif
      if (nivc .eq. nivts) nivc = 0
      nivc = nivc + 1

!-----------------------------------------------------------------------
!     advect ice and snow
!-----------------------------------------------------------------------

      if (lf. eq. 2) then
        do j=jsp1,jem1
          do i=isp1,iem1
            hice(i,j,1) = hice(i,j,2)
            aice(i,j,1) = aice(i,j,2)
            hsno(i,j,1) = hsno(i,j,2)
          enddo
        enddo
      endif
      call advupb (uice, vice, hice(1,1,1), is, ie, js, je)
      call advupb (uice, vice, aice(1,1,1), is, ie, js, je)
      call advupb (uice, vice, hsno(1,1,1), is, ie, js, je)

!-----------------------------------------------------------------------
!     calculate simple thermodynamics
!-----------------------------------------------------------------------

      call therm (is, ie, js, je)

      return
      end

      subroutine icelats (is, ie, js, je)

!=======================================================================
!     find latitudes for ice dynamics calculations
!     calculate starting and ending latitudes for velocity calculations

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "ice.h"

      integer i, ice, ie, iem1, inc, is, isp1, j, je, jem1, jm, jp
      integer js, jsp1, k, kmax, nc

      real hi

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      nseg = 0
      inc = 1
      kmax = 3
      do j=jsp1,jem1
        ice = 0
        do i=isp1,iem1

          hi = hice(i,j,1) + hice(i,j,2)

          do k=1,kmax
            jm = max(1,j-k)
            jp = min(jmt,j+k)

            hi = hi + hice(i,jm,1) + hice(i,jp,1) + hice(i,jm,2)
     &         + hice(i,jp,2)

            if (hi .ne. 0.0) ice = 1
          enddo
        enddo
        if (ice .eq. 1) then
          nseg = nseg + inc
          if (inc .eq. 1) jsi(nseg) = j
          if (j .eq. jmtm1) jei(nseg) = jmtm1
          inc = 0
        else
          do i=is,ie
            uice(i,j) = 0.0
            vice(i,j) = 0.0
          enddo
          if (inc .eq. 0) jei(nseg) = j
          inc = 1
        endif
      enddo

      return
      end

