! source file: /den/eby/UVic_ESCM/2.6/source/mom/ocn_snap.F
      subroutine ocn_snap_in (fname, ids, ide, jds, jde, imt, jmt, km
     &,                       nt, xt, yt, zt, xu, yu, zw, dxt, dyt, dzt
     &,                       dxu, dyu, dzw, ntrec, timunit, expnam
     &,                       avgper, relyr, stamp, t, u, v, adv_vbt
     &,                       stf, taux, tauy

     &,                       psi

     &,                       kmt, mskhr)
!=======================================================================
!     input routine for ocean time averages or 1

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     dxt, dyt ...       = grid widths
!     ntrec              = number of time record

!   outputs:
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     t, ...             = data to be read

!   local variables
!     igs, ige, jgs, jge = global read domain start and end indicies
!     ig, jg             = global read domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for read on each axis (x,y,t default)
!     ic                 = count for read on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title, file_stamp
      character(3) :: a3

      integer i, iou, j, ln, n, ntrec, imt, jmt, km, nt
      integer ids, ide, jds, jde, igs, ige, ig, jgs, jge, jg, kgs, kge
      integer kg, ils, ile, jls, jle, kls, kle, is(10), ic(10), it(10)
      integer iu(10), id_time, id_xt, id_xu, id_yt, id_yu, id_zt, id_zw
      integer id_xt_e, id_xu_e, id_yt_e, id_yu_e, id_zt_e, id_zw_e
      integer kmt(ids:ide,jds:jde), mskhr(ids:ide,jds:jde)
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real xt(imt), xu(imt), yt(jmt), yu(jmt), zt(km), zw(km), avgper
      real dxt(imt), dxu(imt), dyt(jmt), dyu(jmt), dzt(km), dzw(km)
      real t(ids:ide,jds:jde,km,nt), u(ids:ide,jds:jde,km)
      real v(ids:ide,jds:jde,km), adv_vbt(ids:ide,jds:jde,km)
      real stf(ids:ide,jds:jde,nt), taux(ids:ide,jds:jde)
      real tauy(ids:ide,jds:jde)

      real psi(ids:ide,jds:jde)

      real rkmt(ids:ide,jds:jde), rmskhr(ids:ide,jds:jde)
      real relyr, tmp(1), xt_e(imt+1), xu_e(imt+1), yt_e(jmt+1)
      real yu_e(jmt+1), zt_e(km+1), zw_e(km+1)

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      name = fname
      i = 0
      call openfile (name, relyr, i, iou)

!-----------------------------------------------------------------------
!     get global attributes
!-----------------------------------------------------------------------
      call getglobal (iou, fname, title, expnam, timunit)

!-----------------------------------------------------------------------
!     get global read domain size (may be less than global domain)
!-----------------------------------------------------------------------
      call getaxis('xt', iou, imt, xt, igs, ige, 1., 0.)
      call getaxis('xu', iou, imt, xu, igs, ige, 1., 0.)
      ig  = ige-igs+1
      call getaxis('yt', iou, jmt, yt, jgs, jge, 1., 0.)
      call getaxis('yu', iou, jmt, yu, jgs, jge, 1., 0.)
      jg  = jge-jgs+1
      call getaxis('zt', iou, km, zt, kgs, kge, 0.01, 0.)
      call getaxis('zw', iou, km, zw, kgs, kge, 0.01, 0.)
      kg  = kge-kgs+1

!-----------------------------------------------------------------------
!     local domain size (minimum of data domain and global read domain)
!-----------------------------------------------------------------------
      ils = max(ids,igs)
      ile = min(ide,ige)
      jls = max(jds,jgs)
      jle = min(jde,jge)
      kls = max(1,kgs)
      kle = min(km,kge)

!-----------------------------------------------------------------------
!     read 1d data (t)
!-----------------------------------------------------------------------
      call getvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      relyr = tmp(1)
      call getvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nyear = tmp(1)
      call getvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmonth = tmp(1)
      call getvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nday = tmp(1)
      call getvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nhour = tmp(1)
      call getvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmin = tmp(1)
      call getvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nsec = tmp(1)
      call mkstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      call getvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      avgper = tmp(1)

!-----------------------------------------------------------------------
!     read 2d data (x,y)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      ln = ic(1)*ic(2)
      call getvara ('kmt', iou, ln, is, ic, rkmt(ils:ile,jls:jle)
     &, 1., 0.)
      kmt(ils:ile,jls:jle) = rkmt(ils:ile,jls:jle)
      call getvara ('mskhr', iou, ln, is, ic, rmskhr(ils:ile,jls:jle)
     &, 1., 0.)
      mskhr(ils:ile,jls:jle) = rmskhr(ils:ile,jls:jle)

!-----------------------------------------------------------------------
!     read 3d data (x,y,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = ntrec
      ic(3) = 1
      ln = ic(1)*ic(2)*ic(3)
      call getvara ('flux_heat', iou, ln, is, ic
     &, stf(ils:ile,jls:jle,1), 41852., 0.)
      call getvara ('flux_salt', iou, ln, is, ic
     &, stf(ils:ile,jls:jle,2), 10., 0.)
      do n=3,nt
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call getvara ('flux_'//trim(a3), iou, ln, is, ic
     &,   stf(ils:ile,jls:jle,n), 1., 0.)
      enddo
      call getvara ('taux', iou, ln, is, ic, taux(ils:ile,jls:jle)
     &, 0.1, 0.)
      call getvara ('tauy', iou, ln, is, ic, tauy(ils:ile,jls:jle)
     &, 0.1, 0.)

      call getvara ('psi', iou, ln, is, ic, psi(ils:ile,jls:jle)
     &, 1.e-6, 0.)

!-----------------------------------------------------------------------
!     read 4d data (x,y,z,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = kls-kgs+1
      ic(3) = kle-kls+1
      is(4) = ntrec
      ic(4) = 1
      ln = ic(1)*ic(2)*ic(3)*ic(4)
      call getvara ('temp', iou, ln, is, ic
     &, t(ils:ile,jls:jle,kls:kle,1), 1., 273.15)
      call getvara ('salinity', iou, ln, is, ic
     &, t(ils:ile,jls:jle,kls:kle,2), 1000., 35.)
      do n=3,nt
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call getvara ('tracer_'//trim(a3), iou, ln, is, ic
     &,   t(ils:ile,jls:jle,kls:kle,n),1., 0.)
      enddo
      call getvara ('u', iou, ln, is, ic, u(ils:ile,jls:jle,kls:kle)
     &, 0.01, 0.)
      call getvara ('v', iou, ln, is, ic, v(ils:ile,jls:jle,kls:kle)
     &, 0.01, 0.)
      call getvara ('w', iou, ln, is, ic
     &, adv_vbt(ils:ile,jls:jle,kls:kle), 0.01, 0.)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end

      subroutine ocn_snap_out (fname, ids, ide, jds, jde, imt, jmt, km
     &,                        nt, xt, yt, zt, xu, yu, zw, dxt, dyt, dzt
     &,                        dxu, dyu, dzw, ntrec, timunit, expnam
     &,                        avgper, relyr, stamp, t, u, v, adv_vbt
     &,                        stf, taux, tauy

     &,                        psi

     &,                        kmt, mskhr, tm, um)
!=======================================================================
!     output routine for ocean time averages or 1

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension. data
!     should be defined with the routine defvar and written with putvar.
!     if  no time dimension, then data is only written once per file.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     dxt, dyt ...       = grid widths
!     ntrec              = number of time record (zero if not defined)
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     t, ...             = data to be written
!     tm                 = tracer grid mask
!     um                 = velocity grid mask

!   outputs:
!     ntrec              = number of time record in file

!   local variables
!     igs, ige, jgs, jge = global write domain start and end indicies
!     ig, jg             = global write domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for write on each axis (x,y,t default)
!     ic                 = count for write on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title, file_stamp
      character(3) :: a3

      integer i, iou, j, ln, n, ntrec, imt, jmt, km, nt
      integer ids, ide, jds, jde, igs, ige, ig, jgs, jge, jg, kgs, kge
      integer kg, ils, ile, jls, jle, kls, kle, is(10), ic(10), it(10)
      integer iu(10), id_time, id_xt, id_xu, id_yt, id_yu, id_zt, id_zw
      integer id_cat, id_xt_e, id_xu_e, id_yt_e, id_yu_e, id_zt_e
      integer id_zw_e, kmt(ids:ide,jds:jde), mskhr(ids:ide,jds:jde)
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real xt(imt), xu(imt), yt(jmt), yu(jmt), zt(km), zw(km), avgper
      real dxt(imt), dxu(imt), dyt(jmt), dyu(jmt), dzt(km), dzw(km)
      real t(ids:ide,jds:jde,km,nt), u(ids:ide,jds:jde,km)
      real v(ids:ide,jds:jde,km), adv_vbt(ids:ide,jds:jde,km)
      real stf(ids:ide,jds:jde,nt), taux(ids:ide,jds:jde)
      real tauy(ids:ide,jds:jde)

      real psi(ids:ide,jds:jde)

      real tm(ids:ide,jds:jde,km), um(ids:ide,jds:jde,km)
      real rkmt(ids:ide,jds:jde), rmskhr(ids:ide,jds:jde)
      real relyr, tmp(1), xt_e(imt+1), xu_e(imt+1), yt_e(jmt+1)
      real yu_e(jmt+1), zt_e(km+1), zw_e(km+1)

      logical defined

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = fname
      if (ntrec .eq. 0) defined = .false.
      call openfile (name, relyr, ntrec, iou)

!-----------------------------------------------------------------------
!     global write domain size (may be less than global domain)
!-----------------------------------------------------------------------

      igs = 2
      ige = imt-1

      ig  = ige-igs+1
      jgs = 1
      jge = jmt
      do j=2,jmt
        if (yt(j-1) .lt. -90. .and. yt(j) .gt. -90.) jgs = j
        if (yt(j-1) .lt.  90. .and. yt(j) .gt. 90.) jge = j-1
      enddo
      jg  = jge-jgs+1
      kgs = 1
      kge = km
      kg  = kge-kgs+1

      if (.not. defined .or. ntrec .eq. 0) then

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average'
        else
          title = 'Snapshot'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)
        call defdim ('xt', iou, ig, id_xt)
        call defdim ('yt', iou, jg, id_yt)
        call defdim ('zt', iou, kg, id_zt)
        call defdim ('xu', iou, ig, id_xu)
        call defdim ('yu', iou, jg, id_yu)
        call defdim ('zw', iou, kg, id_zw)
        call defdim ('xt_edges', iou, ig+1, id_xt_e)
        call defdim ('yt_edges', iou, jg+1, id_yt_e)
        call defdim ('zt_edges', iou, kg+1, id_zt_e)
        call defdim ('xu_edges', iou, ig+1, id_xu_e)
        call defdim ('yu_edges', iou, jg+1, id_yu_e)
        call defdim ('zw_edges', iou, kg+1, id_zw_e)

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, (/id_time/), 0., 0., 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif

!-----------------------------------------------------------------------
!       define 1d data (x, y or z)
!-----------------------------------------------------------------------
        call defvar ('xt', iou, 1, (/id_xt/), 0., 0., 'X', 'F'
     &,   'longitude of the t grid', 'grid_longitude', 'degrees_east')
        call defvar ('yt', iou, 1, (/id_yt/), 0., 0., 'Y', 'F'
     &,   'latitude of the t grid', 'grid_latitude', 'degrees_north')
        call defvar ('zt', iou, 1, (/id_zt/), 0., 0., 'Z', 'F'
     &,   'depth of the t grid', 'depth', 'm')
        call defvar ('xu', iou, 1, (/id_xu/), 0., 0., 'X', 'F'
     &,   'longitude of the u grid', 'grid_longitude', 'degrees_east')
        call defvar ('yu', iou, 1, (/id_yu/), 0., 0., 'Y', 'F'
     &,   'latitude of the u grid', 'grid_latitude', 'degrees_north')
        call defvar ('zw', iou, 1, (/id_zw/), 0., 0., 'Z', 'F'
     &,   'depth of the w grid', 'depth', 'm')
        call defvar ('xt_edges', iou, 1, (/id_xt_e/), 0., 0., 'X', 'F'
     &,   'longitude of t grid edges','grid_edge_longitude'
     &,   'degrees_east')
        call defvar ('yt_edges', iou, 1, (/id_yt_e/), 0., 0., 'Y', 'F'
     &,   'latitude of t grid edges', 'grid_edge_latitude'
     &,   'degrees_north')
        call defvar ('zt_edges', iou, 1, (/id_zt_e/), 0., 0., 'Z', 'F'
     &,   'depth of the t grid edges', 'edge_depth'
     &,   'degrees_north')
        call defvar ('xu_edges', iou, 1, (/id_xu_e/), 0., 0., 'X', 'F'
     &,   'longitude of u grid edges', 'grid_edge_longitude'
     &,   'degrees_east')
        call defvar ('yu_edges', iou, 1, (/id_yu_e/), 0., 0., 'Y', 'F'
     &,   'latitude of u grid edges', 'grid_edge_latitude'
     &,   'degrees_north')
        call defvar ('zw_edges', iou, 1, (/id_zw_e/), 0., 0., 'Z', 'F'
     &,   'depth of w grid edges', 'edge_depth'
     &,   'degrees_north')

!-----------------------------------------------------------------------
!       define 2d data (x,y)
!-----------------------------------------------------------------------
        it(1) = id_xt
        iu(1) = id_xu
        it(2) = id_yt
        iu(2) = id_yu
        call defvar ('kmt', iou, 2, it, 0., 1000., ' ', 'I'
     &,   'ocean grid depth level', ' ' ,'level')
        call defvar ('mskhr', iou, 2, it, 0., 1000., ' ', 'I'
     &,   'horizontal region mask', ' ' ,'number')

!-----------------------------------------------------------------------
!       define 3d data (x,y,t)
!-----------------------------------------------------------------------
        it(1) = id_xt
        iu(1) = id_xu
        it(2) = id_yt
        iu(2) = id_yu
        it(3) = id_time
        iu(3) = id_time
        call defvar ('flux_heat', iou, 3, it, -1.e4, 1.e4, ' ', 'F'
     &,   'surface downward heat flux'
     &,   'surface_downward_heat_flux_density', 'W m-2')
        call defvar ('flux_salt', iou,3, it, -100., 100., ' ', 'F'
     &,   'surface downward salt flux'
     &,   ' ', 'kg m-2 s-1')
        do n=3,nt
          if (n .lt. 1000) write(a3,'(i3)') n
          if (n .lt. 100) write(a3,'(i2)') n
          if (n .lt. 10) write(a3,'(i1)') n
          call defvar ('flux_'//trim(a3), iou ,3, it, -1.e4, 1.e4, ' '
     &,     'F', 'unknown tracer flux '//trim(a3)
     &,     'unknown_tracer_flux_'//trim(a3), 'unknown')
        enddo
        call defvar ('taux', iou, 3, iu, -1.e4, 1.e4, ' ', 'F'
     &,   'surface eastward momentum flux'
     &,   'surface_downward_eastward_stress', 'Pa')
        call defvar ('tauy', iou, 3, iu, -1.e4, 1.e4, ' ', 'F'
     &,   'surface northward momentum flux'
     &,   'surface_downward_northward_stress', 'Pa')

        call defvar ('psi', iou, 3, it, -1.e9, 1.e9, ' ', 'F'
     &,   'transport streamfunction'
     &,   'ocean_barotropic_streamfunction', 'm3 s-1')

!-----------------------------------------------------------------------
!       define time dependent 4d data (x,y,z,t)
!-----------------------------------------------------------------------
        it(1) = id_xt
        iu(1) = id_xu
        it(2) = id_yt
        iu(2) = id_yu
        it(3) = id_zt
        iu(3) = id_zt
        it(4) = id_time
        iu(4) = id_time
        call defvar ('temp', iou, 4, it, 100., 400., ' ', 'F'
     &,   'ocean potential temperature'
     &,   'sea_water_potential_temperature', 'K')
        call defvar ('salinity', iou, 4, it, 0., 50., ' ', 'F'
     &,   'ocean salinity', 'sea_water_salinity', 'psu')
        do n=3,nt
          if (n .lt. 1000) write(a3,'(i3)') n
          if (n .lt. 100) write(a3,'(i2)') n
          if (n .lt. 10) write(a3,'(i1)') n
          call defvar ('tracer_'//trim(a3), iou ,4, it, -1.e4, 1.e4, ' '
     &,     'F', 'unknown tracer '//trim(a3)
     &,     'unknown_tracer_'//trim(a3), 'unknown')
        enddo
        iu(3) = id_zt
        call defvar ('u', iou, 4, iu, -100., 100., ' ', 'F'
     &,   'eastward ocean velocity', 'eastward_sea_water_velocity'
     &,   'm s-1')
        call defvar ('v', iou, 4, iu, -100., 100., ' ', 'F'
     &,   'northward ocean velocity', 'northward_sea_water_velocity'
     &,   'm s-1')
        iu(3) = id_zw
        call defvar ('w', iou, 4, iu, -100., 100., ' ', 'F'
     &,   'upward ocean velocity', 'sea_water_upward_velocity'
     &,   'm s-1')

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0 ) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     local domain size (minimum of data domain and global write domain)
!-----------------------------------------------------------------------
      ils = max(ids,igs)
      ile = min(ide,ige)
      jls = max(jds,jgs)
      jle = min(jde,jge)
      kls = max(1,kgs)
      kle = min(km,kge)

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      tmp(1) = relyr
      call putvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp(1) = nyear
      call putvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmonth
      call putvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nday
      call putvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nhour
      call putvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmin
      call putvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nsec
      call putvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      if (avgper .gt. 1.e-6) then
        tmp(1) = avgper
        call putvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      endif

      if (ntrec .eq. 1 .or. .not. defined) then

!-----------------------------------------------------------------------
!       write 1d data (x, y or z)
!-----------------------------------------------------------------------
        call putvara ('xt', iou, ig, (/1/), (/ig/), xt(igs:ige), 1., 0.)
        call putvara ('yt', iou, jg, (/1/), (/jg/), yt(jgs:jge), 1., 0.)
        call putvara ('zt', iou, kg, (/1/), (/kg/), zt(kgs:kge), 0.01
     &  , 0.)
        call putvara ('xu', iou, ig, (/1/), (/ig/), xu(igs:ige), 1., 0.)
        call putvara ('yu', iou, jg, (/1/), (/jg/), yu(jgs:jge), 1., 0.)
        call putvara ('zw', iou, kg, (/1/), (/kg/), zw(kgs:kge), 0.01
     &  , 0.)
        call edge_maker (1, xt_e, xt, dxt, xu, dxu, imt)
        call putvara ('xt_edges', iou, ig+1, (/1/), (/ig+1/)
     &,   xt_e(igs:ige+1), 1., 0.)
        call edge_maker (1, yt_e, yt, dyt, yu, dyu, jmt)
        call putvara ('yt_edges', iou, jg+1, (/1/), (/jg+1/)
     &,   yt_e(jgs:jge+1), 1., 0.)
        call edge_maker (1, zt_e, zt, dzt, zw, dzw, km)
        call putvara ('zt_edges', iou, kg+1, (/1/), (/kg+1/)
     &,   zt_e(kgs:kge+1), 0.01, 0.)
        call edge_maker (2, xu_e, xt, dxt, xu, dxu, imt)
        call putvara ('xu_edges', iou, ig+1, (/1/), (/ig+1/)
     &,   xu_e(igs:ige+1), 1., 0.)
        call edge_maker (2, yu_e, yt, dyt, yu, dyu, jmt)
        call putvara ('yu_edges', iou, jg+1, (/1/), (/jg+1/)
     &,   yu_e(jgs:jge+1), 1., 0.)
        call edge_maker (2, zw_e, zt, dzt, zw, dzw, km)
        call putvara ('zw_edges', iou, kg+1, (/1/), (/kg+1/)
     &,   zw_e(kgs:kge+1), 0.01, 0.)

!-----------------------------------------------------------------------
!       write 2d data (x,y)
!-----------------------------------------------------------------------
        is(1) = ils-igs+1
        ic(1) = ile-ils+1
        is(2) = jls-jgs+1
        ic(2) = jle-jls+1
        ln = ic(1)*ic(2)
        rkmt(ils:ile,jls:jle) = kmt(ils:ile,jls:jle)
        call putvara ('kmt', iou, ln, is, ic, rkmt(ils:ile,jls:jle)
     &,   1., 0.)
        rmskhr(ils:ile,jls:jle) = mskhr(ils:ile,jls:jle)
        call putvara ('mskhr', iou, ln, is, ic, rmskhr(ils:ile,jls:jle)
     &,   1., 0.)

      endif

!-----------------------------------------------------------------------
!     write 3d data (x,y,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = ntrec
      ic(3) = 1
      ln = ic(1)*ic(2)*ic(3)
      call putvaramsk('flux_heat', iou, ln, is, ic
     &, stf(ils:ile,jls:jle,1), tm(ils:ile,jls:jle,1), 41852., 0.)
      call putvaramsk('flux_salt', iou, ln, is, ic
     &, stf(ils:ile,jls:jle,2), tm(ils:ile,jls:jle,1), 10., 0.)
      do n=3,nt
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call putvaramsk('flux_'//trim(a3), iou, ln, is, ic
     &,   stf(ils:ile,jls:jle,n), tm(ils:ile,jls:jle,1), 1., 0.)
      enddo
      call putvaramsk ('taux', iou, ln, is, ic, taux(ils:ile,jls:jle)
     &, um(ils:ile,jls:jle,1),0.1, 0.)
      call putvaramsk ('tauy', iou, ln, is, ic, tauy(ils:ile,jls:jle)
     &, um(ils:ile,jls:jle,1), 0.1, 0.)

      call putvaramsk ('psi', iou, ln, is, ic, psi(ils:ile,jls:jle)
     &, tm(ils:ile,jls:jle,1), 1.e-6, 0.)

!-----------------------------------------------------------------------
!     write 4d data (x,y,z,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = kls-kgs+1
      ic(3) = kle-kls+1
      is(4) = ntrec
      ic(4) = 1
      ln = ic(1)*ic(2)*ic(3)*ic(4)
      call putvaramsk('temp', iou, ln, is, ic
     &, t(ils:ile,jls:jle,kls:kle,1), tm(ils:ile,jls:jle,kls:kle)
     &, 1., 273.15)
      call putvaramsk('salinity', iou, ln, is, ic
     &, t(ils:ile,jls:jle,kls:kle,2), tm(ils:ile,jls:jle,kls:kle)
     &, 1000., 35.)
      do n=3,nt
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call putvaramsk('tracer_'//trim(a3), iou, ln, is, ic
     &,   t(ils:ile,jls:jle,kls:kle,n), tm(ils:ile,jls:jle,kls:kle)
     &,   1., 0.)
      enddo
      call putvaramsk ('u', iou, ln, is, ic, u(ils:ile,jls:jle,kls:kle)
     &, um(ils:ile,jls:jle,kls:kle), 0.01, 0.)
      call putvaramsk ('v', iou, ln, is, ic, v(ils:ile,jls:jle,kls:kle)
     &, um(ils:ile,jls:jle,kls:kle), 0.01, 0.)
      call putvaramsk ('w', iou, ln, is, ic
     &, adv_vbt(ils:ile,jls:jle,kls:kle)
     &, um(ils:ile,jls:jle,kls:kle), 0.01, 0.)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
