! source file: /den/eby/UVic_ESCM/2.6/source/embm/riv.h
!====================== include file "riv.h" ===========================

!     parameters for use in the river model

!     maxnb   = maximum number of basins
!     maxnbp  = maximum number of land points (all basins)
!     maxndp  = maximum number of discharge points (all basins)
!     rivname = river (or basin) name
!     nb      = number of basins
!     nbp     = number of land points (all basins)
!     ibp     = indices for basin points
!     ndp     = number of discharge points (all basins)
!     idp     = indices for discharge points
!     wdar    = inverse of weighted discharge area
!     psum    = total discharge for a basin
!     ta_psum = time average total discharge for a basin

      integer maxnb, maxnbp, maxndp
      parameter (maxnb=40, maxnbp=5000, maxndp=2000)

      character(15) :: rivname(maxnb)
      common /river_c/ rivname

      integer nb, nbp, ndp, ibp, idp
      common /river_i/ nb, nbp, ndp, ibp(maxnbp,3), idp(maxndp,3)

      real psum, wdar, ta_psum
      common /river_r/ psum(maxnb), wdar(maxndp)

      common /river_r/ ta_psum(maxnb)

