! source file: /den/eby/UVic_ESCM/2.6/source/embm/setembm.F
      subroutine setembm

!=======================================================================
!     initialize the energy-moisture balance model
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "solve.h"
      include "switch.h"
      include "coord.h"
      include "grdvar.h"
      include "atm.h"
      include "cembm.h"

      include "ice.h"

      include "evp.h"

      include "riv.h"
      include "tmngr.h"
      include "levind.h"
      include "mapsbc.h"
      include "csbc.h"
      include "scalar.h"

      integer i, ie, ii, iou, is, j, je, jj, js, jz, k, m, n, nsolve, nu
      integer nsum, ntrec

      real astl, asul, ctl, dn_s(nat), de_s(nat), dlam, dphi, dtatms
      real dte, dyz, eccice, esatm_s, grarea, saltmax, si, solins_s
      real stl, sul, t1, time, tlat_s, ulat_s, yz_max, yz_min, wz, zrel

      namelist /tsteps/ dtts, dtuv, dtsf, dtatm, dtatms, namix, segtim
      namelist /co2/    co2ccn, co2yri, co2yrf, co2rate, co2for
      namelist /paleo/  pyear
      namelist /ice/    niats, nivts, dampice, tsno, hsno_max
      namelist /adv_q/  diffactor

      is = 1
      ie = imt
      js = 1
      je = jmt

!-----------------------------------------------------------------------
!     define default parameters
!-----------------------------------------------------------------------

!     set defaults namelist co2
      co2ccn     = 350
      co2yri     = 1.e20
      co2yrf     = 1.e20
      co2rate    = 0.
      co2for     = 5.77e03

!     set defaults namelist paleo
      pyear      = 0.

!     set defaults namelist ice
      niats      = 1
      nivts      = 1
      dampice    = 5.
      tsno       = -5.
      hsno_max   = 1000.

!     set defaults namelist adv_q
      diffactor  = 50.

!     set other stuff
      solarconst = 1.368e6
      scatter    = 0.30
      pass       = 1. - scatter

      ssp        = 1.e6
      cdatm      = 1.e-3
      cpatm      = 1.004e7
      ht         = 8.4e5
      hq         = 1.8e5
      rhoatm     = 1.250e-3
      rlapse     = 6.5e-5

      rhoocn     = 1.035
      esocn      = 5.347e-5
      vlocn      = 2.501e10
      socn       = 34.9e-3

      cdice      = 5.5e-3
      rhoice     = 0.913
      rhosno     = 0.330
      esice      = 5.347e-5
      slice      = 2.835e10
      flice      = 3.34e9
      condice    = 2.1656e5

      soilmax    = 15.
      eslnd      = 5.347e-5
      cs_alb     = 0.08
      ice_calb   = 0.45
      sno_calb   = 0.35

      nivc       = 1
      dtatms     = 1800.
      ns         = 30

      call getunit (iou, 'control.in', 'f s r')
      read  (iou, tsteps, end=100)
100   continue
      write (stdout, tsteps)
      call relunit (iou)

      call getunit (iou, 'control.in', 'f s r')
      read  (iou, co2, end=102)
102   continue
      write (stdout,co2)
      call relunit (iou)
      co2ccni = co2ccn

      call getunit (iou, 'control.in', 'f s r')
      read  (iou, paleo, end=103)
103   continue
      write (stdout,paleo)
      call relunit (iou)

      call getunit (iou, 'control.in', 'f s r')
      read  (iou, ice, end=104)
104   continue
      write (stdout,ice)
      call relunit (iou)

      call getunit (iou, 'control.in', 'f s r')
      read  (iou, adv_q, end=105)
105   continue
      write (stdout,adv_q)
      call relunit (iou)

      if (mod(timavgint, segtim) .gt. 1.e-6 .and. timavgint .gt. 0.)
     &  then
        t1 = nint(timavgint/segtim)*segtim
        if (t1 .lt. segtim) t1 = segtim
        write (stdout,'(/,(1x,a))')
     &    '==> Warning: "timavgint" does not contain an integral number'
     &,   '              of coupling time steps "segtim".              '
        write (stdout,*) '              (changed "timavgint" from '
     &, timavgint,' days to ', t1,' days to insure this condition)'
        timavgint = t1
      endif
      if (timavgint .eq. 0.) then
        write (stdout,'(/,(1x,a))')
     &    '==> Warning: averaging interval "timavgint" = 0. implies no '
     &,   '             averaging when "time_averages" is enabled      '
      endif
      if (timavgint .gt. timavgper) then
        write (stdout,'(/,(1x,a))')
     &    '==> Warning: the interval "timavgint" exceeds the averaging '
     &,   '             period "timavgper" for option "time_averages"  '
      endif
      if (timavgint .lt. timavgper) then
        write (stdout,'(/,(1x,a))')
     &    '==> Warning: averaging period "timavgper" exceeds interval  '
     &,   '             "timavgint". Setting timavgper = timavgint     '
        timavgper = timavgint
      endif
      if (timavgper .eq. 0.) then
        write (stdout,'(/,(1x,a))')
     &    '==> Warning: the averaging period "timavgper" is zero. The  '
     &,   '             average will be over only one time step!       '
      endif
      write (stdout,'(/,1x,a,f10.2,a,/,1x,a,f10.2,a)')
     &  '==> Time averages will be written every ', timavgint, ' days, '
     &, '    with an averaging period of         ', timavgper, ' days. '

!-----------------------------------------------------------------------
!     calculate the relative CO2 forcing term
!-----------------------------------------------------------------------

      call co2forc

      write(stdout,*)
      write(stdout,*) 'CO2 concentration (versus today) =',co2ccn/350.
      write(stdout,*) 'Yields radiative forcing (W/m2) = ',anthro*1.e-3

!-----------------------------------------------------------------------
!     calculate the expansion coefficients for Berger's solution for
!     the year of the initial conditions
!-----------------------------------------------------------------------

      call berger (pyear)

!-----------------------------------------------------------------------
!     calculate latitude dependent variables
!-----------------------------------------------------------------------

      radian = 360./(2.*pi)

      do j=1,jmt
!-----------------------------------------------------------------------
!       calculate coriolis parameter
!-----------------------------------------------------------------------

        fcor(j) = 2.*omega*sine(j)
        tlat_s = yt(j)
        stl = sin(yt(j)/radian)
        ctl = cos(yt(j)/radian)
        ulat_s = yu(j)
        sul = sin(yu(j)/radian)

          astl = abs(stl)
          asul = abs(sul)

!-----------------------------------------------------------------------
!         calculate annual average insolation
!-----------------------------------------------------------------------

          solins_s = 0.
          do n=1, 365
            call insolation (float(n), tlat_s, si)
            solins_s = solins_s + si
          enddo
          solins_s = (solins_s + 0.25*si) /365.25

!-----------------------------------------------------------------------
!         planetary and atmospheric emissivity
!-----------------------------------------------------------------------

          esatm_s = 5.57e-5*(0.8666 + 0.0408*stl - 0.2553*stl**2
     &               - 0.4660*stl**3 + 0.9877*stl**4 + 2.0257*stl**5
     &               - 2.3374*stl**6 - 3.1990*stl**7 + 2.8581*stl**8
     &               + 1.6070*stl**9 -1.2685*stl**10)

!-----------------------------------------------------------------------
!         diffusivities
!-----------------------------------------------------------------------

          do n=1,nat

            if (n .eq. 1) then
              dn_s(1) = 3.e10*(1.3 - 1.1*asul**2 + .15*sul)
              de_s(1) = 3.e10*(1.3 - 1.1*astl**2 + .15*stl)
            endif
            if (n .eq. 2) then
              dn_s(2) = 1.e10
              de_s(2) = 1.e10
            endif

            if (n .ge. 3) then
              dn_s(n) = 1.e10
              de_s(n) = 1.e10
            endif
          enddo

!-----------------------------------------------------------------------
!         load grid latitude dependent arrays
!-----------------------------------------------------------------------

        solins(j) = solins_s
        esatm(j) = esatm_s

        do n=1,nat
          dn(j,n) = dn_s(n)
          de(j,n) = de_s(n)
        enddo

      enddo

!     set solver parameters

      nsolve = 0

      itin(1:nat)  = 100        ! max solver iterations
      epsin(1) = 1.e-4         ! solver tolerance
      epsin(2:nat) = 1.0e-11    ! solver tolerance

      nsolve = nsolve + 1

      if (nsolve .ne. 1) then
        write(*,*) '==> Error: more or less than one solver defined.'
        write(*,*) '           Use only one of uvic_embm_adi,'
     &,   ' uvic_embm_mgrid, uvic_embm_slap, uvic_embm_essl or'
     &,   ' uvic_embm_explicit'
        stop '=>setembm'
      endif

!-----------------------------------------------------------------------
!     check latent heats will sum to zero
!-----------------------------------------------------------------------

      if (slice .ne. vlocn + flice) write (stdout,'(/,a)')
     &   '==> Warning: changing latent heat of fusion to conserve heat'
        flice = slice - vlocn

!-----------------------------------------------------------------------
!     initialize the river model
!-----------------------------------------------------------------------

      call rivinit

!-----------------------------------------------------------------------
!     calculate grid terms for the atmospheric solver
!-----------------------------------------------------------------------

      do j=2,jmtm1
        dsgrd(j) = csu(j-1)/(dyu(j-1)*cst(j)*dyt(j))
        dngrd(j) = csu(j)/(dyu(j)*cst(j)*dyt(j))
        asgrd(j) = csu(j-1)/(2.*cst(j)*dyt(j))
        angrd(j) = csu(j)/(2.*cst(j)*dyt(j))

      enddo

      do i=2,imtm1
        dwgrd(i) = 1./(dxu(i-1)*dxt(i))
        degrd(i) = 1./(dxu(i)*dxt(i))
        azgrd(i) = 1./(2.*dxt(i))

      enddo

!-----------------------------------------------------------------------
!     set surface coalbedo to zero
!-----------------------------------------------------------------------

      do j=1,jmt
        do i=1,imt
          s_calb(i,j) = 0.
        enddo
      enddo
      pcfactor = 0.

      do jz=1,jmt

        area_z(jz) = epsln
        s_alb_z(jz) = 0.
      enddo

!     convert to coalbedo and find weights for zonal averaging
      do j=1,jmt
        do i=1,imt
          s_calb(i,j) = c1 - s_calb(i,j)

       enddo
      enddo

!     calculate zonal average snow free albedo. s_calb may then be
!     changed but the constant zonal average, s_alb_z should not.
      do j=2,jmtm1
        do i=2,imtm1
          grarea = dxt(i)*dyt(j)*cst(j)

          area_z(j) = area_z(j) + grarea
          s_alb_z(j) = s_alb_z(j) + s_calb(i,j)*grarea
        enddo
!       ensure zonal surface albedo is between zero and one.
        s_alb_z(j) = c1 - min(max(s_alb_z(j)/area_z(j), 0.), c1)
      enddo

!     ensure pass is between zero and one.
      pass = min(max(pass, epsln), c1-epsln)

!-----------------------------------------------------------------------
!     set initial conditions or read a restart
!-----------------------------------------------------------------------

      newcoef(:,:) = .true.

      if (init) then
        nats = namix
        irstdy = 0
        msrsdy = 0
        at(:,:,:,:) = 0.
        at(:,:,:,1) = 10.
        at(:,:,:,2) = 0.01

        avgp(:,:) = 0.

        hice(:,:,1) = 0.
        hice(:,:,2) = 0.
        aice(:,:,1) = 0.
        aice(:,:,2) = 0.
        tice(:,:) = 0.
        hsno(:,:,1) = 0.
        hsno(:,:,2) = 0.

        uice(:,:) = 0.
        vice(:,:) = 0.
        sig11n(:,:) = 0.
        sig11e(:,:) = 0.
        sig11s(:,:) = 0.
        sig11w(:,:) = 0.
        sig22n(:,:) = 0.
        sig22e(:,:) = 0.
        sig22s(:,:) = 0.
        sig22w(:,:) = 0.
        sig12n(:,:) = 0.
        sig12e(:,:) = 0.
        sig12s(:,:) = 0.
        sig12w(:,:) = 0.

        bv(:) = 0.
        xv(:) = 0.

        raux(:) = 0.
        iaux(:) = 0

      else

        call atm_rest_in ('restatm.nc', is, ie, js, je)

      endif

      flux(:,:,:) = 0.0

!-----------------------------------------------------------------------
!     read any atmospheric forcing data
!-----------------------------------------------------------------------

      call setatm

!-----------------------------------------------------------------------
!     read land elevations
!-----------------------------------------------------------------------

      time = 0.
      ntrec = 1
      call openfile ('data/elev.nc', time, ntrec, iou)
      call getvara ('elev', iou, imt*jmt, (/1,1/)
     &,            (/imt,jmt/), elev, 0.01, 0.)
      call closefile (iou)
!     check for negative elevations
      do j=1,jmt
        do i=1,imt
          if (elev(i,j) .lt. 0.) elev(i,j) = 0.
        enddo
      enddo

!-----------------------------------------------------------------------
!     calculate albedo
!-----------------------------------------------------------------------

      call albedo

!-----------------------------------------------------------------------
!     calculate B grid ice masks
!-----------------------------------------------------------------------

      do j=1,jmtm1
        do i=1,imtm1
          tm(i,j) = 0.
          um(i,j) = 0.
          if (kmt(i,j) .gt. 0) tm(i,j) = 1.
          if (kmu(i,j) .gt. 0) um(i,j) = 1.
        enddo
      enddo
      call embmbc (tm)
      call embmbc (um)

      dlam = dxu(int(imt/2))/100.
      dphi = dyu(int(jmt/2))/100.
      diff1 = 0.004
      diff1 = diff1*dlam
      diff2 = diff1*dlam**2

!----------------------------------------------------------------------
!     initialize elastic viscous plastic variables
!-----------------------------------------------------------------------

      eccice = 10.
      ecc2 = 1./(eccice**2)
      ecc2m = 2.*(1.-ecc2)
      ecc2p = (1.+ecc2)
      zetamin = 4.e11
      eyc = 0.25
      dte = dtatm/float(ndte)
      dtei = 1./dte
      floor = 1.e-11
      do j=2,jmtm1
        do i=2,imtm1
           xyminevp=(min(cst(j)*dxt(i),dyt(j)))**2
        enddo
      enddo

!-----------------------------------------------------------------------
!     check for even flux averaging
!-----------------------------------------------------------------------

      if (mod(namix,2) .ne. mod(nint(segtim*86400./dtatm),2)) then
        write(*,*) '==> Error: time steps between mixing and coupling'
     &, ' must both be even to use uvic_embm_even_fluxes.'
        stop '=>setembm'
      endif

      if (mod(namix,2) .ne. mod(nats,2)) then
        write(*,*) '==> Warning: restart was not saved with even flux'
     &, ' averaging. Starting with a mixing time step.'
        nats = namix
      endif

!-----------------------------------------------------------------------
!     check ice velocity calculation
!-----------------------------------------------------------------------

      if (nivts .gt. nint(segtim*86400./dtatm)) then
        write(*,*) '==> Warning: ice velocities will be calculated '
     &, 'every coupling time.'
        nivts =  nint(segtim*86400./dtatm)
      endif

!-----------------------------------------------------------------------
!     zero time average accumulators
!-----------------------------------------------------------------------

      call ta_atm_snap (is, ie, js, je, 0)

!-----------------------------------------------------------------------
!     zero integrated time average accumulators
!-----------------------------------------------------------------------

      call ta_atm_tsi (0)

      return
      end
