! source file: /den/eby/UVic_ESCM/2.6/source/embm/solve.h
!====================== include file "solve.h" ==========================

!     variables needed for solving atmospheric advection and diffusion

!     newcoef = logical flag for calculating new coefficients

      logical newcoef(2,nat)
      common /solver_l/ newcoef

      integer iimtm2, jjmtm2, nord, nelm, nraux, niaux, naux1, naux2

      parameter (iimtm2 = imtm2)

      parameter (jjmtm2 = jmtm2)

      parameter (nord = iimtm2*jjmtm2)

!     itin    = requested maximum iterations
!     itout   = actual iterations
!     newcoef = logical flag for calculating new coefficients
!     bv      = right hand side vector (b)
!     xv      = left hand side vector (x)
!     epsin   = requested maximum error
!     epsout  = actual error

      integer itin(nat), itout(nat)
      common /solver_i/ itin, itout

      real bv, xv, epsin, epsout
      common /solver_r/ bv(nord), xv(nord), epsin(nat), epsout(nat)

!     for slap routines storage is by row and column index
!     ia     = row index
!     ja     = column index
!     nelm   = number of nonzero elements in A
!     niaux  = size of integer work space
!     iaux   = integer work space
!     nraux  = size of real work space
!     ar     = coefficient matrix (stored form of A)
!     raux   = real work space

      parameter (nelm = 3*nord + 2*iimtm2*(jjmtm2 - 1))
      parameter (nraux = nelm + 16*nord + 132)
      parameter (niaux = nelm + 3*nord + 33)

      integer ia, ja, iaux
      common /solver_i/ ia(nelm), ja(nelm), iaux(niaux)

      real ar, raux
      common /solver_r/  ar(nelm,2,nat), raux(nraux)

!     grid terms for the atmospheric solver

      real dwgrd, degrd, azgrd, dsgrd, dngrd, asgrd, angrd
      common /solve_r/ dwgrd(2:imtm1), degrd(2:imtm1), azgrd(2:imtm1)
      common /solve_r/ dsgrd(2:jmtm1), dngrd(2:jmtm1), asgrd(2:jmtm1)
      common /solve_r/ angrd(2:jmtm1)

