! source file: /usr/local/models/UVic_ESCM/2.6/source/embm/atm.h
!====================== include file "atm.h" ===========================

!     arrays for the energy-moisture balance model

!     note: units for heat flux are: g s-3 (or mW m-2)
!           units for fresh water flux are in g cm-2 s-1
!           downward is into the top surface (ocean, ice or land)
!           upward is into the bottom of the atmosphere
!           outward is out of the top of the atmosphere
!           inward is into the top of the atmosphere

!     at        = tracers (previous and most recent)
!     elev      = elevations (cm)
!     surf      = surface values (1=temperature, 2=humidity)
!     flux      = downward flux accumulator (1=heat, 2=fresh water, ...)
!     taux      = x component of wind stress data (dynes cm-2)
!     tauy      = y component of wind stress data (dynes cm-2)
!     wx        = x component of wind data (cm s-1)
!     wy        = y component of wind data (cm s-1)
!     ws        = wind speed data (cm s-1)
!     ssh       = saturation specific humidity (%/100)
!     s_calb    = snow free surface coalbedo (%/100)
!     s_alb_z   = constant zonal snow free surface albedo (%/100)
!     a_calb    = atmospheric coalbedo (%/100)
!     dn        = northward atmospheric tracer diffusivity
!     de        = eastward atmospheric tracer diffusivity
!     esatm     = atmosphere emissivity times Stefan's constant
!     fcor      = Coriolis factor
!   rotated grid ("rot_grid")
!     wt_zonal  = weights for zonal averages
!     yz_z      = latitudes for zonal averages
!     area_z    = areas for zonal averages
!   heat fluxes
!     solins    = incoming short wave radiation (g s-3)
!     dnswr     = downward surface shortwave flux (g s-3)
!     uplwr     = upward surface longwave flux (g s-3)
!     upsens    = upward surface sensible heat flux (g s-3)
!     upltnt    = upward surface latent heat flux (g s-3)
!     outlwr    = outgoing atmosphere longwave flux (g s-3)
!   fresh water fluxes
!     precip    = precipitation (g cm-2 s-1)
!     evap      = evaporation (g cm-2 s-1)
!   moisture advection ("uvic_embm_adv_q")
!     avgp      = segtim average precipitation (g cm-2 s-1)
!     accp      = accumulator for precipitation (g cm-2 s-1)
!   land model ("uvic_embm_land")
!     runoff    = water runoff from continents
!     soilm     = soil moisture, as depth in bucket (g cm -2)
!   annual average temperature ("uvic_embm_running_average")
!     rtbar     = running average atmospheric temperature (C)
!     atbar     = average temperature accumulator (C)
!   windstress feedback ("uvic_embm_atress")
!     awx       = anomalous x component of wind (cm s-1)
!     awy       = anomalous y component of wind (cm s-1)
!     tbar      = climatological average atmospheric temperature (C)
!   flux adjustment ("uvic_save_flxadj")
!     flxadj    = flux adjustment

      real at, elev, surf, flux, taux, tauy, wx, wy, ws, ssh
      real s_calb, s_alb_z, a_calb, dn, de, esatm, fcor, solins
      real wt_zonal, yz, area_z, dnswr, uplwr, upsens, upltnt, outlwr
      real precip, evap, avgp, accp, runoff, soilm, rtbar, atbar, awx
      real awy, tbar, flxadj

      common /atm_r/ at(imt,jmt,nat,2), elev(imt,jmt), surf(imt,jmt,nat)

      common /atm_r/ flux(imt,jmt,nat+2), ssh(imt,jmt)

      common /atm_r/ s_calb(imt,jmt), s_alb_z(jmt), a_calb(imt,jmt)

      common /atm_r/ dn(jmt,nat), de(jmt,nat)

      common /atm_r/ esatm(jmt), fcor(jmt), solins(jmt), area_z(jmt)

      common /atm_r/ dnswr(imt,jmt), uplwr(imt,jmt), upsens(imt,jmt)
      common /atm_r/ upltnt(imt,jmt), outlwr(imt,jmt), precip(imt,jmt)
      common /atm_r/ evap(imt,jmt)

      common /atm_r/ avgp(imt,jmt), accp(imt,jmt)

!   time averaged arrays
!     ta_at         = time averaged atmospheric tracers
!     ta_outlwr     = time averaged outgoing longwave flux
!     ta_uplwr      = time averaged upward longwave flux
!     ta_dnswr      = time averaged downward shortwave flux
!     ta_upsens     = time averaged upward sensible heat flux
!     ta_upltnt     = time averaged upward latent heat flux
!     ta_precip     = time averaged precipitation
!     ta_evap       = time averaged evaporation
!     ta_s_calb     = time averaged surface coalbedo
!     ta_a_calb     = time averaged atmospheric coalbedo
!     ta_ws         = time averaged surface wind speed
!   bucket model ("uvic_embm_land")
!     ta_soilm      = time averaged soil moisture
!     ta_runoff     = time averaged runoff
!     ta_surf       = time averaged surface temperature
!   moisture advection ("uvic_embm_adv_q")
!     ta_wx         = time averaged x component of wind
!     ta_wy         = time averaged y component of wind
!   windstress feedback ("uvic_embm_astress")
!     ta_awx        = time averaged x component of wind
!     ta_awy        = time averaged y component of wind
!   flux adjustment
!     flxadj        = time averaged flux adjustment
!   uncoupled
!     ta_hflux      = time averaged heat flux
!     ta_sflux      = time averaged salt flux
!     ta_sss        = time averaged sea surface salinity
!     ta_sst        = time averaged sea surface temperature
!     ta_taux       = time averaged x component of wind stress
!     ta_tauy       = time averaged x component of wind stress

      real ta_at, ta_outlwr, ta_uplwr, ta_dnswr, ta_upsens, ta_upltnt
      real ta_precip, ta_evap, ta_s_calb, ta_a_calb, ta_soilm
      real ta_runoff, ta_surf, ta_wx, ta_wy, ta_awx, ta_awy, ta_flxadj
      real ta_hflux, ta_sflux, ta_sss, ta_sst, ta_taux, ta_tauy

      common /atm_r/ ta_at(imt,jmt,nat), ta_outlwr(imt,jmt)
      common /atm_r/ ta_uplwr(imt,jmt), ta_dnswr(imt,jmt)
      common /atm_r/ ta_upsens(imt,jmt), ta_upltnt(imt,jmt)
      common /atm_r/ ta_precip(imt,jmt), ta_evap(imt,jmt)
      common /atm_r/ ta_s_calb(imt,jmt), ta_a_calb(imt,jmt)

      common /atm_r/ ta_wx(imt,jmt), ta_wy(imt,jmt)

