! source file: /usr/local/models/UVic_ESCM/2.6/source/embm/atm_tsi.F
      subroutine atm_tsi_in (fname, ntrec, timunit, expnam, avgper
     &,                      relyr, stamp, sat, shum, hflx, wflx
     &,                      v_oice, v_snow, v_lice, co2ccn, scan)
!=======================================================================
!     output routine for atmospheric time step integrals

!   inputs:
!     fname     = file name
!     ntrec     = number of time record (zero if not defined)

!   outputs:
!     timunit   = time unit
!     expnam    = experiment name
!     avgper    = length of averaging period
!     relyr     = time in years
!     stamp     = time stamp
!     sat, ...  = data to be read

!   local variables
!     iou       = io unit (ncid)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title

      integer i, id_time, iou, ntrec
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real sat, shum, hflx, wflx, v_oice, v_snow, v_lice, co2ccn, scan
      real avgper, relyr, tmp(1)

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      name = fname
      i = 0
      call openfile (name, relyr, i, iou)

!-----------------------------------------------------------------------
!     get global attributes
!-----------------------------------------------------------------------
      call getglobal (iou, fname, title, expnam, timunit)

!-----------------------------------------------------------------------
!     read 1d data (t)
!-----------------------------------------------------------------------
      call getvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      relyr = tmp(1)
      call getvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nyear = tmp(1)
      call getvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmonth = tmp(1)
      call getvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nday = tmp(1)
      call getvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nhour = tmp(1)
      call getvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmin = tmp(1)
      call getvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nsec = tmp(1)
      call mkstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      call getvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      avgper = tmp(1)
      call getvara ('sat', iou, 1, (/ntrec/), (/1/), tmp, 1., 273.15)
      sat = tmp(1)
      call getvara ('shum', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
       shum = tmp(1)
      call getvara ('heat_flux', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-3, 0.)
       hflx = tmp(1)
      call getvara ('water_flux', iou, 1, (/ntrec/), (/1/), tmp
     &, 10., 0.)
       wflx = tmp(1)
      call getvara ('co2ccn', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
       co2ccn = tmp(1)
      call getvara ('maxit', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      scan = tmp(1)

      call getvara ('sea_ice_volume', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-6, 0.)
       v_oice = tmp(1)
      call getvara ('snow_volume', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-6, 0.)
       v_snow = tmp(1)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end

      subroutine atm_tsi_out (fname, ntrec, timunit, expnam, avgper
     &,                       relyr, stamp, sat, shum, hflx, wflx
     &,                        v_oice, v_snow, v_lice, co2ccn, scan)
!=======================================================================
!     output routine for atmospheric time step integrals

!   inputs:
!     fname     = file name
!     ntrec     = number of time record (zero if not defined)
!     timunit   = time unit
!     expnam    = experiment name
!     avgper    = length of averaging period
!     relyr     = time in years
!     stamp     = time stamp
!     sat, ...  = data to be written

!   outputs:
!     ntrec     = number of time record in file

!   local variables
!     iou       = io unit (ncid)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title

      integer id_time, iou, ntrec
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real sat, shum, hflx, wflx, v_oice, v_snow, v_lice, co2ccn, scan
      real avgper, relyr, tmp(1)

      logical defined

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = fname
      if (ntrec .eq. 0) defined = .false.
      call openfile (name, relyr, ntrec, iou)

      if (.not. defined .or. ntrec .eq. 0) then

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average Time Step Integrals'
        else
          title = 'Time Step Integrals'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, (/id_time/), 0., 0., 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif
        call defvar ('sat', iou, 1, (/id_time/), 200., 400., ' ', 'F'
     &,   'global average surface air temperature', ' ', 'K')
        call defvar ('shum', iou, 1, (/id_time/), -100., 100., ' ', 'F'
     &,   'global average surface specific humidity', ' ', '1')
        call defvar ('heat_flux', iou, 1, (/id_time/), -100., 100., ' '
     &,   'F', 'global average surface heat flux', ' ', 'W m-2')
        call defvar ('water_flux', iou, 1, (/id_time/), -100., 100., ' '
     &,   'F', 'global average fresh water flux', ' ','kg m-2 s-1')
        call defvar ('co2ccn', iou, 1, (/id_time/), 0., 1.e3, ' '
     &,   'F', 'CO2 concentration', ' ','ppm')
        call defvar ('maxit', iou, 1, (/id_time/), 0., 1.e3, ' '
     &,   'F', 'maximum atmosphere solver iterations', ' ','')

        call defvar ('snow_volume', iou, 1, (/id_time/), 0., 1.e20, ' '
     &,   'F', 'global snow volume', ' ', 'm3')
        call defvar ('sea_ice_volume', iou, 1, (/id_time/), 0., 1.e20
     &,   ' ', 'F', 'global sea ice volume', ' ', 'm3')

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0 ) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      tmp(1) = relyr
      call putvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp(1) = nyear
      call putvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmonth
      call putvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nday
      call putvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nhour
      call putvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmin
      call putvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nsec
      call putvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      if (avgper .gt. 1.e-6) then
        tmp(1) = avgper
        call putvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      endif
      tmp(1) = sat
      call putvara ('sat', iou, 1, (/ntrec/), (/1/), tmp, 1., 273.15)
      tmp(1) = shum
      call putvara ('shum', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = hflx
      call putvara ('heat_flux', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-3, 0.)
      tmp(1) = wflx
      call putvara ('water_flux', iou, 1, (/ntrec/), (/1/), tmp
     &, 10., 0.)
      tmp(1) = co2ccn
      call putvara ('co2ccn', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = scan
      call putvara ('maxit', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)

      tmp(1) = v_oice
      call putvara ('sea_ice_volume', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-6, 0.)
      tmp(1) = v_snow
      call putvara ('snow_volume', iou, 1, (/ntrec/), (/1/), tmp
     &, 1.e-6, 0.)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
