! source file: /usr/local/models/UVic_ESCM/2.6/source/mom/diag.F
      subroutine diag (joff, js, je, is, ie)

!=======================================================================
!     calculate diagnostics

!     input:

!      joff   = offset between row j in the MW and latitude jrow on disk
!      js     = starting row for calculations
!      je     = ending row for calculations
!      is     = starting longitude index for calculations
!      ie     = ending longitude index for calculations
!=======================================================================

      include "param.h"
      include "coord.h"

      include "cregin.h"
      include "diag.h"
      include "diaga.h"
      include "docnam.h"
      include "grdvar.h"
      include "iounit.h"
      include "isopyc.h"
      include "mw.h"
      include "scalar.h"
      include "switch.h"
      include "tmngr.h"
      include "vmixc.h"
      include "levind.h"
      include "emode.h"

      character(80) :: fsnap, file_stamp
      save fsnap
      data fsnap /' '/

      integer ntrec

      dimension vbarx(km)

!-----------------------------------------------------------------------
!     bail out if starting row exceeds ending row
!-----------------------------------------------------------------------

      if (js .gt. je) return

!-----------------------------------------------------------------------
!     limit longitudes
!-----------------------------------------------------------------------

      istrt  = max(2,is)
      iend   = min(imt-1,ie)

      do j=js,je
        jrow = joff + j

!-----------------------------------------------------------------------
!       diagnostic: accumulate "tau" data for time means
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (timavgperts .and. .not. euler2) then
          if (istrt .ne. 2 .and. iend .ne. imt-1) then
            write (stdout,*) '=>Error: istrt = ',istrt,' and iend ='
     &,     iend,' are not allowed when calling "avgvar"'
            stop '=>diag'
          else
            call avgvar (j, jrow, adv_vbt(1,1,j), u(1,1,1,1,tau)
     &,                  t(1,1,1,1,tau), stf, smf)
          endif
        endif

!-----------------------------------------------------------------------
!       diagnostic: write instantaneous sample of MOM data
!       author:    r.c.pacanowski   e-mail  rcp@gfdl.gov
!                  a. rosati        e-mail  ar@gfdl.gov
!-----------------------------------------------------------------------

        if (snapts .and. .not. euler2) then
          ntrec = 1
          if (jrow .eq. 2) then
            if (fsnap .eq. ' ') ntrec = 0

            if (fsnap .eq. ' ')
     &        fsnap = file_stamp('snapshots',stamp,'.nc')

          endif
          avgper = 0.
          is = 1
          ie = imt
          call ocn_snap_out (fsnap, is, ie, jrow, jrow, imt, jmt, km, nt
     &,                      xt, yt, zt, xu, yu, zw, dxt, dyt, dzt, dxu
     &,                      dyu, dzw, ntrec, timunit, expnam, avgper
     &,                      relyr, stamp, t(is:ie,1:km,j,1:nt,tau)
     &,                      u(is:ie,1:km,j,1,tau)
     &,                      u(is:ie,1:km,j,2,tau)
     &,                      adv_vbt(is:ie,1:km,j), stf(is:ie,j,1:nt)
     &,                      smf(is:ie,j,1), smf(is:ie,j,2)

     &,                      psi(is:ie,jrow,1)

     &,                      kmt(is:ie,jrow), mskhr(is:ie,jrow)
     &,                      tmask(is:ie,1:km,j), umask(is:ie,1:km,j))

          if (jrow .eq. 2)
     &      write (*,'(a,i4,a,a,a,i10,a,a)') '=> Ocn snapshot #', ntrec
     &,        ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp
        endif

!-----------------------------------------------------------------------
!       diagnostic: compute stability diagnostics
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (stabts .and. eots) then
          if (istrt .ne. 2 .and. iend .ne. imt-1) then
            write (stdout,*) '=>Error: istrt = ',istrt,' and iend ='
     &,     iend,' are not allowed when calling "stab"'
            stop '=>diag'
          else
            call stab (j, jrow)
          endif
        endif

!-----------------------------------------------------------------------
!       construct meridional overturning of mass
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (jrow .lt. jmtm1 .and. vmsfts .and. eots) then

          do k=1,km
            vbarx(k) = c0
          enddo

          do k=1,km
            do i=istrt,iend
              vbarx(k) = vbarx(k) + u(i,k,j,2,tau)*csu(jrow)*dxu(i)
            enddo
            if (k .eq. 1) then
              vmsf(jrow,k) = vbarx(k)*dzt(k)
            else
              vmsf(jrow,k) = vmsf(jrow,k-1) + vbarx(k)*dzt(k)
            endif
          enddo

        endif

      enddo

      return
      end
