! source file: /usr/local/models/UVic_ESCM/2.6/source/common/setatm.F

      subroutine setatm

!-----------------------------------------------------------------------
!     set up for simple time varying data atmosphere (just for sbcocn)
!-----------------------------------------------------------------------

!      implicit none

!     this is set up only for periodic monthly data.

!     before adding a surface boundary condition
!      1. check numsbc and ntdbc are large enough (in csbc.h & ctdbc.h)
!      2. add index definition to driver and mapsbc.h (eq. itaux)
!      3. add code below and to atmos.f

      integer i, iou, j, k, m, n, ntrec

      include "param.h"
      include "csbc.h"
      include "mapsbc.h"

      include "atm.h"

      include "calendar.h"
      include "ctdbc.h"
      include "tmngr.h"
      include "switch.h"

      do n=1,ntdbc
        ntdrec(n) = 12
        period(n) = .true.
        do m=1, ntdrec(n)
          k = m + 1
          aprec(m,n) = daypm(m)
          if (.not. eqyear .and. nint(aprec(m,n)) .eq. 28) then
            aprec(m,n) = aprec(m,n) + 0.2425
            print*, '=>Warning: adding 0.2425 days to feb for leap year'
          endif
!         create time stamp for the end of each month
          if (k .gt. 12) then
            call mkstmp (dstamp(m,n), 2, 1, 1, 0, 0, 0)
          else
            call mkstmp (dstamp(m,n), 1, k, 1, 0, 0, 0)
          endif
        enddo

        call timeinterpi (ntdrec(n), dstamp(1,n), aprec(1,n), tdrec(1,n)
     &,                  isbcstart(n), period(n))

        call addtime (initial, imodeltime, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
        iprevm(n) = 1
        inextm(n) = 2
        method    = 3
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n), ntdrec(n)
     &,      period(n), method, inextd(n), iprevd(n), wprev(n)
     &,      rdtdbc(n), inextm(n), iprevm(n))
      enddo

      euler2 = .false.

!     load previous and next data for all boundary conditions

      do k=1,2

        n = 1
        do m=1,numsbc

          if (n .le. ntdbc) then

            rdtdbc(n) = .true.

            id = iprevd(n)
            im = iprevm(n)
            if (k .eq. 2) then
              id = inextd(n)
              im = inextm(n)
           endif

            if ( m .eq. itaux ) then
              if (k .eq. 1) print*, 'x component of windstress'
              call get_sbc (n, 'data/taux_mth.nc', 'taux', id, im
     &,         0.1, 0.)

            elseif ( m .eq. itauy ) then
              if (k .eq. 1) print*, 'y component of windstress'
              call get_sbc (n, 'data/tauy_mth.nc', 'tauy', id, im
     &,         0.1, 0.)

            elseif ( m .eq. iws ) then
              if (k .eq. 1) print*, 'surface wind speed'
              call get_sbc (n, 'data/ws_mth.nc', 'ws', id, im
     &,         0.01, 0.)

            elseif ( m .eq. iwx ) then
              if (k .eq. 1) print*, 'x component of advecting wind'
              call get_sbc (n, 'data/wx_mth.nc', 'wx', id, im
     &,         0.01, 0.)

            elseif ( m .eq. iwy ) then
              if (k .eq. 1) print*, 'y component of advecting wind'
              call get_sbc (n, 'data/wy_mth.nc', 'wy', id, im
     &,         0.01, 0.)

            endif

          endif

        enddo
      enddo

      return
      end

      subroutine get_sbc (n, file, name, id, im, scalar, offset)

      implicit none

      include "param.h"
      include "csbc.h"
      include "ctdbc.h"

      character (*) :: file, name
      integer id, im, iou, n, ntrec
      real offset, scalar, time

      time = 0.
      ntrec = 1
      call openfile (file, time, ntrec, iou)
      call getvara (name, iou, imt*jmt, (/1,1,id/)
     &, (/imt,jmt,1/), obc(1,1,n,im), scalar, offset)
      call closefile (iou)
      n = n + 1

      return
      end

