! source file: /usr/local/models/UVic_ESCM/2.6/source/embm/solve.F
      subroutine solve (n)

!=======================================================================
!     solve for tracer distribution after diffusion
!     based on code by a.fanning

!     input:
!       n    = tracer number

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "solve.h"
      include "atm.h"
      include "cembm.h"
      include "grdvar.h"
      include "coord.h"
      include "levind.h"

      include "ice.h"

      integer i, ii, ierr, j, jj, k, n

      real afw, afe, afn, atc, ate, atn, ats, atnc, atsc, atw, b, dt
      real dtss, dfw, dfe, dfn, fa, fb, fc, fd, fe, ff, fg, fh, tmp, x
      real forc(imt,jmt)

      dtss = dts

!-----------------------------------------------------------------------
!     set the forcing for each tracer
!-----------------------------------------------------------------------

      if (n .eq. 1) then

!       temperature

        fa = dtss/(cpatm*rhoatm*ht)
        fb = dtss*vlocn/(cpatm*rhoatm*ht)
        fc = dtss*slice/(cpatm*rhoatm*ht) - fb
        fd = dtss*flice/(cpatm*rhoatm*ht)
        do j=2,jmtm1
          do i=2,imtm1

            forc(i,j) = fa*(solins(j)*scatter*
     &                 (a_calb(i,j) - 0.18*aice(i,j,1))

     &                - outlwr(i,j) + uplwr(i,j) + upsens(i,j))
            if (psno(i,j) .gt. 0.0) then
!             latent heat from total precipitation including snow
              forc(i,j) = forc(i,j) + precip(i,j)*fb + fc*psno(i,j)
            else
!             latent heat from rain minus heat to melt snow over land
              forc(i,j) = forc(i,j) + precip(i,j)*fb + fd*psno(i,j)
            endif
          enddo
        enddo

      else if (n .eq. 2) then

!       humidity

        fa = dtss/(rhoatm*hq)
        do j=2,jmtm1
          do i=2,imtm1
            forc(i,j) = fa*evap(i,j)
          enddo
        enddo

      else if (n .gt. 2) then

!       other tracers

        do j=2,jmtm1
          do i=2,imtm1
            forc(i,j) = c0
          enddo
        enddo

      endif
      call embmbc (forc)

!-----------------------------------------------------------------------
!     calculate new coefficients if required
!-----------------------------------------------------------------------

      if (newcoef(lf,n)) call coef (n)

!-----------------------------------------------------------------------
!     shuffle in time
!-----------------------------------------------------------------------

      do j=1,jmt
        do i=1,imt
          tmp = at(i,j,2,n)
          at(i,j,2,n) = at(i,j,lf,n) + forc(i,j)
          at(i,j,1,n) = tmp
        enddo
      enddo

!-----------------------------------------------------------------------
!     load rhs into the solver array
!-----------------------------------------------------------------------

      k = 0

      do j=2,jmtm1

        do i=2,imtm1

          k = k + 1
          bv(k) = at(i,j,2,n)
          xv(k) = at(i,j,1,n)

        enddo
      enddo

!-----------------------------------------------------------------------
!     solve for tracer
!-----------------------------------------------------------------------

      call slap_sslugm (nord, bv, xv, nelm, ia, ja, ar(1,lf,n), 0, 10
     &,                 0, epsin(n), itin(n), itout(n), epsout(n)
     &,                 ierr, 0, raux, nraux, iaux, niaux)

      newcoef(lf,n) = .false.
      if (epsout(n) .gt. epsin(n)) write(*,*)
     &  '==> Warning:  atmospheric solver not converging in ',
     &  itout(n),' iterations ( eps = ',epsout(n), ' > ',epsin(n),' )'

!-----------------------------------------------------------------------
!     copy new solution from left hand side
!-----------------------------------------------------------------------

      k = 0

      do j=2,jmtm1

        do i=2,imtm1

          k = k + 1

          at(i,j,2,n) = xv(k)

        enddo
      enddo

!-----------------------------------------------------------------------
!     set boundary conditions
!-----------------------------------------------------------------------

      call embmbc (at(1,1,2,n))

      return
      end

      subroutine coef (n)

!=======================================================================
!     compute matrix coefficients
!     based on code by a.fanning

!     input:
!       n    = tracer number

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "solve.h"
      include "grdvar.h"
      include "cembm.h"
      include "atm.h"

      include "mapsbc.h"
      include "csbc.h"

      integer i, ide, ii, ielm, iord, j, jdn, jj, jord, n

      real acej, acnj, adde, addn, adds, addw, cc, ce, cew, cmax, cn
      real cns, cs, cw, dcej, dcnj, dp, df, fe, fn, fs, fw, fwind
      real pmax, pmin, ue, un, uw, ve, vn, vs, vw

      ielm = 0
      iord = 0

      pmin    = 2.0*3.171e-6 ! extra diffusion starting precip
      pmax    = 4.0*3.171e-6 ! extra diffusion ending precip
      fwind   = 0.3 ! wind reduction factor
      dp      = (pmax-pmin)
      df      = diffactor*1.0e10

      if (n .eq. 1) then
        call embmbc (avgp)
      endif
      if (n .le. 2) then
        call embmbc (sbcocn(1,1,iwx))
        call embmbc (sbcocn(1,1,iwy))
      endif

      cmax = 3.9e10

      do j=2,jmtm1
        jj = j - 1
        jdn = j

        do i=2,imtm1
          ii = i - 1
          ide = i

!-----------------------------------------------------------------------
!         set coefficients for implicit diffusion
!-----------------------------------------------------------------------

          cs = dn(j-1,n)
          cn = dn(jdn,n)

          cw = de(j,n)
          ce = de(j,n)

!-----------------------------------------------------------------------
!         closed north/south boundary conditions for diffusion
!-----------------------------------------------------------------------

          if (j .eq. 2) cs = c0
          if (j .eq. jmtm1) cn = c0

          cs =-dts*cs*dsgrd(j)
          cn =-dts*cn*dngrd(j)

          cw =-dts*cw*cstr(j)*cstr(j)*dwgrd(i)
          ce =-dts*ce*cstr(j)*cstr(j)*degrd(i)

          cc = 1.0 - cs - cn - cw - ce

!-----------------------------------------------------------------------
!         set coefficients for up-stream advection
!-----------------------------------------------------------------------

          if (n .le. 2) then

            vs = fwind*(sbcocn(i-1,j-1,iwy) + sbcocn(i,j-1,iwy))
            vn = fwind*(sbcocn(i-1,j,iwy) + sbcocn(i,j,iwy))

            uw = fwind*(sbcocn(i-1,j-1,iwx) + sbcocn(i-1,j,iwx))
            ue = fwind*(sbcocn(i,j-1,iwx) + sbcocn(i,j,iwx))

!-----------------------------------------------------------------------
!         set coefficients for reverse advection of t
!-----------------------------------------------------------------------

            if (n .eq. 1) then

              vs = -vs*min(max(0.5*(avgp(i,j)
     &           + avgp(i,j-1))-pmin,c0)/dp,c1)
              vn = -vn*min(max(0.5*(avgp(i,jdn)
     &           + avgp(i,jdn+1))-pmin,c0)/dp,c1)

              uw = -uw*min(max(0.5*(avgp(i,j)
     &           + avgp(i-1,j))-pmin,c0)/dp,c1)
              ue = -ue*min(max(0.5*(avgp(ide,j)
     &           + avgp(ide+1,j))-pmin,c0)/dp,c1)

            endif

            fs = p5*(c1 + sign(c1,vs))
            fn = p5*(c1 + sign(c1,vn))
            fw = p5*(c1 + sign(c1,uw))
            fe = p5*(c1 + sign(c1,ue))

!-----------------------------------------------------------------------
!           closed north/south boundary conditions for advection
!-----------------------------------------------------------------------

            if (j .eq. 2) vs = c0
            if (j .eq. jmtm1) vn = c0

            cs = cs - dts*fs*vs*asgrd(j)
            cn = cn + dts*(c1-fn)*vn*angrd(j)

            cw = cw - dts*fw*uw*cstr(j)*azgrd(i)
            ce = ce + dts*(c1-fe)*ue*cstr(j)*azgrd(i)

            cc = cc + dts*(fn*vn*angrd(j)-(c1-fs)*vs*asgrd(j)

     &         + (fe*ue - (c1-fw)*uw)*cstr(j)*azgrd(i))

          endif

          iord = iord + 1

!-----------------------------------------------------------------------
!         load the coefficients for the slap solver
!-----------------------------------------------------------------------

!         central coefficient
          ielm = ielm + 1
          ar(ielm,lf,n) = cc
          ia(ielm) = iord
          ja(ielm) = iord

!         western coefficient
          ielm = ielm + 1
          ar(ielm,lf,n) = cw
          ia(ielm) = iord
          if (ii .gt. 1) then
            ja(ielm) = iord - 1
          else
            ja(ielm) = iord + (iimtm2-1)
          endif

!         eastern coefficient
          ielm = ielm + 1
          ar(ielm,lf,n) = ce
          ia(ielm) = iord
          if (ii .lt. iimtm2) then
            ja(ielm) = iord + 1
          else
            ja(ielm) = iord - (iimtm2-1)
          endif

!         southern coefficient
          if (jj .gt. 1) then
            ielm = ielm + 1
            ar(ielm,lf,n) = cs
            ia(ielm) = iord
            ja(ielm) = iord - iimtm2
          endif

!         northern coefficient
          if (jj .lt. jjmtm2) then
            ielm = ielm + 1
            ar(ielm,lf,n) = cn
            ia(ielm) = iord
            ja(ielm) = iord + iimtm2
          endif

        enddo
      enddo

      return
      end
