! source file: /usr/local/models/UVic_ESCM/2.6/source/embm/embmio.F
       subroutine embmout (is, ie, js, je)
!=======================================================================
!     output routine for energy-moisture balance model
!     based on code by a.fanning

!     input:
!       is, ie, js, je = starting and ending indicies for i and j

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"

      include "csbc.h"
      include "mapsbc.h"

      include "atm.h"
      include "solve.h"
      include "coord.h"
      include "grdvar.h"

      include "ice.h"

      include "evp.h"

      include "cembm.h"
      include "iounit.h"
      include "levind.h"
      include "switch.h"
      include "tmngr.h"
      include "riv.h"

      include "cregin.h"

      character(80) :: ftsi, ftavg, fsnap, fname, file_stamp
      save ftsi, ftavg, fsnap
      data ftsi  /' '/
      data ftavg /' '/
      data fsnap /' '/

      integer i, ie, is, id_xt, id_yt, iou, j, je, js, n
      integer ndx, ntrec, nrest

      real avgper, ca, calb_ice, time, wt, wtp1
      real p_alb(is:ie,js:je), a_alb(is:ie,js:je), s_alb(is:ie,js:je)
      real esat(is:ie,js:je)

!-----------------------------------------------------------------------
!     write atmospheric diagnostics
!-----------------------------------------------------------------------

      if (tsiperts) call ta_atm_tsi (1)

      if (tsits .and. ntatia .ne. 0) then

        call ta_atm_tsi (2)

        if (iotsi .eq. stdout .or. iotsi .lt. 0) then
          write (*,'(a32, 10(a,1pe13.6))')
     &      stamp, ' iterations =', tai_maxit
     &,     ' TAbar=', tai_sat, ' QAbar=', tai_shum
     &,     ' HFbar=', tai_hfx, ' SFbar=', tai_sfx

     &,     ' Snow_vol=', tai_snow
     &,     ' Ocn_ice_vol=', tai_oice
     &,     ' Lnd_ice_vol=', tai_lice

        endif

        if (iotsi .ne. stdout) then
          ntrec = 1
          if (ftsi .eq. ' ') ntrec = 0

          if (ftsi .eq. ' ') ftsi = file_stamp('ts_intgrls',stamp,'.nc')

          avgper = dtatm*ntatia/86400.0
          call atm_tsi_out (ftsi, ntrec, timunit, expnam, avgper
     &,                     relyr, stamp, tai_sat, tai_shum, tai_hfx
     &,                     tai_sfx, tai_oice, tai_snow, tai_lice
     &,                     tai_co2ccn, tai_maxit)
        endif

        call ta_atm_tsi (0)

      endif

      if (timavgts .and. ntats .ne. 0) then

!-----------------------------------------------------------------------
!       write atmospheric time averaged data
!-----------------------------------------------------------------------

!       calculate average values

        call ta_atm_snap (is, ie, js, je, 2)

!       write time averaged data

        ntrec = 1
        if (ftavg .eq. ' ') ntrec = 0

        if (ftavg .eq. ' ') ftavg = file_stamp('time_mean',stamp,'.nc')

        avgper = dtatm*ntats/86400.0
        do j=js,je
          do i=is,ie
            esat(i,j) =  ta_at(i,j,1) - elev(i,j)*rlapse

            s_alb(i,j) = 1. - ta_s_calb(i,j)

            a_alb(i,j) = 1. - ta_a_calb(i,j)
            p_alb(i,j) = ta_a_calb(i,j)*pass*s_alb(i,j) + a_alb(i,j)
          enddo
        enddo

        call atm_snap_out (ftavg, is, ie, js, je, imt, jmt, km, nat
     &,   ncat, xt, yt, xu, yu, dxt, dyt, dxu, dyu, ntrec, timunit
     &,   expnam, avgper, relyr, stamp, ta_at(is:ie,js:je,1:nat)
     &,   esat, ta_precip(is:ie,js:je), ta_evap(is:ie,js:je)
     &,   ta_outlwr(is:ie,js:je), ta_uplwr(is:ie,js:je)
     &,   ta_upsens(is:ie,js:je), ta_dnswr(is:ie,js:je)
     &,   ta_upltnt(is:ie,js:je), p_alb, a_alb, s_alb
     &,   elev(is:ie,js:je)

     &,   ta_wx(is:ie,js:je), ta_wy(is:ie,js:je)

     &,   ta_tice(is:ie,js:je,1:ncat), ta_hice(is:ie,js:je,1:ncat)
     &,   ta_aice(is:ie,js:je,1:ncat), ta_hsno(is:ie,js:je,1:ncat)

     &,   ta_uice(is:ie,js:je), ta_vice(is:ie,js:je)
     &,   ta_xint(is:ie,js:je), ta_yint(is:ie,js:je)

     &,   tlat(is:ie,js:je), tlon(is:ie,js:je), ulat(is:ie,js:je)
     &,   ulon(is:ie,js:je)

     &,    kmt(is:ie,js:je), mskhr(is:ie,js:je))

        write (*,'(a,i5,a,a,a,a)') '=> Atm time means #'
     &,   ntrec, ' written to ',trim(ftavg),' on ', stamp

!-----------------------------------------------------------------------
!       write time average diagnostic runoff
!-----------------------------------------------------------------------

        write (stdout,*)
        write (stdout,*) ' time averaged river runoff by basin '
        do n=1,nb
          write (stdout,*) rivname(n),'(Sv)', ta_psum(n)*1.0e-12
        enddo
        write (stdout,*)

!       zero time average accumulators

        call ta_atm_snap (is, ie, js, je, 0)

      endif

      if (snapts) then

!-----------------------------------------------------------------------
!       write atmospheric snapshot
!-----------------------------------------------------------------------

!       write snapshot

        ntrec = 1
        if (fsnap .eq. ' ') ntrec = 0

        if (fsnap .eq. ' ') fsnap = file_stamp('snapshots',stamp,'.nc')

        avgper = 0.
        do j=js,je
          do i=is,ie
            esat(i,j) =  at(i,j,2,1) - elev(i,j)*rlapse

            ca = aice(i,j,2)*calb_ice(aice(i,j,2),hsno(i,j,2))
            ca = ca + (1. - aice(i,j,2))*s_calb(i,j)
            s_alb(i,j) = 1. - ca

            a_alb(i,j) = 1. - a_calb(i,j)
            p_alb(i,j) = a_calb(i,j)*pass*s_alb(i,j) + a_alb(i,j)

          enddo
        enddo

        call atm_snap_out (fsnap, is, ie, js, je, imt, jmt, km, nat
     &,   ncat, xt, yt, xu, yu, dxt, dyt, dxu, dyu, ntrec, timunit
     &,   expnam, avgper, relyr, stamp, at(is:ie,js:je,2,1:nat)
     &,   esat,  precip(is:ie,js:je), evap(is:ie,js:je)
     &,   outlwr(is:ie,js:je), uplwr(is:ie,js:je), upsens(is:ie,js:je)
     &,   dnswr(is:ie,js:je), upltnt(is:ie,js:je), p_alb, a_alb, s_alb
     &,   elev(is:ie,js:je)

     &,   sbcocn(is:ie,js:je,iwx), sbcocn(is:ie,js:je,iwy)

     &,   tice(is:ie,js:je), hice(is:ie,js:je,2), aice(is:ie,js:je,2)
     &,   hsno(is:ie,js:je,2)

     &,   uice(is:ie,js:je), vice(is:ie,js:je), xint(is:ie,js:je)
     &,   yint(is:ie,js:je)

     &,   tlat(is:ie,js:je), tlon(is:ie,js:je), ulat(is:ie,js:je)
     &,   ulon(is:ie,js:je)

     &,   kmt(is:ie,js:je), mskhr(is:ie,js:je))

        write (*,'(a,i5,a,a,a,a)') '=> Atm snapshot #'
     &,   ntrec, ' written to ',trim(fsnap),' on ', stamp

!-----------------------------------------------------------------------
!       write diagnostic runoff
!-----------------------------------------------------------------------

        write (stdout,'(/,a)') ' river runoff by basin '
        do n=1,nb
          write (stdout,*) rivname(n),'(Sv)', psum(n)*1.0e-12
        enddo
        write (stdout,*)

      endif

      if (restrt) then
        fname = file_stamp ('restatm', stamp, '.nc')
        if (restts) call atm_rest_out (fname, is, ie, js, je)
        fname = 'restatm.nc'
        if (eorun) call atm_rest_out (fname, is, ie, js, je)
      endif

      return
      end

      subroutine ta_atm_snap (is, ie, js, je, m)

!=======================================================================
!     atmospheric data time averaging

!     input:
!       is, ie, js, je = starting and ending indicies for i and j
!       m = flag (0 = zero, 1 = accumulate, 2 = write)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"
      include "riv.h"

      include "ice.h"

      include "csbc.h"
      include "mapsbc.h"

      integer i, ie, is, j, je, js, k, m, n, ndx

      real rntats

!-----------------------------------------------------------------------
!     time averaged data
!-----------------------------------------------------------------------

      if (m .eq. 0.) then
!       zero
        ntats = 0
        ta_at(:,:,:) = 0.
        ta_precip(:,:) = 0.
        ta_evap(:,:) = 0.
        ta_outlwr(:,:) = 0.
        ta_uplwr(:,:) = 0.
        ta_upsens(:,:) = 0.
        ta_upltnt(:,:) = 0.
        ta_dnswr(:,:) = 0.
        ta_s_calb(:,:) = 0.
        ta_a_calb(:,:) = 0.

        ta_wx(:,:) = 0.
        ta_wy(:,:) = 0.

        ta_tice(:,:,:) = 0.
        ta_hice(:,:,:) = 0.
        ta_aice(:,:,:) = 0.
        ta_hsno(:,:,:) = 0.

        ta_uice(:,:) = 0.
        ta_vice(:,:) = 0.
        ta_pice(:,:) = 0.
        ta_xint(:,:) = 0.
        ta_yint(:,:) = 0.

        ta_psum(:) = 0.
      elseif (m .eq. 1) then
!       accumulate
        ntats = ntats + 1

        do n=1,nat
          ta_at(:,:,n) = ta_at(:,:,n) + at(:,:,2,n)
        enddo
        ta_precip(:,:) = ta_precip(:,:) + precip(:,:)
        ta_evap(:,:) = ta_evap(:,:) + evap(:,:)
        ta_outlwr(:,:) = ta_outlwr(:,:) + outlwr(:,:)
        ta_uplwr(:,:) = ta_uplwr(:,:) + uplwr(:,:)
        ta_upsens(:,:) = ta_upsens(:,:) + upsens(:,:)
        ta_upltnt(:,:) = ta_upltnt(:,:) + upltnt(:,:)
        ta_dnswr(:,:) = ta_dnswr(:,:) + dnswr(:,:)
        ta_s_calb(:,:) = ta_s_calb(:,:) + s_calb(:,:)
        ta_a_calb(:,:) = ta_a_calb(:,:) + a_calb(:,:)

        ta_wx(:,:) = ta_wx(:,:) + sbcocn(:,:,iwx)
        ta_wy(:,:) = ta_wy(:,:) + sbcocn(:,:,iwy)

        ta_tice(:,:,1) = ta_tice(:,:,1) + tice(:,:)
        ta_hice(:,:,1) = ta_hice(:,:,1) + hice(:,:,2)
        ta_aice(:,:,1) = ta_aice(:,:,1) + aice(:,:,2)
        ta_hsno(:,:,1) = ta_hsno(:,:,1) + hsno(:,:,2)

        ta_uice(:,:) = ta_uice(:,:) + uice(:,:)
        ta_vice(:,:) = ta_vice(:,:) + vice(:,:)
        ta_pice(:,:) = ta_pice(:,:) + pice(:,:)
        ta_xint(:,:) = ta_xint(:,:) + xint(:,:)
        ta_yint(:,:) = ta_yint(:,:) + yint(:,:)

        ta_psum(:) = ta_psum(:) + psum(:)
      elseif (m .eq. 2 .and. ntats .ne. 0) then
!       average
        rntats = 1./float(ntats)
        ta_at(:,:,:) = ta_at(:,:,:)*rntats
        ta_precip(:,:) = ta_precip(:,:)*rntats
        ta_evap(:,:) = ta_evap(:,:)*rntats
        ta_outlwr(:,:) = ta_outlwr(:,:)*rntats
        ta_uplwr(:,:) = ta_uplwr(:,:)*rntats
        ta_upsens(:,:) = ta_upsens(:,:)*rntats
        ta_upltnt(:,:) = ta_upltnt(:,:)*rntats
        ta_dnswr(:,:) = ta_dnswr(:,:)*rntats
        ta_s_calb(:,:) = ta_s_calb(:,:)*rntats
        ta_a_calb(:,:) = ta_a_calb(:,:)*rntats

        ta_wx(:,:) = ta_wx(:,:)*rntats
        ta_wy(:,:) = ta_wy(:,:)*rntats

        ta_hsno(:,:,:) = ta_hsno(:,:,:)*rntats
        ta_tice(:,:,:) = ta_tice(:,:,:)*rntats
        ta_hice(:,:,:) = ta_hice(:,:,:)*rntats
        ta_aice(:,:,:) = ta_aice(:,:,:)*rntats

        ta_uice(:,:) = ta_uice(:,:)*rntats
        ta_vice(:,:) = ta_vice(:,:)*rntats
        ta_pice(:,:) = ta_pice(:,:)*rntats
        ta_xint(:,:) = ta_xint(:,:)*rntats
        ta_yint(:,:) = ta_yint(:,:)*rntats

        ta_psum(:) = ta_psum(:)*rntats
      endif

      return
      end

      subroutine ta_atm_tsi (m)

!=======================================================================
!     atmospheric data time integral averaging

!     input:
!       m = flag (0 = zero, 1 = accumulate, 2 = write)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"

      include "ice.h"

      include "solve.h"

      integer  maxit, m, n
      real esat(imt,jmt), rntatia, sum, tmp

!-----------------------------------------------------------------------
!     time averaged integrated data
!-----------------------------------------------------------------------

       if (m .eq. 0.) then
!       zero
        ntatia = 0
        tai_maxit = 0.
        tai_sat  = 0.
        tai_shum = 0.
        tai_hfx = 0.
        tai_sfx = 0.
        tai_oice = 0.
        tai_snow = 0.
        tai_lice = 0.
        tai_co2ccn = 0.
      elseif (m .eq. 1) then
!       accumulate
        ntatia = ntatia + 1
        maxit = 0

        do n=1,nat
          if (itout(n) .gt. maxit) maxit = itout(n)
        enddo

        tai_maxit = tai_maxit + maxit
        esat(:,:) =  at(:,:,2,1) - elev(:,:)*rlapse
        call areaavg (esat, 1, tmp)
        tai_sat  = tai_sat + tmp
        call areaavg (at(:,:,2,2), 1, tmp)
        tai_shum = tai_shum + tmp
        call areaavg (flux(:,:,1), 0, tmp)
        tai_hfx = tai_hfx + tmp/avetime
        call areaavg (flux(:,:,2), 0, tmp)
        tai_sfx = tai_sfx - tmp*socn*rhoocn/avetime

        call areatot (hice(:,:,2), 0, tmp)
        tai_oice = tai_oice + tmp
        call areatot (hsno(:,:,2), 1, tmp)
        tai_snow = tai_snow + tmp

        call areatot (hice(:,:,2), 2, tmp)
        tai_lice = tai_lice + tmp

        tai_co2ccn = tai_co2ccn + co2ccn
      elseif (m .eq. 2 .and. ntatia .ne. 0) then
!       average
        rntatia = 1./float(ntatia)
        tai_maxit = tai_maxit*rntatia
        tai_sat  = tai_sat*rntatia
        tai_shum = tai_shum*rntatia
        tai_hfx = tai_hfx*rntatia
        tai_sfx = tai_sfx*rntatia
        tai_oice = tai_oice*rntatia
        tai_snow = tai_snow*rntatia
        tai_lice = tai_lice*rntatia
        tai_co2ccn = tai_co2ccn*rntatia
      endif

      return
      end

