! source file: /usr/local/models/UVic_ESCM/2.6/source/mom/ocn_tbt.F
      subroutine ocn_tbt_in (fname, ids, ide, jds, jde, imt, jmt, km
     &,                      nt, xt, yt, zt, xu, yu, zw, dxt, dyt, dzt
     &,                      dxu, dyu, dzw, ntrec, timunit, expnam
     &,                      avgper, relyr, stamp, tbt, stf

     &,                      tlat, tlon, ulat, ulon

     &,                      kmt, mskhr)
!=======================================================================
!     input routine for ocean tracer balances

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     dxt, dyt ...       = grid widths
!     ntrec              = number of time record (zero if not defined)

!   outputs:
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     stamp              = time stamp
!     pass               = atmospheric transmission coefficient
!     tbt ...            = data to be written

!   local variables
!     igs, ige, jgs, jge = global read domain start and end indicies
!     ig, jg             = global domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for read on each axis (x,y,t default)
!     ic                 = count for read on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      return
      end

      subroutine ocn_tbt_out (fname, ids, ide, jds, jde, imt, jmt, km
     &,                       nt, xt, yt, zt, xu, yu, zw, dxt, dyt, dzt
     &,                       dxu, dyu, dzw, ntrec, timunit, expnam
     &,                       avgper, relyr, stamp, tbt, stf

     &,                       tlat, tlon, ulat, ulon

     &,                       kmt, mskhr, tm)
!=======================================================================
!     output routine for ocean tracer balances

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension. data
!     should be defined with the routine defvar and written with putvar.
!     if no time dimension, then data is only written once per file.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     ntrec              = number of time record (zero if not defined)
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     stamp              = time stamp
!     pass               = atmospheric transmission coefficient
!     tbt ...            = data to be written
!     tm                 = tracer grid mask

!   outputs:
!     ntrec              = number of time record in file

!   local variables
!     igs, ige, jgs, jge = global write domain start and end indicies
!     ig, jg             = global write domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for write on each axis (x,y,t default)
!     ic                 = count for write on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      return
      end
