! source file: /usr/local/models/UVic_ESCM/2.6/source/embm/atm_snap.F
      subroutine atm_snap_in (fname, ids, ide, jds, jde, imt, jmt, km
     &,                       nat, ncat, xt, yt, xu, yu, dxt, dyt, dxu
     &,                       dyu, ntrec, timunit, expnam, avgper
     &,                       relyr, stamp, at, esat, precip, evap
     &,                       outlwr, uplwr, upsens, dnswr, upltnt
     &,                       p_alb, a_alb, s_alb, elev

     &,                       wx, wy

     &,                       tice, hice, aice, hsno

     &,                       uice, vice, xint, yint

     &,                       kmt, mskhr)
!=======================================================================
!     output routine for atmospheric time averages or 1

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     dxt, dyt ...       = grid widths
!     ntrec              = number of time record (zero if not defined)

!   outputs:
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     stamp              = time stamp
!     at, ...            = data to be read

!   local variables
!     igs, ige, jgs, jge = global read domain start and end indicies
!     ig, jg             = global read domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for read on each axis (x,y,t default)
!     ic                 = count for read on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title, file_stamp
      character(3) :: a3

      integer i, iou, j, ln, n, ntrec, imt, jmt, km, nat, ncat
      integer ids, ide, jds, jde, igs, ige, ig, jgs, jge, jg, kgs, kge
      integer kg, ils, ile, jls, jle, kls, kle, is(10), ic(10), it(10)
      integer iu(10), id_time, id_xt, id_xu, id_yt, id_yu, id_cat
      integer id_xt_e, id_xu_e, id_yt_e, id_yu_e, id_cat_e
      integer kmt(ids:ide,jds:jde), mskhr(ids:ide,jds:jde)
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real xt(imt), xu(imt), yt(jmt), yu(jmt)
      real dxt(imt), dxu(imt), dyt(jmt), dyu(jmt)
      real avgper, at(ids:ide,jds:jde,nat)
      real esat(ids:ide,jds:jde), precip(ids:ide,jds:jde)
      real evap(ids:ide,jds:jde), outlwr(ids:ide,jds:jde)
      real uplwr(ids:ide,jds:jde), upsens(ids:ide,jds:jde)
      real dnswr(ids:ide,jds:jde), upltnt(ids:ide,jds:jde)
      real p_alb(ids:ide,jds:jde), a_alb(ids:ide,jds:jde)
      real s_alb(ids:ide,jds:jde), elev(ids:ide,jds:jde)

      real wx(ids:ide,jds:jde), wy(ids:ide,jds:jde)

      real tice(ids:ide,jds:jde), hice(ids:ide,jds:jde)
      real aice(ids:ide,jds:jde), hsno(ids:ide,jds:jde)

      real uice(ids:ide,jds:jde), vice(ids:ide,jds:jde)
      real xint(ids:ide,jds:jde), yint(ids:ide,jds:jde)

      real rkmt(ids:ide,jds:jde), rmskhr(ids:ide,jds:jde)
      real relyr, tmp(1), xt_e(imt+1), xu_e(imt+1), yt_e(jmt+1)
      real yu_e(jmt+1)

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      name = fname
      i = 0
      call openfile (name, relyr, i, iou)

!-----------------------------------------------------------------------
!     get global attributes
!-----------------------------------------------------------------------
      call getglobal (iou, fname, title, expnam, timunit)

!-----------------------------------------------------------------------
!     get global read domain size (may be less than global domain)
!-----------------------------------------------------------------------
      call getaxis('xt', iou, imt, xt, igs, ige, 1., 0.)
      call getaxis('xu', iou, imt, xu, igs, ige, 1., 0.)
      ig  = ige-igs+1
      call getaxis('yt', iou, jmt, yt, jgs, jge, 1., 0.)
      call getaxis('yu', iou, jmt, yu, igs, ige, 1., 0.)
      jg  = jge-jgs+1
      kgs = 1
      kge = ncat
      kg  = kge-kgs+1

!-----------------------------------------------------------------------
!     local domain size (minimum of data domain and global read domain)
!-----------------------------------------------------------------------
      ils = max(ids,igs)
      ile = min(ide,ige)
      jls = max(jds,jgs)
      jle = min(jde,jge)
      kls = max(1,kgs)
      kle = min(ncat,kge)

!-----------------------------------------------------------------------
!     read 1d data (t)
!-----------------------------------------------------------------------
      call getvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      relyr = tmp(1)
      call getvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nyear = tmp(1)
      call getvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmonth = tmp(1)
      call getvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nday = tmp(1)
      call getvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nhour = tmp(1)
      call getvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nmin = tmp(1)
      call getvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      nsec = tmp(1)
      call mkstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      call getvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      avgper = tmp(1)

!-----------------------------------------------------------------------
!     read 2d data (x,y)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      ln = ic(1)*ic(2)
      call getvara ('elev', iou, ln, is, ic, elev(ils:ile,jls:jle)
     &, 0.01, 0.)
      call getvara ('kmt', iou, ln, is, ic, rkmt(ils:ile,jls:jle)
     &, 1., 0.)
      kmt(ils:ile,jls:jle) = rkmt(ils:ile,jls:jle)
      call getvara ('mskhr', iou, ln, is, ic, rmskhr(ils:ile,jls:jle)
     &, 1., 0.)
      mskhr(ils:ile,jls:jle) = rmskhr(ils:ile,jls:jle)

!-----------------------------------------------------------------------
!     read 3d data (x,y,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = ntrec
      ic(3) = 1
      call getvara ('sat', iou, ln, is, ic, at(ils:ile,jls:jle,1)
     &, 1., 273.15)
      call getvara ('shum', iou, ln, is, ic, at(ils:ile,jls:jle,2)
     &, 1., 0.)
      do n=3,nat
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call getvara ('at_'//trim(a3), iou, ln, is, ic
     &,   at(ils:ile,jls:jle,n), 1., 0.)
      enddo
      call getvara ('esat', iou, ln, is, ic, esat(ils:ile,jls:jle)
     &, 1., 273.15)
      call getvara ('precip', iou, ln, is, ic, precip(ils:ile,jls:jle)
     &, 100., 0.)
      call getvara ('evap', iou, ln, is, ic, evap(ils:ile,jls:jle)
     &, 100., 0.)
      call getvara ('outlwr', iou, ln, is, ic, outlwr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call getvara ('uplwr', iou, ln, is, ic, uplwr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call getvara ('upsens', iou, ln, is, ic, upsens(ils:ile,jls:jle)
     &, 0.001, 0.)
      call getvara ('dnswr', iou, ln, is, ic, dnswr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call getvara ('upltnt', iou, ln, is, ic, upltnt(ils:ile,jls:jle)
     &, 0.001, 0.)
      call getvara ('p_alb', iou, ln, is, ic, p_alb(ils:ile,jls:jle)
     &, 1., 0.)
      call getvara ('a_alb', iou, ln, is, ic, a_alb(ils:ile,jls:jle)
     &, 1., 0.)
      call getvara ('s_alb', iou, ln, is, ic, s_alb(ils:ile,jls:jle)
     &, 1., 0.)

      call getvara ('wx', iou, ln, is, ic, wx(ils:ile,jls:jle)
     &, 0.01, 0.)
      call getvara ('wy', iou, ln, is, ic, wy(ils:ile,jls:jle)
     &, 0.01, 0.)

      call getvara ('tice', iou, ln, is, ic, tice(ils:ile,jls:jle)
     &, 1., 273.15)
      call getvara ('hice', iou, ln, is, ic, hice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call getvara ('aice', iou, ln, is, ic, aice(ils:ile,jls:jle)
     &, 1., 0.)
      call getvara ('hsno', iou, ln, is, ic, hsno(ils:ile,jls:jle)
     &, 0.01, 0.)

      call getvara ('uice', iou, ln, is, ic, uice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call getvara ('vice', iou, ln, is, ic, vice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call getvara ('xint', iou, ln, is, ic, xint(ils:ile,jls:jle)
     &, 0.1, 0.)
      call getvara ('yint', iou, ln, is, ic, yint(ils:ile,jls:jle)
     &, 0.1, 0.)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end

      subroutine atm_snap_out (fname, ids, ide, jds, jde, imt, jmt, km
     &,                        nat, ncat, xt, yt, xu, yu, dxt, dyt, dxu
     &,                        dyu, ntrec, timunit, expnam, avgper
     &,                        relyr, stamp, at, esat, precip
     &,                        evap, outlwr, uplwr, upsens, dnswr
     &,                        upltnt, p_alb, a_alb,  s_alb, elev

     &,                        wx, wy

     &,                        tice, hice, aice, hsno

     &,                        uice, vice, xint, yint

     &,                        kmt, mskhr)
!=======================================================================
!     output routine for atmospheric time averages or 1

!     data may be sized differently in x and y from the global fields.
!     fields may be written with or without a time dimension. data
!     should be defined with the routine defvar and written with putvar.
!     if no time dimension, then data is only written once per file.
!     make sure the it, iu, is, and ic arrays and are defining the
!     correct dimensions. ln may also need to be recalculated.

!   inputs:
!     fname              = file name
!     ids, ide ...       = start and end index for data domain
!     imt, jmt ...       = global array dimensions
!     xt, yt ...         = global axes
!     dxt, dyt ...       = grid widths
!     ntrec              = number of time record (zero if not defined)
!     timunit            = time unit
!     expnam             = experiment name
!     avgper             = length of averaging period
!     relyr              = time in years
!     stamp              = time stamp
!     at, ...            = data to be written

!   outputs:
!     ntrec              = number of time record in file

!   local variables
!     igs, ige, jgs, jge = global write domain start and end indicies
!     ig, jg             = global write domain size
!     ils, ile, jls, jle = local domain start and end indicies
!     it                 = t grid axis definitions (x,y,t default)
!     iu                 = u grid axis definitions (x,y,t default)
!     is                 = start for write on each axis (x,y,t default)
!     ic                 = count for write on each axis (x,y,t default)
!     id_...             = id's for axis (used for it, iu or defvar)
!     iou                = io unit (ncid)
!     ln                 = length of data to be written

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(80) :: name, title, file_stamp
      character(3) :: a3

      integer i, iou, j, ln, n, ntrec, imt, jmt, km, nat, ncat
      integer ids, ide, jds, jde, igs, ige, ig, jgs, jge, jg, kgs, kge
      integer kg, ils, ile, jls, jle, kls, kle, is(10), ic(10), it(10)
      integer iu(10), id_time, id_xt, id_xu, id_yt, id_yu
      integer id_cat, id_xt_e, id_xu_e, id_yt_e, id_yu_e, id_cat_e
      integer kmt(ids:ide,jds:jde), mskhr(ids:ide,jds:jde)
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real xt(imt), xu(imt), yt(jmt), yu(jmt)
      real dxt(imt), dxu(imt), dyt(jmt), dyu(jmt)
      real avgper, at(ids:ide,jds:jde,nat)
      real esat(ids:ide,jds:jde), precip(ids:ide,jds:jde)
      real evap(ids:ide,jds:jde), outlwr(ids:ide,jds:jde)
      real uplwr(ids:ide,jds:jde), upsens(ids:ide,jds:jde)
      real dnswr(ids:ide,jds:jde), upltnt(ids:ide,jds:jde)
      real p_alb(ids:ide,jds:jde), a_alb(ids:ide,jds:jde)
      real s_alb(ids:ide,jds:jde), elev(ids:ide,jds:jde)

      real wx(ids:ide,jds:jde), wy(ids:ide,jds:jde)

      real tice(ids:ide,jds:jde), hice(ids:ide,jds:jde)
      real aice(ids:ide,jds:jde), hsno(ids:ide,jds:jde)

      real uice(ids:ide,jds:jde), vice(ids:ide,jds:jde)
      real xint(ids:ide,jds:jde), yint(ids:ide,jds:jde)

      real rkmt(ids:ide,jds:jde), rmskhr(ids:ide,jds:jde)
      real relyr, tmp(1), xt_e(imt+1), xu_e(imt+1), yt_e(jmt+1)
      real yu_e(jmt+1)

      logical defined

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = fname
      if (ntrec .eq. 0) defined = .false.
      call openfile (name, relyr, ntrec, iou)

!-----------------------------------------------------------------------
!     set global write domain size (may be less than global domain)
!-----------------------------------------------------------------------

      igs = 2
      ige = imt-1

      ig  = ige-igs+1
      jgs = 1
      jge = jmt
      do j=2,jmt
        if (yt(j-1) .lt. -90. .and. yt(j) .gt. -90.) jgs = j
        if (yt(j-1) .lt.  90. .and. yt(j) .gt. 90.) jge = j-1
      enddo
      jg  = jge-jgs+1
      kgs = 1
      kge = ncat
      kg  = kge-kgs+1

      if (.not. defined .or. ntrec .eq. 0) then

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average'
        else
          title = 'Snapshot'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)
        call defdim ('xt', iou, ig, id_xt)
        call defdim ('yt', iou, jg, id_yt)
        call defdim ('xu', iou, ig, id_xu)
        call defdim ('yu', iou, jg, id_yu)
        call defdim ('xt_edges', iou, ig+1, id_xt_e)
        call defdim ('yt_edges', iou, jg+1, id_yt_e)
        call defdim ('xu_edges', iou, ig+1, id_xu_e)
        call defdim ('yu_edges', iou, jg+1, id_yu_e)

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, (/id_time/), 0., 0., 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, (/id_time/), 0., 0., ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif

!-----------------------------------------------------------------------
!       define 1d data (x, y or z)
!-----------------------------------------------------------------------
        call defvar ('xt', iou, 1, (/id_xt/), 0., 0., 'X', 'F'
     &,   'longitude of the t grid', 'grid_longitude', 'degrees_east')
        call defvar ('yt', iou, 1, (/id_yt/), 0., 0., 'Y', 'F'
     &,   'latitude of the t grid', 'grid_latitude', 'degrees_north')
        call defvar ('xu', iou, 1, (/id_xu/), 0., 0., 'X', 'F'
     &,   'longitude of the u grid', 'grid_longitude', 'degrees_east')
        call defvar ('yu', iou, 1, (/id_yu/), 0., 0., 'Y', 'F'
     &,   'latitude of the u grid', 'grid_latitude', 'degrees_north')
        call defvar ('xt_edges', iou, 1, (/id_xt_e/), 0., 0., 'X', 'F'
     &,   'longitude of t grid edges','grid_edge_longitude'
     &,   'degrees_east')
        call defvar ('yt_edges', iou, 1, (/id_yt_e/), 0., 0., 'Y', 'F'
     &,   'latitude of t grid edges', 'grid_edge_latitude'
     &,   'degrees_north')
        call defvar ('xu_edges', iou, 1, (/id_xu_e/), 0., 0., 'X', 'F'
     &,   'longitude of u grid edges', 'grid_edge_longitude'
     &,   'degrees_east')
        call defvar ('yu_edges', iou, 1, (/id_yu_e/), 0., 0., 'Y', 'F'
     &,   'latitude of u grid edges', 'grid_edge_latitude'
     &,   'degrees_north')

!-----------------------------------------------------------------------
!       define 2d data (x,y)
!-----------------------------------------------------------------------
        it(1) = id_xt
        iu(1) = id_xu
        it(2) = id_yt
        iu(2) = id_yu
        call defvar ('elev', iou, 2, it, -1.e4, 1.e4, ' ', 'F'
     &,   'land elevation and ocean depth', 'surface_altitude', 'm')
        call defvar ('kmt', iou, 2, it, 0., 1000., ' ', 'I'
     &,   'ocean depth grid level', ' ' ,'level')
        call defvar ('mskhr', iou, 2, it, 0., 1000., ' ', 'I'
     &,   'horizontal region mask', ' ' ,'number')

!-----------------------------------------------------------------------
!       define 3d data (x,y,t)
!-----------------------------------------------------------------------
        it(1) = id_xt
        iu(1) = id_xu
        it(2) = id_yt
        iu(2) = id_yu
        it(3) = id_time
        iu(3) = id_time
        call defvar ('sat', iou, 3, it, 100., 400., ' ', 'F'
     &,   'sea surface atmospheric temperature', 'air_temperature', 'K')
        call defvar ('shum', iou,3, it, -100., 100., ' ', 'F'
     &,   'atmospheric surface specific humidity', 'specific_humidity'
     &,   '1')
        do n=3,nat
          if (n .lt. 1000) write(a3,'(i3)') n
          if (n .lt. 100) write(a3,'(i2)') n
          if (n .lt. 10) write(a3,'(i1)') n
          call defvar ('at_'//trim(a3), iou ,3, it, -100., 100., ' '
     &,     'F', 'unknown tracer '//trim(a3)
     &,     'unknown_tracer_'//trim(a3), 'unknown')
        enddo
        call defvar ('esat', iou, 3, it, 100., 400., ' ', 'F'
     &,   'atmospheric surface temperature', 'air_temperature', 'K')
        call defvar ('precip', iou, 3, it, 0., 1., ' ', 'F'
     &,   'precipitation (includes snow in water equivalent)'
     &,   'precipitation_mass_flux_density', 'kg m-2 s-1')
        call defvar ('evap', iou, 3, it, 0., 1., ' ', 'F'
     &,   'upward evaporation plus sublimation'
     &,   'surface_upward_water_vapour_mass_flux_density', 'kg m-2 s-1')
        call defvar ('outlwr', iou, 3, it, -1000., 1000., ' ', 'F'
     &,   'outgoing longwave from top of atmosphere'
     &,   'TOA_upward_longwave_heat_flux_density', 'W m-2')
        call defvar ('uplwr', iou, 3, it, -1000., 1000., ' ', 'F'
     &,   'surface upward longwave'
     &,   'surface_emitted_longwave_heat_flux_density', 'W m-2')
        call defvar ('upsens', iou, 3, it, -1000., 1000., ' ', 'F'
     &,   'surface upward sensible heat'
     &,   'surface_upward_sensible_heat_flux_density', 'W m-2')
        call defvar ('dnswr', iou, 3, it, -1000., 1000., ' ', 'F'
     &,   'net surface downward short wave (absorbed)'
     &,   'surface_downward_shortwave_heat_flux_density', 'W/m^2')
        call defvar ('upltnt', iou, 3, it, -1000., 1000., ' ', 'F'
     &,   'surface upward latent heat'
     &,   'surface_upward_latent_heat_flux_density', 'W m-2')
        call defvar ('p_alb', iou, 3, it, 0., 1., ' ', 'F'
     &,   'planetary albedo', 'planetary_albedo', '1')
        call defvar ('a_alb', iou, 3, it, 0., 1., ' ', 'F'
     &,   'atmospheric albedo', 'atmospheric_albedo', '1')
        call defvar ('s_alb', iou, 3, it, 0., 1., ' ', 'F'
     &,   'surface albedo', 'surface_albedo', '1')

        call defvar ('wx', iou, 3, iu, -1000., 1000., ' ', 'F'
     &,   'eastward wind for advection of humidity'
     &,   'eastward_wind', 'm s-1')
        call defvar ('wy', iou, 3, iu, -1000., 1000., ' ', 'F'
     &,   'northward wind for advection of humidity'
     &,   'northward_wind', 'm s-1')

        call defvar ('tice', iou, 3, it, 100., 400., ' ', 'F'
     &,   'surface ice temperature', 'surface_sea_ice_temperature'
     &,   'K')
        call defvar ('hice', iou, 3, it, 0., 1.e6, ' ', 'F'
     &,   'ice thickness', 'sea_ice_thickness', 'm')
        call defvar ('aice', iou, 3, it, 0., 100., ' ', 'F'
     &,   'ice area fraction (includes land ice area fraction)'
     &,   'sea_ice_area_fraction', '1')
        call defvar ('hsno', iou, 3, it, -0.01, 1.e6, ' ', 'F'
     &,   'surface snow thickness', 'surface_snow_thickness', 'm')

        call defvar ('uice', iou, 3, iu, -1000., 1000., ' ', 'F'
     &,   'eastward ice velocity', 'sea_ice_eastward_velocity'
     &,   'm s-1')
        call defvar ('vice', iou, 3, iu, -1000., 1000., ' ', 'F'
     &,   'northward ice velocity', 'sea_ice_northward_velocity'
     &,   'm s-1')
        call defvar ('xint', iou, 3, iu, -1.e8, 1.e9, ' ', 'F'
     &,   'eastward ice interaction', 'eastward_stress_of_sea_ice'
     &,   'Pa')
        call defvar ('yint', iou, 3, iu, -1.e8, 1.e9, ' ', 'F'
     &,   'northward ice interaction', 'northward_stress_of_sea_ice'
     &,   'Pa')

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0 ) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     local domain size (minimum of data domain and global write domain)
!-----------------------------------------------------------------------
      ils = max(ids,igs)
      ile = min(ide,ige)
      jls = max(jds,jgs)
      jle = min(jde,jge)
      kls = max(1,kgs)
      kle = min(ncat,kge)

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      tmp(1) = relyr
      call putvara ('time', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp(1) = nyear
      call putvara ('year', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmonth
      call putvara ('month', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nday
      call putvara ('day', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nhour
      call putvara ('hour', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nmin
      call putvara ('minute', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      tmp(1) = nsec
      call putvara ('second', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      if (avgper .gt. 1.e-6) then
        tmp(1) = avgper
        call putvara ('period', iou, 1, (/ntrec/), (/1/), tmp, 1., 0.)
      endif

      if (ntrec .eq. 1 .or. .not. defined) then

!-----------------------------------------------------------------------
!       write 1d data (x, y or z)
!-----------------------------------------------------------------------
        call putvara ('xt', iou, ig, (/1/), (/ig/), xt(igs:ige), 1., 0.)
        call putvara ('yt', iou, jg, (/1/), (/jg/), yt(jgs:jge), 1., 0.)
        call putvara ('xu', iou, ig, (/1/), (/ig/), xu(igs:ige), 1., 0.)
        call putvara ('yu', iou, jg, (/1/), (/jg/), yu(jgs:jge), 1., 0.)
        call edge_maker (1, xt_e, xt, dxt, xu, dxu, imt)
        call putvara ('xt_edges', iou, ig+1, (/1/), (/ig+1/)
     &,   xt_e(igs:ige+1), 1., 0.)
        call edge_maker (1, yt_e, yt, dyt, yu, dyu, jmt)
        call putvara ('yt_edges', iou, jg+1, (/1/), (/jg+1/)
     &,   yt_e(jgs:jge+1), 1., 0.)
        call edge_maker (2, xu_e, xt, dxt, xu, dxu, imt)
        call putvara ('xu_edges', iou, ig+1, (/1/), (/ig+1/)
     &,   xu_e(igs:ige+1), 1., 0.)
        call edge_maker (2, yu_e, yt, dyt, yu, dyu, jmt)
        call putvara ('yu_edges', iou, jg+1, (/1/), (/jg+1/)
     &,   yu_e(jgs:jge+1), 1., 0.)

!-----------------------------------------------------------------------
!       write 2d data (x,y)
!-----------------------------------------------------------------------
        is(1) = ils-igs+1
        ic(1) = ile-ils+1
        is(2) = jls-jgs+1
        ic(2) = jle-jls+1
        ln = ic(1)*ic(2)
        call putvara ('elev', iou, ln, is, ic, elev(ils:ile,jls:jle)
     &,   0.01, 0.)
        rkmt(ils:ile,jls:jle) = kmt(ils:ile,jls:jle)
        call putvara ('kmt', iou, ln, is, ic, rkmt(ils:ile,jls:jle)
     &,   1., 0.)
        rmskhr(ils:ile,jls:jle) = mskhr(ils:ile,jls:jle)
        call putvara ('mskhr', iou, ln, is, ic, rmskhr(ils:ile,jls:jle)
     &,   1., 0.)

      endif

!-----------------------------------------------------------------------
!     write 3d data (x,y,t)
!-----------------------------------------------------------------------
      is(1) = ils-igs+1
      ic(1) = ile-ils+1
      is(2) = jls-jgs+1
      ic(2) = jle-jls+1
      is(3) = ntrec
      ic(3) = 1
      ln = ic(1)*ic(2)*ic(3)
      call putvara('sat', iou, ln, is, ic, at(ils:ile,jls:jle,1)
     &, 1., 273.15)
      call putvara('shum', iou, ln, is, ic, at(ils:ile,jls:jle,2)
     &, 1., 0.)
      do n=3,nat
        if (n .lt. 1000) write(a3, '(i3)') n
        if (n .lt. 100) write(a3, '(i2)') n
        if (n .lt. 10) write(a3, '(i1)') n
        call putvara('at_'//trim(a3), iou, ln, is, ic
     &,   at(ils:ile,jls:jle,n), 1., 0.)
      enddo
      call putvara('esat', iou, ln, is, ic, esat(ils:ile,jls:jle)
     &, 1., 273.15)
      call putvara ('precip', iou, ln, is, ic, precip(ils:ile,jls:jle)
     &, 10., 0.)
      call putvara ('evap', iou, ln, is, ic, evap(ils:ile,jls:jle)
     &, 10., 0.)
      call putvara ('outlwr', iou, ln, is, ic, outlwr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call putvara ('uplwr', iou, ln, is, ic, uplwr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call putvara ('upsens', iou, ln, is, ic, upsens(ils:ile,jls:jle)
     &, 0.001, 0.)
      call putvara ('dnswr', iou, ln, is, ic, dnswr(ils:ile,jls:jle)
     &, 0.001, 0.)
      call putvara ('upltnt', iou, ln, is, ic, upltnt(ils:ile,jls:jle)
     &, 0.001, 0.)
      call putvara ('p_alb', iou, ln, is, ic, p_alb(ils:ile,jls:jle)
     &, 1., 0.)
      call putvara ('a_alb', iou, ln, is, ic, a_alb(ils:ile,jls:jle)
     &, 1., 0.)
      call putvara ('s_alb', iou, ln, is, ic, s_alb(ils:ile,jls:jle)
     &, 1., 0.)

      call putvara ('wx', iou, ln, is, ic, wx(ils:ile,jls:jle)
     &, 0.01, 0.)
      call putvara ('wy', iou, ln, is, ic, wy(ils:ile,jls:jle)
     &, 0.01, 0.)

      call putvara ('tice', iou, ln, is, ic, tice(ils:ile,jls:jle)
     &, 1., 273.15)
      call putvara ('hice', iou, ln, is, ic, hice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call putvara ('aice', iou, ln, is, ic, aice(ils:ile,jls:jle)
     &, 1., 0.)
      call putvara ('hsno', iou, ln, is, ic, hsno(ils:ile,jls:jle)
     &, 0.01, 0.)

      call putvara ('uice', iou, ln, is, ic, uice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call putvara ('vice', iou, ln, is, ic, vice(ils:ile,jls:jle)
     &, 0.01, 0.)
      call putvara ('xint', iou, ln, is, ic, xint(ils:ile,jls:jle)
     &, 0.1, 0.)
      call putvara ('yint', iou, ln, is, ic, yint(ils:ile,jls:jle)
     &, 0.1, 0.)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
