! source file: /usr/local/models/UVic_ESCM/2.6/source/common/gasbc.F
      subroutine gasbc

!=======================================================================
!     calculate boundary conditions for the atmospheric model

!     inputs:
!     ncall = number of times this routine was called

!     author:      m.eby                 e-mail=> eby@uvic.ca
!=======================================================================

      implicit none

      include "param.h"
      include "coord.h"
      include "csbc.h"
      include "ice.h"
      include "levind.h"
      include "mapsbc.h"
      include "scalar.h"
      include "switch.h"
      include "tmngr.h"
      include "cembm.h"
      include "atm.h"

      include "solve.h"

      integer i, j

      real slb, sss

      slb = 3.80116e3/ssp

      avetime = 0.0

!-----------------------------------------------------------------------
!     average precipitaion and zero accumulator
!-----------------------------------------------------------------------

      avgp(:,:) = accp(:,:)/(segtim*86400.0)
      accp(:,:) = 0.0

!-----------------------------------------------------------------------
!     zero flux totals for new accumulation
!-----------------------------------------------------------------------

      flux(:,:,:) = 0.0

      do j=2,jmtm1
        do i=2,imtm1

          if (kmt(i,j) .gt. 0) then

!-----------------------------------------------------------------------
!           set sea surface temperature and surface humidity
!-----------------------------------------------------------------------

            surf(i,j,1) = sbcocn(i,j,isst)
            surf(i,j,2) = slb*exp(17.67*surf(i,j,1)/
     &                    (surf(i,j,1) + 243.5))

!-----------------------------------------------------------------------
!           calculate freezing point of sea water using UNESCO (1983)
!-----------------------------------------------------------------------

            sss = 1000.0*sbcocn(i,j,isss) + 35.0
            frzpt(i,j) = -.0575*sss + 1.710523e-3*sss**1.5
     &                   - 2.154996e-4*sss**2

          endif
        enddo

!-----------------------------------------------------------------------
!     update insolation for the current day
!-----------------------------------------------------------------------

        call insolation (dayoyr, yt(j), solins(j))

      enddo

!-----------------------------------------------------------------------
!     update any atmospheric data
!-----------------------------------------------------------------------

      call atmos
      call albedo

      call windspd

!-----------------------------------------------------------------------
!     calcualte CO2 forcing
!-----------------------------------------------------------------------

      call co2forc

!-----------------------------------------------------------------------
!     set flags to calcualte new coefficients
!-----------------------------------------------------------------------

      newcoef(1,1) = .true.
      newcoef(2,1) = .true.
      newcoef(1,2) = .true.
      newcoef(2,2) = .true.

!-----------------------------------------------------------------------
!     zero time average accumulators
!-----------------------------------------------------------------------

      if (.not. timavgperts) call ta_atm_snap (1, imt, 1, jmt, 0)

!-----------------------------------------------------------------------
!     zero time average integral accumulators
!-----------------------------------------------------------------------

      if (.not. tsiperts) call ta_atm_tsi (0)

      return
      end
