!*************************************************************************
!   Routine called by NR linbcg to solve system [Ap]x = b or
!   [Ap^T]x = b for some preconditioner matrix Ap; use either the
!   identity matrix or the diagonal part of A for this, for lack
!   of better choice.  Modified from the NR code, p. 82.
!   I use the diagonal of A, rendering flag itrnsp unused.

!   Sparse vector and it's index vector are size njac = nsys*ndep+2.

    SUBROUTINE asolve(jac,ijac,njac,bvec,xvec,nsys,itrnsp)

!****************************************************************************
      USE global_param
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: nsys,njac,itrnsp
      INTEGER, INTENT(IN) :: ijac(njac)
      REAL(KIND=dp), INTENT(IN) :: bvec(nsys),jac(njac)
      REAL(KIND=dp), INTENT(INOUT) :: xvec(nsys)

      INTEGER :: i

!***********************************************************************
        DO i=1,nsys
          IF (ABS(jac(i)) < zerom) THEN
            WRITE(45,*) 'Zero on diagonal, jac; k = ', i
            STOP
          END IF
          xvec(i)=bvec(i)/jac(i)
        END DO

!***************************************************************************
    END SUBROUTINE asolve
!***************************************************************************
