!*************************************************************************
!   Routine called by NR linbcg to multiply x by sparse matrix jac
!   or its transpose.  Modified from the NR code, p. 81.
!   Sparse vector and it's index vector are size njac = nsys*ndep+2

!   Forward calculation of [A]x or [A^T]x to give b

    SUBROUTINE atimes(jac,ijac,njac,xvec,bvec,nsys,itrnsp)

!****************************************************************************
      USE global_param
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: nsys,itrnsp,njac
      INTEGER, INTENT(IN) :: ijac(njac)
      REAL(KIND=dp), INTENT(IN) :: xvec(nsys),jac(njac)
      REAL(KIND=dp), INTENT(INOUT) :: bvec(nsys)

      INTEGER :: i,j,k

!*************************************************************************
      IF (itrnsp == 0) THEN                  ! jac \times x
                                    ! NR routine dsprsax
         IF (ijac(1) /= nsys+2) pause 'mismatch vector and matrix in sprsax'
         DO i=1,nsys
           bvec(i)=jac(i)*xvec(i)
           DO k=ijac(i),ijac(i+1)-1
              bvec(i)=bvec(i)+jac(k)*xvec(ijac(k))
           END DO
         END DO

      ELSE IF (itrnsp == 1) THEN            ! jac^T \times x
                                    ! NR routine dsprstx
         IF (ijac(1) /= nsys+2) pause 'mismatch vector and matrix in sprstx'
         DO i=1,nsys
           bvec(i)=jac(i)*xvec(i)
         END DO
         DO i=1,nsys
           DO k=ijac(i),ijac(i+1)-1
             j=ijac(k)
             bvec(j)=bvec(j)+jac(k)*xvec(i)
           END DO
         END DO

      END IF

!***************************************************************************
    END SUBROUTINE atimes
!***************************************************************************
