!*************************************************************************
!   Declare arrays for use in subgrid (hypsometric) mass balance

    MODULE bedtd_arrays

!**************************************************************************
      USE global_param
      IMPLICIT NONE
      SAVE

!***************************************************************************
      ! Bed thermal model variables
      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 tbed            ! Bed temperatures (K)

      REAL(dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 hgf,&           ! Elevation of frozen layer (m)
                 hgfk,&          ! Previous frozen layer elevation (m)
                 pfrost

      REAL(dp), ALLOCATABLE, DIMENSION(:), SAVE :: &
                 tbedij,&        ! Local bed temperature (K)
                 tbedijk,&       ! Previous bed temperatures K)
                 resb            ! Residual, bed temp. balance (K)

      INTEGER, ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 ibmode          ! Frozen/unfrozen bed map (2/1)

      REAL(dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                coifull,coefull

      REAL(dp), ALLOCATABLE, DIMENSION(:), SAVE :: &
                tfullij,tfullijk,&
                restfull,dtdtfull,&
                coconfull

!**************************************************************************
   END MODULE bedtd_arrays
!**************************************************************************
