!********************************************************************
!  Calculate inverse ice viscosity/rate factor for longitudinal
!  deformation, from MacAyeal et al, 1982

    FUNCTION Binv(T)

      USE global_param
      IMPLICIT NONE
      REAL(dp) :: Binv
      REAL(dp), INTENT(IN) :: T
      REAL(dp) :: Qactinv,Ao

      Qactinv = 1.2e5_dp            ! T > 260 K
      Ao = 4.1e-3_dp
      Binv = Ao*EXP(Qactinv/(gn*Rgas*T))

    END FUNCTION Binv
