!******************************************************************************
!   Crunch thermal balance terms for ice sheet ice at (k,ij,jj). Includes
!   strain heating strntm, vertical diffusion difftm, heat advection uadtm,
!   vadtm and (wadtmm,wadtm,wadtmp), grid transformation terms grttm,
!   uadgrtm, vadgrtm, and areal source terms srctm, dastm.
!   Units: either a^{-1} or deg C/a.

!   Vertical velocity field wvelt(nvertp) is positive upwards, but
!   uses k=1 at the ice surface and k=nvert at the bed.  Equations
!   solved at cell interfaces.

!   Semi-implicit solver with degree of implicitness fimp.
!   Make all explicit (RHS) terms in system AT^{m+1} = BT^m + c
!   positive by definition; also all independent terms in c.
!   Optimized discretization herein uses upstream differences for
!   the advection terms and a chain-rule balance over temperature
!   (rather than Patankar's energy balance, which is conceptually
!   favourable but numerically jaded).  idisc=4/5 toggles between
!   centred and upstream differences for the vertical terms.

    SUBROUTINE calct0(hi,tiso,tice,ticek,wvelt,vtt,vpt,ttt,tpt,tcolijk,&
                      bmelt,Hsij,delhx,delhhx,delhy,delhhy,uadco,vadco,&
                      gradij,dhidt,dhhdt,uadtm,vadtm,uadgrtm,vadgrtm,&
                      wadtmm,wadtm,wadtmp,grttmm,grttm,grttmp,strntm,&
                      difftm,difftmc,dkdttm,basaltm,kice,qgeo,htslid,&
                      imelt,ratemelt,tmelt,gradrt,gradlt,gradhi,gradlo,&
                      Hrt,Hlt,Hhi,Hlo,delz,cice,ktempl,i,j,k,ij,jj)

!****************************************************************************
      USE global_param
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: i,j,k,ij,jj
      INTEGER, INTENT(INOUT) :: imelt,ktempl
      REAL(dp), INTENT(IN), DIMENSION(nvertp) :: tcolijk
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: tice,ticek,wvelt
      REAL(dp), INTENT(IN), DIMENSION(2:nvertp,nlonp,nlat-1) :: ttt
      REAL(dp), INTENT(IN), DIMENSION(2:nvertp,nlon-1,nlatp) :: tpt
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlat-1) :: vtt
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlon-1,nlatp) :: vpt
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hi
      REAL(dp), INTENT(IN) :: tiso,Hsij,delhx,delhhx,delhy,delhhy,gradij,&
                              uadco,vadco,dhidt,dhhdt,qgeo,htslid,gradrt,&
                              gradlt,gradhi,gradlo,delz,Hrt,Hlt,Hhi,Hlo
      REAL(dp), INTENT(INOUT) :: uadtm,vadtm,uadgrtm,vadgrtm,strntm,&
                                 grttm,grttmm,grttmp,basaltm,wadtmm,cice,&
                                 wadtm,wadtmp,difftm,difftmc,dkdttm,&
                                 kice,ratemelt,tmelt,bmelt(nlon,nlat)
      ! Local variables
      INTEGER :: kj
      REAL(dp) :: dkdt,dtdxi,wadco,gridco,wgrid,uflux,vflux,dxidx,dxidy,&
                  water,qice,ebalance,ttest,tmcorr,depth,tcell,meltcrit,&
                  strn2,strn3,tcell2,tcell3,depth2,depth3,tmcorr2,tmcorr3,&
                  depthrt,depthlt,depthhi,depthlo,strnrt,strnlt,strnhi,&
                  strnlo,ticert,ticelt,ticehi,ticelo

      REAL(dp), EXTERNAL :: B

!*****************************************************************************
      kj = k-1
      IF (k == nvertp) THEN             !! Basal boundary
        dtdxi = (c3*tcolijk(k) -c4*tcolijk(kj) +tcolijk(k-2))/(c2*delz)
      ELSE
        dtdxi = (tcolijk(k+1)-tcolijk(kj))/(c2*delz)
      END IF

!*****************************************************************************
      !! Implicit terms: wdiff, wadv, wgrid
      !! Arbitrate RHS signs for all terms

      ! Diffusion terms
      IF (itdptvar == 0) THEN                ! Constant ice properties
        difftm = tdiffi/delz**2
        dkdttm = c0
        cice = htci
        kice = tcondi
      ELSE IF (itdptvar == 1) THEN           ! T-dependent ice properties
        kice = kice1*EXP(kice2*tcolijk(k))*year
        cice = cice1 + cice2*tcolijk(k)
        difftm = kice/(rhoi*cice*delz**2)
        dkdt = kice3*EXP(kice2*tcolijk(k))*year
        dkdttm = dkdt*dtdxi**2/(rhoi*cice)
      END IF

      !! Vertical advection terms
      wgrid = dhidt - xi(k)*dhhdt
      gridco = wgrid/(c2*delz)

      !! Grid terms (spatial)
      uflux = r2*(vpt(k,i,jj) + vpt(k,ij,jj))
      vflux = r2*(vtt(k,ij,jj)*sinehi(jj) + vtt(k,ij,j)*sinehi(j))
      dxidx = delhx - xi(k)*delhhx
      dxidy = delhy - xi(k)*delhhy

!*****************************************************************************
!*****************************************************************************
      IF (k == nvertp) THEN             !! Basal boundary

        ! Diffusion term; incorporate basal heat flux
        difftmc = c2*(qgeo+htslid)/(rhoi*cice*delz)

        ! vertical advection and grid correction terms
        wadtm = wvelt(k,ij,jj)
        grttm  = -wgrid

        ! Grid terms (spatial)
        uadgrtm = -uflux*dxidx
        vadgrtm = -vflux*dxidy

        ! Sum basal terms
        basaltm = (qgeo+htslid)/kice*(grttm +wadtm + uadgrtm +vadgrtm)

        ! Strain dissipation
        IF (itdcoup == 1) THEN          ! thermomechanic coupling

          IF (istrn == 1) THEN                  ! Simpson's rule
            depth = Hsij*(p75 + p25*xi(kj))
            tcell = p75*tcolijk(k) + p25*tcolijk(kj)
            depth2 = Hsij*r2*(c1 + xi(kj))
            tcell2 = r2*(tcolijk(k) + tcolijk(kj))
            depth3 = Hsij
            tcell3 = tcolijk(k)
          ELSE IF (istrn == 2) THEN             ! Interface average
            depthrt = Hrt*(p75 + p25*xi(kj))
            depthlt = Hlt*(p75 + p25*xi(kj))
            depthhi = Hhi*(p75 + p25*xi(kj))
            depthlo = Hlo*(p75 + p25*xi(kj))
            ticert = p75*tpt(k,i,jj) + p25*tpt(kj,i,jj)
            ticelt = p75*tpt(k,ij,jj) + p25*tpt(kj,ij,jj)
            ticehi = p75*ttt(k,ij,j) + p25*ttt(kj,ij,j)
            ticelo = p75*ttt(k,ij,jj) + p25*ttt(kj,ij,jj)
          END IF

        ELSE
          depth = Hsij*(p75 + p25*xi(kj))
        END IF

!*****************************************************************************
      ELSE                              !! Interior point

        ! Vertical advection terms
        IF (idisc == 4) THEN              ! centre-differenced
          wadtmp = wvelt(k,ij,jj)/(c2*delz)     ! advection
          wadtm = c0
          wadtmm = -wadtmp
          grttmp = -gridco                        ! grid terms
          grttm = c0
          grttmm = gridco

        ELSE IF (idisc == 5) THEN         ! upstreamed
          wadco = wvelt(k,ij,jj)/delz
          IF (wadco <= c0) THEN                        ! advection
            wadtmp = c0
            wadtm = wadco
            wadtmm = -wadco
          ELSE
            wadtmp = wadco
            wadtm = -wadco
            wadtmm = c0
          END IF
          IF (gridco <= c0) THEN                ! grid terms
            grttmp = c0
            grttm = -gridco
            grttmm = gridco
          ELSE
            grttmp = -gridco
            grttm = gridco
            grttmm = c0
          END IF
        END IF                            ! End idisc ifblock

        ! Grid terms (spatial)
        uadgrtm = -uflux*dxidx/(c2*delz)
        vadgrtm = -vflux*dxidy/(c2*delz)

        ! Strain dissipation
        ! Strain dissipation
        IF (itdcoup == 1) THEN          ! thermomechanic coupling

          IF (istrn == 1) THEN                  ! Simpson's rule
            depth = Hsij*xi(k)
            tcell = tcolijk(k)
            IF (k == nvert) THEN
              depth2 = Hsij*r2*(xi(k) + xi(kj))
              tcell2 = r2*(tcolijk(k) + tcolijk(kj))
              depth3 = Hsij*r2*(xi(k) + xi(k+1))
              tcell3 = r2*(tcolijk(k) + tcolijk(k+1))
            END IF
          ELSE IF (istrn == 2) THEN             ! Interface average
            depthrt = Hrt*xi(k)
            depthlt = Hlt*xi(k)
            depthhi = Hhi*xi(k)
            depthlo = Hlo*xi(k)
            ticert = tpt(k,i,jj)
            ticelt = tpt(k,ij,jj)
            ticehi = ttt(k,ij,j)
            ticelo = ttt(k,ij,jj)
          END IF

        ELSE
          depth = Hsij*xi(k)
        END IF

!*****************************************************************************
      END IF                              !! End k ifblock

!**************************************************************
      !! Explicit terms: uadv, vadv, strain

      ! Zonal advection (upstreamed, transformed)
      IF (ij == 1) THEN              ! Default Wward
        uadtm = uadco*uflux*(-ticek(k,i+1,jj) &
                           + c4*ticek(k,i,jj) - c3*tcolijk(k))
      ELSE IF (ij == nlonp) THEN     ! Default Eward
        uadtm = uadco*uflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij-1,jj) + ticek(k,ij-2,jj))
      ELSE
        IF (uflux > zerop) THEN                  ! Eward flow
          ! Ensure that there are two upstream cells
          IF (hi(i-2,j) > hi(ij,j)) THEN                ! 3-pt upstream
            uadtm = uadco*uflux*(c3*tcolijk(k) &
                         - c4*ticek(k,ij-1,jj) + ticek(k,ij-2,jj))
          ELSE                                          ! 2-pt upstream
            uadtm = c2*uadco*uflux*(tcolijk(k) - ticek(k,ij-1,jj))
          END IF
        ELSE IF (uflux < -zerop) THEN            ! Wward flow
          ! Ensure that there are two upstream cells
          IF (hi(i+2,j) > hi(i+1,j)) THEN               ! 3-pt upstream
            uadtm = uadco*uflux*(-c3*tcolijk(k) &
                         + c4*ticek(k,i,jj) - ticek(k,i+1,jj))
          ELSE                                          ! 2-pt upstream
            uadtm = c2*uadco*uflux*(ticek(k,i,jj)-tcolijk(k))
          END IF
        ELSE                                        ! Inconsequential flow
          uadtm = uadco*uflux*(ticek(k,i,jj)-ticek(k,ij-1,jj))  ! CD
        END IF
      END IF

      ! Meridional advection (upstreamed, transformed)
      IF (jj == 1) THEN                          ! Sward flow
        vadtm = vadco*vflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij,j) + ticek(k,ij,j+1))
      ELSE IF (jj == nlatp) THEN                 ! Nward flow
        vadtm = vadco*vflux*(-ticek(k,ij,jj-2) &
                        + c4*ticek(k,ij,jj-1) -c3*tcolijk(k))
      ELSE
        IF (vflux > zerop) THEN               ! Sward flow
          IF (hi(i,j+2) > hi(i,j+1)) THEN               ! 3-pt upstream
            vadtm = vadco*vflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij,j) + ticek(k,ij,j+1))
          ELSE                                          ! 2-pt upstream
            vadtm = c2*vadco*vflux*(tcolijk(k)-ticek(k,ij,j))
          END IF
        ELSE IF (vflux < -zerop) THEN         ! Nward flow
          IF (hi(i,j-2) > hi(i,jj)) THEN                ! 3-pt upstream
            vadtm = vadco*vflux*(-ticek(k,ij,jj-2) &
                        + c4*ticek(k,ij,jj-1) - c3*tcolijk(k))
          ELSE                                          ! 2-pt upstream
            vadtm = c2*vadco*vflux*(ticek(k,ij,jj-1)-tcolijk(k))
          END IF
        ELSE                                     ! Inconsequential flow
          vadtm = vadco*vflux*(ticek(k,ij,jj-1)-ticek(k,ij,j))   ! CD
        END IF
      END IF

!**************************************************************************
      ! Strain dissipation
      IF (itdcoup == 0) THEN            ! Dynamics uncoupled from TD
        strntm = c2*Biso/(rhoi*cice)  &
                  *(rhoi*grav*depth)**gnp1*gradij**(gnp1/c2)
      ELSE
        IF (istrn == 1) THEN
          ! Apply quadratic Simpson's rule
          tmcorr = tcell + fptdep*depth
          strntm = c2*B(tmcorr)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth)**gnp1*gradij**(gnp1/c2)
          IF ((k==nvert).or.(k==nvertp)) THEN
            tmcorr2 = tcell2 + fptdep*depth2
            strn2 = c2*B(tmcorr2)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth2)**gnp1*gradij**(gnp1/c2)
            tmcorr3 = tcell3 + fptdep*depth3
            strn3 = c2*B(tmcorr3)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth3)**gnp1*gradij**(gnp1/c2)
            strntm = r6*(c4*strntm + strn2 + strn3)
          END IF

        ELSE IF (istrn == 2) THEN
          ! Average strain heating at the interfaces
          strnrt = c2*B(ticert)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthrt)**gnp1*gradrt**(gnp1/c2)
          strnlt = c2*B(ticelt)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthlt)**gnp1*gradlt**(gnp1/c2)
          strnhi = c2*B(ticehi)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthhi)**gnp1*gradhi**(gnp1/c2)
          strnlo = c2*B(ticelo)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthlo)**gnp1*gradlo**(gnp1/c2)

          strntm = p25*(strnrt + strnlt + strnhi + strnlo)

        END IF
      END IF

!**************************************************************************
      ! Treat temperate layer: may include several cells
      imelt = 0
      tmelt = triplept - fptdep*Hsij*xi(k)
      water = c0                  ! Temporary--til we find water
      ttest = tcolijk(k) - tmelt
      meltcrit = 0.001_dp

      IF ((tcolijk(k) >= tmelt) .OR. (ABS(ttest)< meltcrit)) THEN   ! pmp

        IF (k == nvertp) THEN
          qice = kice*dtdxi
          ebalance = strntm + uadtm + vadtm + difftmc + dkdttm + basaltm &
                      + c2*difftm*(-tcolijk(k)+tcolijk(kj))    ! Deg C/a
          IF (ebalance >= c0) THEN                  ! Melting, specify T_pmp
            imelt = 1
            ratemelt = (qgeo+htslid-qice)/(rhoi*tlat)
            bmelt(i,j) = bmelt(i,j) + ratemelt    ! Sum over temperate layer
            ktempl = MIN(ktempl,k-1)

          ELSE
            IF (water > c0) THEN                  ! Refreezing, specify T_pmp
              imelt = 1
              ratemelt = (qgeo+htslid-qice)/(rhoi*tlat)
              bmelt(i,j) = bmelt(i,j) + ratemelt  ! Sum over temperate layer
              ktempl = MIN(ktempl,kj)
            ELSE                                  ! Cooling, full solution
              imelt = 0
            END IF
          END IF

        ELSE                  ! Internal temperate layer
          ebalance = strntm + uadtm + vadtm + dkdttm &
                    + (wadtm+grttm-c2*difftm)*tcolijk(k) &
                    + (wadtmm+grttmm+difftm-uadgrtm-vadgrtm)*tcolijk(kj) &
                    + (wadtmp+grttmp+difftm+uadgrtm+vadgrtm)*tcolijk(k+1)
          IF (ebalance >= c0) THEN           ! Melting, specify T_pmp
            imelt = 1
            ratemelt = ebalance*cice*delz/tlat
            bmelt(i,j) = bmelt(i,j) + ratemelt  ! Sum over temperate layer
            ktempl = MIN(ktempl,kj)
          ELSE                          ! Cooling, full solution
            imelt = 0
          END IF
        END IF

      END IF

!***************************************************************************
    END SUBROUTINE calct0
!***************************************************************************
