!**********************************************************************
!   Calculate theoretical maximum time step required for TD update
!   of a column of ice with thickness Hice and surface velocity
!   wsurf.  This is the recommended inner timestep.  Returns the
!   minimum integer factor of outer time step delt (deltn).

    SUBROUTINE caldeltn(wsurf,Hicecur,deltn)

!**********************************************************************
      USE global_param
      IMPLICIT NONE
      REAL(KIND=dp), INTENT(IN) :: wsurf,Hicecur
      REAL(KIND=dp), INTENT(INOUT) :: deltn
      ! Local variables
      REAL(KIND=dp) :: advlim,difflim,deltnex,zeroeff

      zeroeff = 1.e-5_dp
      IF (ABS(wsurf) > zeroeff) THEN
        advlim = Hicecur/(ABS(wsurf)*DBLE(nvert))
      ELSE
        advlim = 20.0_dp
      END IF
      difflim = (Hicecur/DBLE(nvert))**2/(2.0_dp*tdiffi)
      deltnex = MIN(advlim,difflim)
      IF (deltnex >= deltt) THEN
         deltn = deltt
      ELSE IF ((deltnex>=deltt/2.0_dp).and.(deltnex < deltt)) THEN
         deltn = deltt/2.0_dp
      ELSE IF ((deltnex>=deltt/5.0_dp).and.(deltnex < deltt/2.0_dp)) THEN
         deltn = deltt/5.0_dp
      ELSE IF ((deltnex>=deltt/10.0_dp).and.(deltnex < deltt/5.0_dp)) THEN
         deltn = deltt/10.0_dp
      ELSE IF ((deltnex>=deltt/20.0_dp).and.(deltnex < deltt/10.0_dp)) THEN
         deltn = deltt/20.0_dp
      ELSE IF ((deltnex>=deltt/40.0_dp).and.(deltnex < deltt/20.0_dp)) THEN
         deltn = deltt/40.0_dp
      ELSE IF ((deltnex>=deltt/80.0_dp).and.(deltnex < deltt/40.0_dp)) THEN
         deltn = deltt/80.0_dp
      ELSE
         deltn = deltt/160.0_dp
!         WRITE(45,*) 'Time step requirements too severe'
!         WRITE(45,*) 'deltstab ', REAL(deltnex)
!         WRITE(45,*) 'wsurf,Hice,deltt', wsurf,Hicecur,deltt
      END IF

!***************************************************************************
    END SUBROUTINE caldeltn
!***************************************************************************
