!=======================================================================
!     This subroutine gives present-day and initial bed topography, and
!     initial land mask.

!     init  = initial conditions [1/2/3]
!               1: no initial land ice
!               2: restart from the previous run
!               3: ICE-4G reconstruction
!     hg0   = present-day bed topography (m)
!     hg    = bed topography (m)
!     iland = land mask [1/0/-1]
!               1: land
!               0: shallow ocean (continental shelf)
!              -1: deep ocean (deeper than 1,000m)

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_get_bed(hg0,hg,iland)

#if defined ubc_cidm
! ... global
      USE global_param   ! dp,c0,nlon,nlat,init
      IMPLICIT NONE

! ... subroutine arguments
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: hg0,hg
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: iland

! ... local
      INTEGER :: i,j,k,ndata,n
      INTEGER,DIMENSION(1:nlon,1:nlat) :: bism_kmt
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat) :: dhg,Hice
      CHARACTER(LEN=30) :: fname

!-----------------------------------------------------------------------
!     present-day bed topography
!-----------------------------------------------------------------------

      fname = 'bism_data/init_hg.dta'
      OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
      READ(1) i,j
      READ(1) ((hg(i,j),i=1,nlon),j=1,nlat)
      CLOSE(UNIT=1)

# if defined uvic_embm
!-----------------------------------------------------------------------
!     judge the land mask, "iland" [1/0/-1] from MOM-EMBM data
!     ocean model information
!       depth at kmt=0 is    0m (land)
!       depth at kmt=7 is  890m (ocean)
!       depth at kmt=8 is 1122m (ocean)
!-----------------------------------------------------------------------

      OPEN(1,FILE='bism_data/bism_kmt.dta',STATUS='OLD',&
           FORM='UNFORMATTED')
      READ(1) i,j
      READ(1) ((bism_kmt(i,j),i=1,nlon),j=1,nlat)
      CLOSE(1)

      WHERE (bism_kmt <= 0)
        iland = 1
      ELSEWHERE
        iland = 0
      ENDWHERE
      IF (ishelf > 0) THEN
        WHERE (bism_kmt >= 8) iland = -1
      END IF

!-----------------------------------------------------------------------
!     adjust the present-day bed topography, "hg", to match with the
!     land mask, "iland", i.e.,
!       1. no positive bed topography over ocean
!       2. no negative bed topography over land

!     ocean model information
!       depth at kmt=1 is   44m (ocean), shallowest depth
!       depth at kmt=8 is 1122m (ocean)
!-----------------------------------------------------------------------

      WHERE ((iland == 1).AND.(hg < c0)) hg = c0
      WHERE ((iland == 0).AND.(hg > c0)) hg = -44._dp
      IF (ishelf > 0) THEN
        WHERE ((iland == -1).AND.(hg > c0)) hg = -1122._dp
      END IF

# endif
!-----------------------------------------------------------------------
!     undisturbed bed topography, "hg0" (m)
!-----------------------------------------------------------------------

      dhg = c0
      IF (irebound > 0) THEN
        fname = 'bism_data/init_dhg.dta'
        OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
        READ(1) i,j
        READ(1) ((dhg(i,j),i=1,nlon),j=1,nlat)
        CLOSE(UNIT=1)
        WHERE (iland <= 0) dhg = c0
      END IF
      hg0 = hg + dhg

!-----------------------------------------------------------------------
!     bed topography, "hg" (m)
!-----------------------------------------------------------------------

      IF (init == 1) THEN        ! no initial ice

        hg = hg0

!      ELSE IF (init == 2) THEN   ! restart this is now read in cidm_read_rest

!        fname = 'bism_data/rest_hg.in'
!        OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
!        READ(1) i,j
!        READ(1) ((hg(i,j),i=1,nlon),j=1,nlat)
!        CLOSE(UNIT=1)

      ELSE IF (init == 3) THEN   ! LGM ice

!-----------------------------------------------------------------------
!       adjust bed elevation over land inside the domain
!-----------------------------------------------------------------------

        dhg = c0
        IF (irebound > 0) THEN
          fname = 'bism_data/ice4g21_dhg.dta'
          OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
          READ(1) i,j
          READ(1) ((dhg(i,j),i=1,nlon),j=1,nlat)
          CLOSE(UNIT=1)
          WHERE (iland <= 0) dhg = c0
        END IF
        hg = hg + dhg

!-----------------------------------------------------------------------
!       adjust bed elevation over land outside the domain
!-----------------------------------------------------------------------

        Hice = c0
        fname = 'bism_data/ice4g21_Hice.dta'
        OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
        READ(1) i,j
        READ(1) ((Hice(i,j),i=1,nlon),j=1,nlat)
        CLOSE(UNIT=1)
        WHERE (iland <= 0) Hice = c0
        WHERE (idomain /= -1) Hice = c0
        hg = hg + Hice

      END IF

# if !defined uvic_embm
!-----------------------------------------------------------------------
!     judge the land mask, "iland", from the bed topography, "hg"
!-----------------------------------------------------------------------

      WHERE (hg >= sealevel)
        iland = 1
      ELSEWHERE
        iland = 0
      ENDWHERE
      IF (ishelf > 0) THEN
        WHERE (sealevel-hg > 1000._dp) iland = -1
      END IF

# endif
!-----------------------------------------------------------------------
!     lateral boundary conditions
!-----------------------------------------------------------------------

      CALL cidm_lbc_2d_real(hg0)
      CALL cidm_lbc_2d_real(hg)
      CALL cidm_lbc_2d_int(iland)

#endif
!=======================================================================
      END SUBROUTINE cidm_get_bed
!=======================================================================
