!=======================================================================
!     This subroutine calculates surface elevation and judges if the ice
!     is floating or not.

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_get_surf(iland,hg,Hice,ifloating,hi)

#if defined ubc_cidm
! ... global variables
      USE global_param   ! dp,nlon,nlat,ishelf,iceberg
      IMPLICIT NONE

! ... subroutine arguments
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(IN) :: iland
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(IN) :: hg,Hice
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: ifloating
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: hi

! ... local variables
      INTEGER :: i,j

!-----------------------------------------------------------------------
!     judge floating ice and calculate surface elevation
!-----------------------------------------------------------------------

      IF (ishelf > 0) THEN   ! shelf-ice option
        DO j=1,nlat
          DO i=1,nlon
            IF (iland(i,j) == 1) THEN
              hi(i,j) = hg(i,j) + Hice(i,j)
              ifloating(i,j) = 0
            ELSE IF (iland(i,j) == -1) THEN
              hi(i,j) = sealevel
              ifloating(i,j) = 0
            ELSE
              hi(i,j) = sealevel + iceberg*Hice(i,j)
              IF (hi(i,j)-Hice(i,j) <= hg(i,j)) THEN   ! grounding
                hi(i,j) = hg(i,j) + Hice(i,j)
                ifloating(i,j) = 0
              ELSE                                     ! floating
                ifloating(i,j) = 1
              END IF
            END IF
          END DO
        END DO
      ELSE
        ifloating = 0
        WHERE (iland == 1)
          hi = hg + Hice
        ELSEWHERE
          hi = sealevel
        ENDWHERE
      END IF

!-----------------------------------------------------------------------
!     lateral boundary conditions
!-----------------------------------------------------------------------

      CALL cidm_lbc_2d_real(hi)
      CALL cidm_lbc_2d_int(ifloating)

#endif
!=======================================================================
      END SUBROUTINE cidm_get_surf
!=======================================================================
