!************************************************************************
!   Updates isostatic earth depression based on simple harmonic
!   (viscous) oscillator model with characteristic mantle response
!   time tau.  Parabolic equation, solved implicitly at each
!   point hg(i,j).  I use the bulk ice thickness H_b = aH_s+(1-a)H_c.

    SUBROUTINE cidm_isos(hg0,hg,hi,Hice,Hicekt,dhgdt,hgk,hgkt,hik,hikt,&
                    load,vert,loadscale,alinear,aquad,bquad,curvature,&
                    time_maxwell,hg_maxwell,iglacial,ifloating,iland)

!************************************************************************
      USE subgrid_arrays
      USE hydrol_arrays
      IMPLICIT NONE
      INTEGER, DIMENSION(nlon,nlat), INTENT(IN) :: iglacial,ifloating,iland
      REAL(dp), DIMENSION(nlon,nlat), INTENT(IN) :: Hice,Hicekt,hg0
      REAL(dp), DIMENSION(nlat), INTENT(IN) :: loadscale
      REAL(dp), DIMENSION(0:200,0:ntisos+1), INTENT(IN) :: vert
      REAL(dp), DIMENSION(nlon,nlat), INTENT(INOUT) :: dhgdt,hg,hi,&
                                                       hgk,hgkt,hik,hikt,&
                                                       alinear,aquad,&
                                                       bquad,curvature
      REAL(dp), DIMENSION(0:ntisos,nlon,nlat), INTENT(INOUT) :: load
      REAL(dp), DIMENSION(0:2), INTENT(INOUT) :: time_maxwell
      REAL(dp), DIMENSION(0:2,nlon,nlat), INTENT(INOUT) :: hg_maxwell

      ! Local variables
      INTEGER :: i,j,k,nt,nthist
      REAL(dp) :: coimp,coexp,hicur,hiprev,Hnet,Hnew,Hprev,delhsub,coeff
      REAL(dp) :: marine_load,ice_load,net_load,lake_load
      LOGICAL :: lfloat

!************************************************************************
      ! Branch between full Maxwellan spherical Earth response or
      ! simple, locally-damped response

!************************************************************************
      IF (irebound == 1) THEN                ! Local visco-elastic response

        coimp = c1 + delt/(c2*tau)
        coexp = c1 - delt/(c2*tau)

        ! Account for changing ocean load
        marine_load = sealevel*rhow/rhoe

!************************************************************************
        IF (isubtop == 2) THEN                ! Account for subgrid buildup
          DO j=3,nlatp
            DO i=3,nlonp
              lfloat = .false.
              IF ((iglacial(i,j)==0).and.(icesub(nhyps,i,j) > c0)) THEN
                ! Subgrid ice
                Hnet = Heff(i,j)
                IF ((hg(i,j) + Hnet) < iceberg*Hnet) lfloat = .true.
              ELSE                                ! Glaciated cell
                Hnet = Hice(i,j)
                IF (ifloating(i,j) == 1) lfloat = .true.
              END IF
              IF (.not.(lfloat) .and. (Hnet > c0)) THEN
                ice_load = Hnet*rhoi/rhoe
                IF (hg0(i,j) < c0) THEN                ! was once submerged
                  ice_load = ice_load + hg0(i,j)*rhow/rhoe    ! reduce
                END IF
                marine_load = c0
              ELSE
                ice_load = c0
                IF (hg(i,j) < MAX(sealevel,c0)) THEN          ! submerged
                  IF (hg0(i,j) < MAX(sealevel,c0)) THEN     ! initially doused
                    marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                  ELSE                                            ! initially land
                    marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                  END IF
                ELSE
                  marine_load = c0
                END IF
              END IF
              net_load = ice_load + marine_load

              IF (igingembre > 0) THEN                        ! proglacial lakes
                IF ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) THEN
                  ! incremental lake load, if lake is higher than sea level
                  lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                  net_load = net_load + lake_load
                END IF
              END IF

              hg(i,j) = (coexp*hgk(i,j) + delt/tau*(hg0(i,j)-net_load))/coimp
              hi(i,j) = hg(i,j) + Hnet

            END DO
          END DO

!************************************************************************
        ELSE                                ! Not subgrid modelling
          coeff = delt/(c2*tau)
          DO j=1,nlat
            DO i=1,nlon
              ice_load = c0
              marine_load = c0
              IF ((idomain(i,j) == 1).AND.(iland(i,j) == 1)) THEN
                ice_load = Hice(i,j)*rhoi/rhoe
                net_load = ice_load + marine_load
                hg(i,j) = ((c1 - coeff)*hgk(i,j) &
                           - c2*coeff*(net_load - hg0(i,j)))/(c1 + coeff)
              END IF
            END DO
          END DO
          CALL cidm_get_surf(iland,hg,Hice,ifloating,hi)
          CALL cidm_lbc_2d_real(hg)
          CALL cidm_lbc_2d_real(hi)
        END IF

!          DO j=3,nlatp
!            DO i=3,nlonp
!              IF ((Hice(i,j) > c0) .and. (ifloating(i,j) == 0)) THEN
!                ice_load = Hice(i,j)*rhoi/rhoe
!                IF (hg0(i,j) < c0) THEN                ! was once submerged
!                  ice_load = ice_load + hg0(i,j)*rhow/rhoe    ! reduce
!                END IF
!                marine_load = c0
!              ELSE
!                ice_load = c0
!                IF (hg(i,j) < MAX(sealevel,c0)) THEN          ! submerged
!                  IF (hg0(i,j) < MAX(sealevel,c0)) THEN     ! initially doused
!                    marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
!                  ELSE                                            ! initially land
!                    marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
!                  END IF
!                ELSE
!                  marine_load = c0
!                END IF
!              END IF
!              net_load = ice_load + marine_load

!              IF (igingembre > 0) THEN                        ! proglacial lakes
!                IF ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) THEN
!                  ! incremental lake load, if lake is higher than sea level
!                  lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
!                  net_load = net_load + lake_load
!                END IF
!              END IF

!              hg(i,j) = (coexp*hgk(i,j) + delt/tau*(hg0(i,j)-net_load))/coimp
!              hi(i,j) = hg(i,j) + Hice(i,j)

!              END IF
!            END DO
!          END DO

        ! Basal motion
        dhgdt = (hg - hgk)/deltb

!************************************************************************
!************************************************************************
      ELSE IF (irebound == 2) THEN        ! Maxwell Earth response

        ! Check if time for the full Maxwell solution (1000-yr intervals)
        IF (MOD(ctime,deltb) == c0) THEN

          ! Update the load history
          nthist = MIN(ntisos, INT((ctime-stime)/deltb))
          DO j=3,nlatp
            DO i=3,nlonp
              DO nt=nthist,1,-1                       ! bump down old loads
                load(nt,i,j) = load(nt-1,i,j)
              END DO
            END DO
          END DO

          ! Current load, including ice, ocean, and proglacial lake changes
          IF (isubtop == 2) THEN                ! Account for subgrid buildup
            DO j=3,nlatp
              DO i=3,nlonp
                lfloat = .false.
                IF ((iglacial(i,j)==0).and.(icesub(nhyps,i,j) > c0)) THEN
                  ! Subgrid ice
                  Hnet = Heff(i,j)
                  IF ((hg(i,j) + Hnet) < iceberg*Hnet) lfloat = .true.
                ELSE                                ! Glaciated cell
                  Hnet = Hice(i,j)
                  IF (ifloating(i,j) == 1) lfloat = .true.
                END IF
                IF (.not.(lfloat) .and. (Hnet > c0)) THEN
                  ice_load = Hnet
                  IF (hg0(i,j) < c0) THEN                ! was once submerged
                    ice_load = ice_load + hg0(i,j)*rhow/rhoi    ! reduce
                  END IF
                  marine_load = c0
                ELSE
                  ice_load = c0
                  IF (hg(i,j) < MAX(sealevel,c0)) THEN          ! submerged
                    IF (hg0(i,j) < MAX(sealevel,c0)) THEN   ! initially doused
                      marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                    ELSE                                    ! initially land
                      marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                    END IF
                  ELSE
                    marine_load = c0
                  END IF
                END IF
                net_load = ice_load + marine_load

                IF (igingembre > 0) THEN                ! proglacial lakes
                  IF ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) THEN
                    ! incremental lake load, if lake is higher than sea level
                    lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                    net_load = net_load + lake_load
                  END IF
                END IF

                load(0,i,j) = net_load*loadscale(j)     ! current load

              END DO
            END DO

!--------------------------------------------------------------------------
          ELSE                                ! Large-scale modelling
            DO j=3,nlatp
              DO i=3,nlonp
                IF ((Hice(i,j) > c0) .and. (ifloating(i,j) == 0)) THEN
                  ice_load = Hice(i,j)
                  IF (hg0(i,j) < c0) THEN                ! was once submerged
                    ice_load = ice_load + hg0(i,j)*rhow/rhoi    ! reduce
                  END IF
                  marine_load = c0
                ELSE
                  ice_load = c0
                  IF (hg(i,j) < MAX(sealevel,c0)) THEN          ! submerged
                    IF (hg0(i,j) < MAX(sealevel,c0)) THEN   ! initially doused
                      marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                    ELSE                                    ! initially land
                      marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                    END IF
                  ELSE
                    marine_load = c0
                  END IF
                END IF
                net_load = ice_load + marine_load

                IF (igingembre > 0) THEN                ! proglacial lakes
                  IF ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) THEN
                    ! incremental lake load, if lake is higher than sea level
                    lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                    net_load = net_load + lake_load
                  END IF
                END IF

                load(0,i,j) = net_load*loadscale(j)     ! current load

              END DO
            END DO
          END IF            ! isubtop ifblock

          ! Call isostatic update module

#if !defined uvic_embm
          CALL isos_maxwell(hg,hg0,load,vert,loadscale,time)
#endif
!*************************************************************************
        ELSE                ! Extrapolate isostatic evolution between
                        ! full Maxwell Earth solutions, using the local
                        ! bed elevations from the three previous full
                        ! solutions and a quadratic extrapolator.
#if !defined uvic_embm
          CALL extrapolate_maxwell(hg,load,alinear,aquad,bquad,curvature,&
                                   time_maxwell,hg_maxwell,time)
#endif
        END IF                ! update timecheck ifblock

        dhgdt = (hg - hgk)/100.0_dp

!*************************************************************************
      END IF              ! irebound ifblock
!*************************************************************************
      ! Update
      hgk = hg                          ! For next isostatic adjustment

      ! Remove isostatic component from ice dynamics
      hik = hi

      ! Adjust isostatic component for ice thermodynamics
      hgkt = hg
      hikt = hgkt + Hicekt

      IF (isubtop == 2) THEN                ! Account for subgrid buildup
        ! Adjust subgrid topography
        DO j=1,nlat
          DO i=1,nlon
            delhsub = dhgdt(i,j)*delt
            DO k=1,nhyps
              hsub(k,i,j) = hsub(k,i,j) + delhsub
            END DO
           END DO
        END DO
      END IF

!***************************************************************************
    END SUBROUTINE cidm_isos
!***************************************************************************
