!=======================================================================
!     This module declares embm-related parameters, variables and
!     arrays.

!     author:   m.yoshimori
!=======================================================================

      MODULE cidm_mod_embm

#if defined ubc_cidm && defined uvic_embm
      USE global_param   ! dp
      IMPLICIT NONE
      SAVE

!-----------------------------------------------------------------------
!     parameters in general
!       mi: ratio of longitudinal resolution of CIDM to that of
!           the atmospehre model
!       mj: ratio of latitudinal resolution of CIDM to that of
!           the atmospehre model
!       imint,imaxt,jmint,jmaxt: data will be extracted from the domain
!         (imint,jmint)-(jmint,jmaxt) of the atmosphere model
!       iimt: number of longitudinal tracer grid in the extracted domain
!       jjmt: number of latitudinal tracer grid in the extracted domain
!       imt: number of longitudinal tracer grid in the atmosphere model
!       jmt: number of latitudinal tracer grid in the atmosphere model
!-----------------------------------------------------------------------

      INTEGER,PARAMETER :: mi = 1
      INTEGER,PARAMETER :: mj = 1
      INTEGER,PARAMETER :: imint = 1
      INTEGER,PARAMETER :: imaxt = 102
      INTEGER,PARAMETER :: jmint = 1
      INTEGER,PARAMETER :: jmaxt = 102
      INTEGER,PARAMETER :: iimt = (imaxt-imint+1)*mi
      INTEGER,PARAMETER :: jjmt = (jmaxt-jmint+1)*mj
      INTEGER,PARAMETER :: imt = 102
      INTEGER,PARAMETER :: jmt = 102
      REAL(KIND=dp),PARAMETER :: dxt = 3.6_dp
      REAL(KIND=dp),PARAMETER :: dyt = 1.8_dp
      REAL(KIND=dp),PARAMETER :: xt_min =  -1.8_dp
      REAL(KIND=dp),PARAMETER :: yt_min = -90.9_dp
      REAL(KIND=dp),DIMENSION(1:iimt),SAVE :: xt
      REAL(KIND=dp),DIMENSION(1:jjmt),SAVE :: yt

!-----------------------------------------------------------------------
!     parameters to calculate fluxes to the ocean model
!-----------------------------------------------------------------------

      REAL(KIND=dp),PARAMETER :: flice = 3.34e9_dp

!-----------------------------------------------------------------------
!     arrays for surface mass balance
!       atm_s_ann: annual mean snow (m/year w.e.)
!       atm_m_ann: annual mean surface melting (m/year w.e.)
!       atm_r_ann: annual mean rain (m/year w.e.)
!-----------------------------------------------------------------------

      INTEGER :: nsum
      REAL(KIND=dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        atm_s_ann,&
        atm_m_ann,&
        atm_r_ann

#endif
!=======================================================================
      END MODULE cidm_mod_embm
!=======================================================================
