!=======================================================================
!     This subroutine writes restart-file for continuation-run.

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_rest_writ(avg_Hice,avg_hi,avg_calv,avg_aice)

#if defined ubc_cidm
! ... global
      USE global_vars
# if defined uvic_embm
      USE cidm_mod_embm
# endif
      IMPLICIT NONE

! ... subroutine arguments
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:iimt,1:jjmt) :: avg_hi,&
                                         avg_calv,avg_Hice,avg_aice

! ... local
      INTEGER :: i,j
      CHARACTER(LEN=30),DIMENSION(1:2) :: fname

!-----------------------------------------------------------------------
!     input file names
!-----------------------------------------------------------------------

      fname(1) = 'bism_data/rest_cidm.out'
# if defined uvic_embm
      fname(2) = 'bism_data/rest_embm.out'
# endif

!-----------------------------------------------------------------------
!     write restart file for CIDM
!-----------------------------------------------------------------------

      OPEN(UNIT=1,FILE=fname(1),STATUS='UNKNOWN',FORM='UNFORMATTED')
      WRITE(1) nlon,nlat
      WRITE(1) ((hg(i,j),i=1,nlon),j=1,nlat)
      WRITE(1) ((Hice(i,j),i=1,nlon),j=1,nlat)
      CLOSE(UNIT=1)

# if defined uvic_embm
!-----------------------------------------------------------------------
!     write restart file for EMBM
!-----------------------------------------------------------------------

      OPEN(UNIT=2,FILE=fname(2),STATUS='UNKNOWN',FORM='UNFORMATTED')
      WRITE(UNIT=2) ((avg_hi(i,j)   ,i=1,iimt),j=1,jmt)
      WRITE(UNIT=2) ((avg_calv(i,j) ,i=1,iimt),j=1,jmt)
      WRITE(UNIT=2) ((avg_Hice(i,j) ,i=1,iimt),j=1,jmt)
      WRITE(UNIT=2) ((avg_aice(i,j) ,i=1,iimt),j=1,jmt)
      CLOSE(UNIT=2)

# endif
#endif
!=======================================================================
      END SUBROUTINE cidm_rest_writ
!=======================================================================

!=======================================================================
!     This subroutine reads restart-file for continuation-run.

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_rest_read(avg_Hice,avg_hi,avg_calv,avg_aice)

#if defined ubc_cidm && defined uvic_embm
! ... global
      USE global_param
      USE global_vars
      USE cidm_mod_embm
      IMPLICIT NONE

! ... subroutine arguments
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:iimt,1:jjmt) :: avg_hi,&
                                          avg_calv,avg_Hice,avg_aice

! ... local
      INTEGER :: i,j
      CHARACTER(LEN=30),DIMENSION(1:2) :: fname

!-----------------------------------------------------------------------
!     input file specifications
!-----------------------------------------------------------------------

      fname(1) = 'bism_data/rest_cidm.out'
      fname(2) = 'bism_data/rest_embm.out'

!-----------------------------------------------------------------------
!     read restart file for CIDM
!-----------------------------------------------------------------------

      OPEN(UNIT=1,FILE=fname(1),STATUS='OLD',FORM='UNFORMATTED')
      READ(1) nlon,nlat
      READ(1) ((hg(i,j),i=1,nlon),j=1,nlat)
      READ(1) ((Hice(i,j),i=1,nlon),j=1,nlat)
      CLOSE(UNIT=1)

!-----------------------------------------------------------------------
!     read restart file for coupling
!-----------------------------------------------------------------------

      OPEN(UNIT=1,FILE=fname(2),STATUS='OLD',FORM='UNFORMATTED')
      READ(UNIT=1) ((avg_hi(i,j)   ,i=1,iimt),j=1,jjmt)
      READ(UNIT=1) ((avg_calv(i,j) ,i=1,iimt),j=1,jjmt)
      READ(UNIT=1) ((avg_Hice(i,j) ,i=1,iimt),j=1,jjmt)
      READ(UNIT=1) ((avg_aice(i,j) ,i=1,iimt),j=1,jjmt)
      CLOSE(UNIT=1)

#endif
!=======================================================================
      END SUBROUTINE cidm_rest_read
!=======================================================================
