!=======================================================================
!     This subroutine writes the summary of the basic information.

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_summary

#if defined ubc_cidm
      USE global_vars
      USE cidm_mod_embm   ! ni,nj
      IMPLICIT NONE

!-----------------------------------------------------------------------
!     basic information output
!-----------------------------------------------------------------------

      WRITE(*,*)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) '                     CIDM summary                    '
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'resolution (degree):'
      WRITE(*,1) ' longitude = ',delphid
      WRITE(*,1) ' latitude  = ',delthed
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'number of tracer grids:'
      WRITE(*,*) 'longitude =',nlon
      WRITE(*,*) 'latitude  =',nlat
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'physical domain (degree):'
      WRITE(*,2) ' min longitude = ',phimin+delphid
      WRITE(*,2) ' max longitude = ',phimax-delphid
      WRITE(*,2) ' min latitude  = ',themin+delthed
      WRITE(*,2) ' max latitude  = ',themax-delthed
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'numerical domain (degree):'
      WRITE(*,2) ' min longitude = ',phimin
      WRITE(*,2) ' max longitude = ',phimax
      WRITE(*,2) ' min latitude  = ',themin
      WRITE(*,2) ' max latitude  = ',themax
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'bed elevation (m):'
      WRITE(*,3) ' min = ',MINVAL(hg)
      WRITE(*,3) ' max = ',MAXVAL(hg)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'ice thickness (m):'
      WRITE(*,3) ' min = ',MINVAL(Hice)
      WRITE(*,3) ' max = ',MAXVAL(Hice)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'surface elevation (m):'
      WRITE(*,3) ' min = ',MINVAL(hi)
      WRITE(*,3) ' max = ',MAXVAL(hi)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*) 'output interval (yr):'
      WRITE(*,4) ' ice volume = ',dtvol
      WRITE(*,4) ' snapshot   = ',dtsnap
      WRITE(*,4) ' restart    = ',dtrest
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*)

    1 FORMAT(A13,F8.2)
    2 FORMAT(A17,F8.2)
    3 FORMAT(A7,F8.2)
    4 FORMAT(A14,F8.1)

#endif
!=======================================================================
      END SUBROUTINE cidm_summary
!=======================================================================
