!=======================================================================
!     Bilinear interpolation

!     reference: Numerical Receipe, p.116,117

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_tool_interp(nx1,ny1,x1,y1,data1,&
                                  nx2,ny2,x2,y2,data2,spval)

      IMPLICIT NONE

      INTEGER,PARAMETER :: dp = 8
      REAL(KIND=dp),PARAMETER :: c1 = 1._dp
      INTEGER,INTENT(IN) :: nx1,ny1,nx2,ny2
      REAL(KIND=dp),DIMENSION(1:nx1),INTENT(IN) :: x1
      REAL(KIND=dp),DIMENSION(1:ny1),INTENT(IN) :: y1
      REAL(KIND=dp),DIMENSION(1:nx2),INTENT(IN) :: x2
      REAL(KIND=dp),DIMENSION(1:ny2),INTENT(IN) :: y2
      REAL(KIND=dp),DIMENSION(1:nx1,1:ny1),INTENT(IN) :: data1
      REAL(KIND=dp),INTENT(IN) :: spval
      REAL(KIND=dp),DIMENSION(1:nx2,1:ny2),INTENT(OUT) :: data2

      INTEGER :: i,j,k,l
      REAL(KIND=dp) :: a1,a2,a3,a4,t,u

      data2 = spval

      DO i=1,ny2
        DO j=1,ny1-1
          IF ((y2(i) >= y1(j)).AND.(y2(i) <= y1(j+1))) THEN
            DO k=1,nx2
              DO l=1,nx1-1
                IF ((x2(k) >= x1(l)).AND.(x2(k) <= x1(l+1))) THEN

                  a1 = data1(l,j)
                  a2 = data1(l+1,j)
                  a3 = data1(l+1,j+1)
                  a4 = data1(l,j+1)

                  t = (x2(k)-x1(l)) / (x1(l+1)-x1(l))
                  u = (y2(i)-y1(j)) / (y1(j+1)-y1(j))

                  data2(k,i) = (c1-t)*(c1-u)*a1 + t*(c1-u)*a2 + t*u*a3 &
                              + (c1-t)*u*a4

                  IF (data1(l,j) == spval         &
                      .OR.data1(l+1,j) == spval   &
                      .OR.data1(l+1,j+1) == spval &
                      .OR.data1(l,j+1) == spval)  &
                    data2(k,i)=spval
                END IF
              END DO
            END DO
          END IF
        END DO
      END DO

!=======================================================================
      END SUBROUTINE cidm_tool_interp
!=======================================================================

!=======================================================================
!     Fill in missing data based on code by W. Lee

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_tool_fill(nx,ny,a,spval)

      IMPLICIT NONE
      INTEGER,PARAMETER :: dp = 8
      REAL(KIND=dp),PARAMETER :: c0 = 0._dp

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(INOUT),DIMENSION(1:nx*ny) :: a
      REAL(KIND=dp),INTENT(IN) :: spval

! ... local
      INTEGER :: i,j,ii,jj,i1,i2,nsum,nfix
      REAL(KIND=dp) :: sum
      REAL(KIND=dp),DIMENSION(1:3,1:3) :: ind

      DO
        nfix = 0
        DO j = 1,ny
          DO i = 1,nx
            ind(2,2) = (j-1)*nx + i

!-----------------------------------------------------------------------
!           If point in question is ok, skip to next point.
!-----------------------------------------------------------------------

            IF (a(ind(2,2)) < 1.E30) CYCLE

            ind(1,2) = ind(2,2) - 1
            ind(3,2) = ind(2,2) + 1

            ind(1,1) = ind(1,2) - nx
            ind(2,1) = ind(2,2) - nx
            ind(3,1) = ind(3,2) - nx

            ind(1,3) = ind(1,2) + nx
            ind(2,3) = ind(2,2) + nx
            ind(3,3) = ind(3,2) + nx

            IF (i == 1) THEN
               ind(1,2) = j * nx  - 1
               ind(1,1) = ind(1,2) - nx
               ind(1,3) = ind(1,2) + nx
            END IF

            IF (i == nx) THEN
               ind(3,2) = (j-1) * nx + 1
               ind(3,1) = ind(3,2)    - nx
               ind(3,3) = ind(3,2)    + nx
            END IF

            sum  = c0
            nsum = 0

            DO jj = 1,3
               IF ((jj == 1).and.(j == 1)) CYCLE
               IF ((jj == 3).and.(j == ny)) CYCLE
               DO ii = 1,3
                  IF ((ii == 2).and.(jj == 2)) CYCLE
                  IF (a(ind(ii,jj)) > 1.E30) CYCLE
                  sum  = sum  + a(ind(ii,jj))
                  nsum = nsum + 1
               END DO
            END DO

            IF (nsum >= 3) a(ind(2,2)) = sum / DBLE(nsum)
            nfix = nfix + 1

          END DO
        END DO

        IF (nfix == 0) EXIT
      END DO

!=======================================================================
      END SUBROUTINE cidm_tool_fill
!=======================================================================

!=======================================================================
!     Convert 2D array matrix into 1D array vector

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_tool_convert1d(nx,ny,matrix,vector)

      IMPLICIT NONE
      INTEGER,PARAMETER :: dp = 8

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nx,1:ny) :: matrix
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nx*ny) :: vector

! ... local
      INTEGER :: i,j,k

      DO j = 1,ny
        DO i = 1,nx
          k = nx*(j-1) + i
          vector(k) = matrix(i,j)
        END DO
      END DO

!=======================================================================
      END SUBROUTINE cidm_tool_convert1d
!=======================================================================

!=======================================================================
!     Convert 1D array vector into 2D array matrix

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_tool_convert2d(nx,ny,vector,matrix)

      IMPLICIT NONE
      INTEGER,PARAMETER :: dp = 8

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nx*ny) :: vector
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nx,1:ny) :: matrix

! ... local
      INTEGER :: i,j,k

      DO j = 1,ny
        DO i = 1,nx
          k = nx*(j-1) + i
          matrix(i,j) = vector(k)
        END DO
      END DO

!=======================================================================
      END SUBROUTINE cidm_tool_convert2d
!=======================================================================
