!=======================================================================
!     This subroutine calculates ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere (m^3)
!     vol_NH: total ice volume in the Northern Hemisphere (m^3)

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_vol_calc(Hice,vol_SH,vol_NH)

! ... global
      USE global_param   ! dp,c0,nlon,nlat,nvol,itime,idvol,igrid,area
      IMPLICIT NONE

! ... subroutine arguments
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(INOUT) :: Hice
      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(INOUT) :: vol_SH,vol_NH

! ... local
      INTEGER :: ivol,neq,i,j

      ivol = INT(ctime/dtvol) + 1

!-----------------------------------------------------------------------
!     check 'Hice' values
!-----------------------------------------------------------------------

      CALL cidm_lbc_2d_real(Hice)
      WHERE (Hice < c0) Hice = c0

!-----------------------------------------------------------------------
!     set some constants
!-----------------------------------------------------------------------

      IF (MOD(nlat,2) == 0) THEN
        neq = nlat/2
      ELSE
        neq = (nlat+1)/2
      END IF

!-----------------------------------------------------------------------
!     ice volume in the Southern Hemisphere, vol_SH (m^3)
!-----------------------------------------------------------------------

      vol_SH(ivol) = c0
      DO j=1,neq
        DO i=2,nlon-1
          vol_SH(ivol) = vol_SH(ivol) + Hice(i,j)*area(j)
        END DO
      END DO

!-----------------------------------------------------------------------
!     ice volume in the Northern Hemispere, vol_NH (m^3)
!-----------------------------------------------------------------------

      vol_NH(ivol) = c0
      DO j=neq+1,nlat
        DO i=2,nlon-1
          vol_NH(ivol) = vol_NH(ivol) + Hice(i,j)*area(j)
        END DO
      END DO

!=======================================================================
      END SUBROUTINE cidm_vol_calc
!=======================================================================

!=======================================================================
!     This subroutine writes ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere (m^3)
!     vol_NH: total ice volume in the Northern Hemisphere (m^3)

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_vol_writ(vol_SH,vol_NH)

! ... global
      USE global_param   ! dp,nlon,nlat,nvol
      IMPLICIT NONE

! ... subroutine arguments
      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(IN) :: vol_SH,vol_NH

! ... local
      INTEGER :: ivol,i

      ivol = INT(ctime/dtvol) + 1

!-----------------------------------------------------------------------
!     ice volume in the Southern Hemisphere, vol_SH (m^3)
!-----------------------------------------------------------------------

      OPEN(1,FILE='bism_data/vol_SH.dat',STATUS='UNKNOWN')
      WRITE(1,*) ivol
      DO i=1,ivol
        WRITE(1,*) dtvol*DBLE(i-1),vol_SH(i)
      END DO
      CLOSE(1)

!-----------------------------------------------------------------------
!     ice volume in the Northern Hemispere, vol_NH (m^3)
!-----------------------------------------------------------------------

      OPEN(1,FILE='bism_data/vol_NH.dat',STATUS='UNKNOWN')
      WRITE(1,*) ivol
      DO i=1,ivol
        WRITE(1,*) dtvol*DBLE(i-1),vol_NH(i)
      END DO
      CLOSE(1)

!=======================================================================
      END SUBROUTINE cidm_vol_writ
!=======================================================================

!=======================================================================
!     This subroutine read ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere
!     vol_NH: total ice volume in the Northern Hemisphere

!     author:   m.yoshimori
!=======================================================================

      SUBROUTINE cidm_vol_read(vol_SH,vol_NH)

      USE global_param   ! dp,nvol,ivol,istart,itime
      IMPLICIT NONE

      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(OUT) :: vol_SH,vol_NH

! ... Local variables
      INTEGER :: ivol,i

      OPEN(1,FILE='bism_data/vol_SH.dat',STATUS='OLD')
      READ(1,*) ivol
      DO i=1,ivol
        READ(1,*) ctime,vol_SH(i)
      END DO
      CLOSE(1)

      OPEN(1,FILE='bism_data/vol_NH.dat',STATUS='OLD')
      READ(1,*) ivol
      DO i=1,ivol
        READ(1,*) ctime,vol_NH(i)
      END DO
      CLOSE(1)

!=======================================================================
      END SUBROUTINE cidm_vol_read
!=======================================================================
