       subroutine cidmout (snapts, timavgts, tsits, timunit
     &,                    expnam, relyr, stamp)
!=======================================================================
!     output routine for energy-moisture balance model

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      use global_vars

      character(80) :: ftsi, ftavg, fsnap, fname, file_stamp, timunit
      character(60) :: expnam
      character(32) :: stamp
      save ftsi, ftavg, fsnap
      data ftsi  /' '/
      data ftavg /' '/
      data fsnap /' '/

      integer ntrec
      logical snapts, timavgts, tsits
      real avgper, relyr

      if (timavgts) then

!-----------------------------------------------------------------------
!       write icesheet time averaged data
!-----------------------------------------------------------------------

        ntrec = 1
        is = 1
        ie = nlon
        js = 1
        je = nlat

        if (ftavg .eq. ' ') ntrec = 0
        if (ftavg .eq. ' ') ftavg = file_stamp('time_mean',stamp,'.nc')
        avgper = delt
        call cidm_snap_out (ftavg, is, ie, js, je, nlon, nlat, lon, lat
     &,                     ntrec, timunit, expnam, avgper, relyr, stamp
     &,                     hg(is:ie,js:je), hice(is:ie,js:je)
     &,                     hi(is:ie,js:je), balance(is:ie,js:je)
#if defined rot_grid
     &,                     tlat(is:ie,js:je), tlon(is:ie,js:je)
     &,                     ulat(is:ie,js:je), ulon(is:ie,js:je)
#endif
     &                      )

        write (*,'(a,i4,a,a,a,i10,a,a)') '=> Icesheet time mean #'
     &,   ntrec, ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp

      endif

      if (snapts) then

!-----------------------------------------------------------------------
!       write icesheet snapshot
!-----------------------------------------------------------------------

        ntrec = 1
        if (fsnap .eq. ' ') ntrec = 0
#if defined uvic_io_multiple_files
        fsnap = file_stamp('sice',stamp,'.nc')
#elif uvic_io_single_file
        fsnap = 'snapshots.nc'
#else
        if (fsnap .eq. ' ') fsnap = file_stamp('snapshots',stamp,'.nc')
#endif
        avgper = 0.
        is = 1
        ie = nlon
        js = 1
        je = nlat

        call cidm_snap_out (fsnap, is, ie, js, je, nlon, nlat, lon, lat
     &,                     ntrec, timunit, expnam, avgper, relyr, stamp
     &,                     hg(is:ie,js:je), hice(is:ie,js:je)
     &,                     hi(is:ie,js:je), balance(is:ie,js:je)
#if defined rot_grid
     &,                     tlat(is:ie,js:je), tlon(is:ie,js:je)
     &,                     ulat(is:ie,js:je), ulon(is:ie,js:je)
#endif
     &                      )

        write (*,'(a,i4,a,a,a,i10,a,a)') '=> Icesheet snapshot #'
     &,   ntrec, ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp

      endif

      return
      end

      subroutine cidm_snap_writ(sum_calv)
      return
      end
