!****************************************************************************
!   Routine to DO the forwards transformation from the temperature grid
!   xi to the dynamical grid zeta.  Uses stock NMS routines
!   pchez and pchev to DO a Hermite cubic interpolation between grids.
!   I actually work in intermediate real (z) space, since it has the proper
!   sense, as enforced by pchez.

    SUBROUTINE fdtrans(tice,ticev,hi,Hice)

!****************************************************************************
      USE global_param
      IMPLICIT NONE
      REAL(KIND=dp), INTENT(IN) :: Hice(nlon,nlat),hi(nlon,nlat),&
                                   tice(nvertp,nlonp,nlatp)
      REAL(KIND=dp), INTENT(INOUT) :: ticev(nvertp,nlonp,nlatp)

      ! Local variables
      INTEGER :: ierr,i,j,kd,ij,jj,kt,narray
      INTEGER, PARAMETER :: lwk=100
      REAL, DIMENSION(lwk) :: wk
#if defined uvic_ibm
      REAL(dP), DIMENSION(nvertp) :: z,temp,d,zv,tempv,dv
#else
      REAL, DIMENSION(SIZE(zeta)) :: z,temp,d,zv,tempv,dv
#endif
      LOGICAL :: spline

!****************************************************************************
      spline = .true.
#if defined uvic_ibm
      narray = nvertp
#else
      narray = SEZE(zeta)
#endif
      DO j=2,nlat-1            ! Loop over all interior sheet columns
        jj=j-1
        DO i=2,nlon-1
          ij=i-1
          IF (Hice(i,j) > zerop) THEN
            ! Map xi grid to z, put into single precision
            ! Solve at zeta points in velocity (zv) space
            DO kd=1,nvertp
              kt = nvertp - kd + 1
              z(kd) = hi(i,j)-Hice(i,j)*xi(kt)            ! bottom to top
#if defined uvic_ibm
              temp(kd) = tice(kt,ij,jj)
              zv(kd) = hi(i,j)-Hice(i,j)/aa*LOG(zeta(kd))
#else
              temp(kd) = REAL(tice(kt,ij,jj))
              zv(kd) = REAL(hi(i,j)-Hice(i,j)/aa*LOG(zeta(kd)))
#endif
            END DO

            CALL is_pchez(narray,z,temp,d,spline,wk,lwk,ierr)
            CALL is_pchev(narray,z,temp,d,narray,zv,tempv,dv,ierr)

            DO kd=1,nvertp
              ticev(kd,ij,jj) = DBLE(tempv(kd))
            END DO

          END IF
        END DO
      END DO

!***************************************************************************
    END SUBROUTINE fdtrans
!***************************************************************************
