!=======================================================================

!   Global variables and definitions for program bare
!   Streamlined version of mix, for pure sheet flow.

!   Dependent variables are staggered on the finite-difference mesh.
!   All heights and thicknesses are solved at the cell centres,
!   (hg, hgk, hgo, hi, hik).  k denotes the previous time step fields.
!   External fields such as air temperature (tair), precipitation
!   (precip), mass balance (balance), and geothermal flux (geo),
!   also exist at the cell-centres.  Vertical velocity (wvel, wvelt)
!   and temperature fields (tice, ticek, ticev) exist at cell centres,
!   horizontally, and at the vertical cell interfaces.  The column
!   vectors (tcolij, tcolijk) are local work-space for the temp. field.
!   For sheet flow, horizontal speeds are at the appropriate interfaces,
!   four locations per cell (vt,vp,vtk,vpk,vtt,vpt). For stream
!   flow, the direction vectors (dip, dit) are defined at cell interfaces.
!   Vertical velocity (wvel, wvelt) is at the cell centres.

!   Suffixes t and v denote vertically-transformed variables
!   between the thermodynamic and dynamic grids. Extraneous arrays
!   include columnar velocities (vvelhi, uvelrt, etc.),
!   the transformed vertical nodes (zeta, xi), and iteration
!   workspace (rhsc, dhdt, rests, restc, jac1, jac2, jact)

!   author:   s.marshall
!=======================================================================

      MODULE global_vars

      USE global_param
      IMPLICIT NONE
      SAVE

!-----------------------------------------------------------------------
!     surface mask
!-----------------------------------------------------------------------

      INTEGER,ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        iland,&         ! Land/ocean map  (1/0)
        ideep,&         ! Deepwater ocean (no ice possible)  (1/0)
        igreen,&        ! Greenland mask  (1/0)
        iglacial,&      ! Glacial (full-grid) ice here? (1/0)
        imargin,&       ! Marginal cells (1/0)
        ifloating,&     ! Floating ice here? (1/0)
        icelevel,&      ! Level of subgrid ice saturation (1-nhyps)
        icover          ! Ice coverage here? (1/0)

!-----------------------------------------------------------------------
!     ice volume
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:),SAVE :: &
        vol_SH,&   ! total ice volume in the Southern Hemisphere
        vol_NH     ! total ice volume in the Northern Hemisphere

!-----------------------------------------------------------------------
!     ice thickness and topography fields
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        hg,&            ! Bed topography (m)
        hgk,&           ! Previous bed topography (m)
        hgkt,&          ! T-loop, prev bed surface (m)
        dhgdt,&         ! Rate of isostatic adjustment (m/a)
        Hocean,&        ! Ocean water depth  (m)
        hg0,&           ! Present-day bed topography (m)
        slope,&         ! Surface slope
        slope0,&        ! Initial surface slope
        hi0,&           ! Initial ice sheet surface (m)
        hi,&            ! Ice sheet surface  (m)
        hik,&           ! Previous ice surface (m)
        hikt,&          ! T-loop, previous ice sheet surface (m)
        Hice,&          ! Ice sheet thickness  (m)
        Hicek,&         ! Previous ice sheet thickness  (m)
        Hicekt,&        ! T-loop previous ice sheet thickness  (m)
        vert            ! Green's function table, Maxwell earth

      REAL(dp),ALLOCATABLE,DIMENSION(:,:,:) :: &
        load,&                 ! Load history for isostatic solution (m)
        hg_maxwell      ! Bed history for isostatic solution (m)

      REAL(dp),ALLOCATABLE,DIMENSION(:,:) :: &
        alinear,&       ! Linear dh/dt trend, Maxwell extrapolator
        aquad,&         ! Quadratic dh/dt trend, Maxwell extrapolator
        bquad,&         ! Quadratic dh/dt trend, Maxwell extrapolator
        curvature       ! d^2/dt^2 trend, Maxwell extrapolator

      REAL(dp),ALLOCATABLE,DIMENSION(:) :: &
        loadscale,&     ! Load scaling, isostatic solution
        time_maxwell    ! Time history, Maxwell extrapolator

!-----------------------------------------------------------------------
!     mass balance
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:,:,:),SAVE :: &
        albedo          ! Monthly albedo field, full solar

      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        landfrac,&      ! Subgrid land/water fraction
        precip,&        ! Ice-equivalent total precip (m/a)
        rainfall,&        ! Water-equivalent wet precip (m/a)
        balance,&       ! Mass balance rate (m/a)
        tair,&          ! Air temperature (K)
        pddnet,&        ! Annual degree-days (\degC d)
        smelt,&         ! Surface melt (m/a)
        acc,&           ! Surface accumulation (m/a)
        calve,&         ! Calving rate (m/a)
        annamp,&        ! Annual temperature cycle (K)
        geo,&           ! Geothermal heat flux (W/m^2)
        tsea,&          ! Sea surface temperature (K)
        tseaC,&         ! Sea surface temperature (deg C)
        coszrs,&        ! Cos of zenith angle, for dirct albedo
        bckgrnd,&       ! Background albedo field, NCAR LSM
        soot,&          ! Debris concentration in snow
        snowrad,&       ! Grain size of snow (mu m)
        snowdep,&       ! Depth of snow (m water-equivalent)
        snowage,&       ! Age of snow (days)
        snowfrac        ! Cell fraction which is snow-covered

      REAL(dp),ALLOCATABLE,DIMENSION(:),SAVE :: &
        glacial,&       ! Glacial index; LGM=100, present=0
        delO,&          ! Oxygen isotope history (GRIP)
        delsea,&        ! Sea level history
        pfrac

!-----------------------------------------------------------------------
!     velocity fields
!-----------------------------------------------------------------------

      ! Fluxes
      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        Bbar,&          ! Column ice stiffness (Pa^-3 a^-1)
        Tbar,&          ! Column-averaged ice temperature (K)
        vb,&            ! Meridional basal velocity (m/a)
        ub,&            ! Zonal basal velocity (m/a)
        vbk,&           ! Previous meridional basal velocity (m/a)
        ubk,&           ! Previous zonal basal velocity (m/a)
        ftsht,&         ! Meridional sheet ice flux (m^2/a)
        fpsht,&         ! Zonal sheet ice flux (m^2/a)
        ftshtk,&        ! As above, but previous
        fpshtk          !       "

      INTEGER,ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        ivb,&            ! Activity flag, meridional sliding (0/1)
        iub              ! Activity flag, zonal sliding (0/1)

      ! Velocity fields
      REAL(dp),ALLOCATABLE,DIMENSION(:,:,:),SAVE :: &
        vt,&            ! Meridional sheet velocity (m/a)
        vp,&            ! Zonal sheet velocity (m/a)
        wvel            ! Vertical sheet velocity (m/a)

!-----------------------------------------------------------------------
!     temperature fields
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        tsole           ! Basal ice temperature (K)

      REAL(dp) :: tiso  ! Isothermal temperature (K)

!-----------------------------------------------------------------------
!     hydrological variables ; see also /hydrol/hydrol_arrays
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        bmelt,&         ! Basal melt rate (m/a)
        peff,&          ! Effective water pressure (Pa)
        pwater,&        ! Water pressure (Pa)
        pice,&          ! Ice pressure (Pa)
        pnorm,&         ! Normalized water pressure (Pa)
        bwater          ! Basal water layer thickness (m)

!-----------------------------------------------------------------------
!     numerical stuffs
!-----------------------------------------------------------------------

      REAL(dp),ALLOCATABLE,DIMENSION(:),SAVE :: &
        peclet                 ! Grid peclet numbers for column

      REAL(dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        jac1,&          ! Jacobian matrix, dynamical sweep 1
        jac2,&          ! Jacobian matrix, dynamical sweep 2
        dhdtb,&         ! Equilibrium mass disbalance (m/a)
        coimp,&         ! Implicit coefficients, ice TD: A
        coexp           ! Explicit coefficients, ice TD: B

      REAL(dp),ALLOCATABLE,DIMENSION(:),SAVE :: &
        rhsc,&          ! Residuals in Newton iteration (m/a)
        dhdt,&          ! Mass disbalance (m/a)
        rest,&          ! Residual energy from ice column (K)
        dtdt,&          ! Temperature disbalance (K)
        cocon           ! Constant coefficients: c
                        ! For system AT^{m+1} = BT^{m} + c

      REAL(dp),ALLOCATABLE,DIMENSION(:),SAVE :: &
        dhidt          ! Mass disbalance in bicg solution (m/a)

!=======================================================================
      END MODULE global_vars
!=======================================================================
