!***************************************************************************
!   Define hydrological parameters

    MODULE hydrol_param

!***************************************************************************
      USE global_param
      IMPLICIT NONE
      SAVE

!***************************************************************************
      REAL(KIND=dp), PARAMETER :: href = c2
      REAL(KIND=dp), PARAMETER :: fimpw = c1
      REAL(KIND=dp), PARAMETER :: afimpw = c1 - fimpw

     ! Parameterization values, hydraulic conductivity
      REAL(KIND=dp), PARAMETER :: kmin = -12._dp
      REAL(KIND=dp), PARAMETER :: kmax = -6._dp
      REAL(KIND=dp), PARAMETER :: kco1 = r2*(kmax + kmin)
      REAL(KIND=dp), PARAMETER :: kco2 = kmax - kmin
      REAL(KIND=dp), PARAMETER :: kco3 = -kco2/c3
      REAL(KIND=dp), PARAMETER :: kco4 = -10._dp

      ! Parameterization values, pressure-thickness relationship
      REAL(KIND=dp), PARAMETER :: phwco1 = 0.05_dp
      REAL(KIND=dp), PARAMETER :: phwco2 = c1 + phwco1

      ! Surface water parameters
      REAL(KIND=dp), PARAMETER :: viscw = 0.001787_dp                ! 0 deg C
      REAL(KIND=dp), PARAMETER :: sheetco = -r3*rhow*grav/viscw
      INTEGER, PARAMETER :: khsurf = 5
      REAL(KIND=dp), PARAMETER :: darcyco = c10**khsurf                ! m/s
      REAL(KIND=dp), PARAMETER :: diffwco = c3*c10**khsurf         ! m^2/s
      REAL(KIND=dp), PARAMETER :: margin = -800._dp                ! m

!***************************************************************************
    END MODULE hydrol_param
!***************************************************************************
