!****************************************************************************
! Assign temperatures to cell interfaces for the velocity integration.
! This version bases interface assignment on upstream direction.
! Incorporate correction for the pressure-softening de facto here
! (the flow law has no pressure effects in it).

  SUBROUTINE interface_temps(ticev,tt,tp,hi,Hice)

!****************************************************************************
    USE global_param
    IMPLICIT NONE
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: ticev
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice,hi
    REAL(dp), INTENT(OUT), DIMENSION(nvert,nlonp,nlat-1) :: tt
    REAL(dp), INTENT(OUT), DIMENSION(nvert,nlon-1,nlatp) :: tp

    ! Local
    INTEGER :: i,j,k,im,ip,jm,jp
    REAL(dp) :: hcrit,tmcorr,Hlt,Hlo
    REAL(dp), DIMENSION(nvertp,nlon,nlat) :: temp
    REAL(dp), DIMENSION(nvertp) :: logzeta

    hcrit = 10._dp                         ! Threshold for dynamic influence
    DO k=1,nvertp
      logzeta(k) = LOG(zeta(k))/aa
    END DO

    DO j=2,nlat-1
      DO i=2,nlon-1
        im = i-1
        jm = j-1
        temp(1:nvertp,i,j) = ticev(1:nvertp,im,jm)
      END DO
    END DO

    DO j = 1,nlat
      temp(1:nvertp,1,j)    = temp(1:nvertp,nlon-1,j)
      temp(1:nvertp,nlon,j) = temp(1:nvertp,2,j)
    END DO

    DO i = 1,nlon
      temp(1:nvertp,i,1)    = temp(1:nvertp,i,2)
      temp(1:nvertp,i,nlat) = temp(1:nvertp,i,nlat-1)
    END DO

!****************************************************************************
    ! Assign lower and left interfaces
    DO j=2,nlatp
      DO i=1,nlon-1
        ip = i+1
        jp = j+1

        Hlt = r2*(Hice(ip,jp) + Hice(i,jp))
        Hlo = r2*(Hice(ip,jp) + Hice(ip,j))

!*******************************************************************
!*******************************************************************
        IF (Hice(ip,jp) < zerop) THEN        !! No ice here
                                        !! Assign upstream or null T

          IF (Hlt < zerop) THEN           ! No zonal flux
            DO k=1,nvert
              tp(k,i,j) = tnoice
            END DO
          ELSE                                   ! Default Eward
            DO k=1,nvert
              tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
              tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                     + tmcorr, triplept)
            END DO
          END IF

        ELSE                                !! Ice present; look for upstream

          IF (i == nlonp) THEN           ! Default Eward
            DO k=1,nvert
              tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
              tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                     + tmcorr, triplept)
            END DO

          ELSE                                  ! Interior
            IF (hi(ip,jp) < hi(i,jp)) THEN           ! Eastward flow
              DO k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                    + tmcorr, triplept)
              END DO
            ELSE IF (hi(ip,jp) > hi(i,jp)) THEN      ! Westward flow
              DO k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(r2*(temp(k,ip,j) + temp(k+1,ip,j)) &
                                                    + tmcorr, triplept)
              END DO
            ELSE                                   ! No flow
                 DO k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(p25*(temp(k,ip,j) + temp(k+1,ip,j) &
                                + temp(k,i,j) + temp(k+1,i,j)) &
                                                       + tmcorr, triplept)
              END DO
            END IF
          END IF          ! Boundary block
        END IF                ! If ice block

!*******************************************************************
!*******************************************************************
        ! Meridional interface temperatures

        IF (Hice(ip,jp) < zerop) THEN        !! No ice here
                                        !! Assign upstream or null T

          IF (Hlo < zerop) THEN           ! No meridional flux
            DO k=1,nvert
              tt(k,i,j) = tnoice
            END DO
          ELSE                                   ! Default Northward
            DO k=1,nvert
              tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
              tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                  + tmcorr, triplept)
            END DO
          END IF

        ELSE                                !! Ice present; look for upstream

          IF (j == nlatp) THEN           ! Default Northward
            DO k=1,nvert
              tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
              tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                  + tmcorr, triplept)
            END DO

          ELSE                                  ! Interior
            IF (hi(ip,jp) > hi(ip,j)) THEN                ! Southward flow
              DO k=1,nvert
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(r2*(temp(k,i,jp) + temp(k+1,i,jp)) &
                                                    + tmcorr, triplept)
              END DO
            ELSE IF (hi(ip,jp) < hi(ip,j)) THEN                ! Northward flow
              DO k=1,nvert
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                    + tmcorr, triplept)
              END DO
            ELSE
              DO k=1,nvert                                ! No flow
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(p25*(temp(k,i,jp)+temp(k+1,i,jp) &
                                     + temp(k,i,j)+temp(k+1,i,j)) &
                                                   + tmcorr, triplept)
              END DO
            END IF
          END IF          ! Boundary block
        END IF                ! If ice block

      END DO
    END DO

!****************************************************************************
  END SUBROUTINE interface_temps
!****************************************************************************
