!=======================================================================
!     Glen's flow law parameters as a function of temperature
!=======================================================================

      FUNCTION B(T) RESULT(res)

#if defined ubc_cidm
      USE global_param   ! dp,itdcoup,Rgas
                         ! Boiso,Bocold,Bowarm,Qactiso,Qactwarm,Qactcold
      IMPLICIT NONE

      REAL(kind=dp),INTENT(IN) :: T
      REAL(kind=dp) :: res

!      IF (itdcoup == 0) THEN
!        res = Boiso*EXP(-Qactiso/(Rgas*T))
!      ELSE IF (itdcoup == 1) THEN
        IF (T < 263.15_dp) THEN
          res = Bocold*EXP(-Qactcold/(Rgas*T))
        ELSE
          res = Bowarm*EXP(-Qactwarm/(Rgas*T))
        END IF
!      END IF

#endif
!=======================================================================
      END FUNCTION B
!=======================================================================
