!=======================================================================
!     Solve the full 2D dynamical system.
!=======================================================================

      SUBROUTINE is_dyn (hg,hgk,hi,hik,dhgdt,Hice,Hicek,wvel,vt,vp,tiso,&
                                ub,vb,ubk,vbk,iub,ivb,Bbar,Tbar,Hocean,balance,&
                         bmelt,acc,smelt,calve,dhidt,fpshtk,ftshtk,fpsht,&
                         ftsht,pice,icover,iland,ifloating,&
                         ltdcur,ldiverge,res,time,fwater)

!-----------------------------------------------------------------------
!     declare constants and variables
!-----------------------------------------------------------------------

      USE hydrol_arrays
      USE shelf_arrays
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: iland
      INTEGER, INTENT(INOUT), DIMENSION(nlon,nlat) :: ifloating,icover
      INTEGER, INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: iub
      INTEGER, INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: ivb

      REAL(dp), INTENT(IN) :: tiso
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hg,hgk,dhgdt,hik,Hicek,&
                                                    Hocean,bmelt,Tbar,acc,&
                                                    balance,calve,pice
      REAL(dp), INTENT(OUT) :: res
      REAL(dp), INTENT(INOUT), DIMENSION(ndsys) :: dhidt
      REAL(dp), INTENT(INOUT), DIMENSION(nlon,nlat) :: hi,Hice,smelt,Bbar
#if defined uvic_embm
      REAL(dp), INTENT(OUT), DIMENSION(nlon,nlat) :: fwater
#endif
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb,vbk,ftshtk,ftsht
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub,ubk,fpshtk,fpsht
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlonp,nlatp) :: wvel
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlonp,nlat-1) :: vt
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlon-1,nlatp) :: vp

      LOGICAL, INTENT(IN) :: ltdcur
      LOGICAL, INTENT(INOUT) :: ldiverge

      ! Local variables
      INTEGER :: i,j,ij,jj,ip,jp,k,iter,ntries,iterb,itmax,itol,ncc
      REAL(dp) :: crit,tol,err,fluxin,icein,elfloat
#if defined uvic_embm
      REAL(dp) :: dM_dramuda,dM_dtheta
#endif
      REAL(dp), PARAMETER :: Bslid = -0.001_dp*rhoi*grav
      REAL(dp), PARAMETER :: Dcoeff = c2*(rhoi*grav/erad)**3

      INTEGER, ALLOCATABLE, DIMENSION(:) :: &
                 ijacd          ! Index matrix for jacd (dynamics iteration)

      REAL(dp), ALLOCATABLE, DIMENSION(:) :: &
                 Hvect,&         ! Ice thickness (m)
                 Hvectk,&         ! Previous sheet thickness (m)
                 Hvimp,&         ! Implicit ice thickness vector (m)
                 hivect,&         ! Ice surface (m)
                 hivectk,&         ! Previous ice surface (m)
                 hivimp,&         ! Implicit ice surface vector (m)
                  resd,&                 ! Residuals in dynamical iteration (m/a)
                  deld,&                 ! Step size, Newton iteration (m/a)
                   jacd                   ! Sparse matrix for dynamics iteration

      REAL(dp), DIMENSION(nlonp,nlat-1) :: scalehi,Hhi,hgthi,hgphi,&
                                           gradhi,alphahi,dbarhi
      REAL(dp), DIMENSION(nlon-1,nlatp) :: scalert,Hrt,hgtrt,hgprt,&
                                           gradrt,alphart,dbarrt

!-----------------------------------------------------------------------
!     allocate workspace
!-----------------------------------------------------------------------

      ALLOCATE (Hvect(ndsys))                ; Hvect = c0
      ALLOCATE (Hvectk(ndsys))                ; Hvectk = c0
      ALLOCATE (Hvimp(ndsys))                ; Hvimp = c0
      ALLOCATE (hivect(ndsys))                ; hivect = c0
      ALLOCATE (hivectk(ndsys))                ; hivectk = c0
      ALLOCATE (hivimp(ndsys))                ; hivimp = c0
      ALLOCATE (resd(ndsys))                ; resd = c0
      ALLOCATE (deld(ndsys))                ; deld = c0
      ALLOCATE (jacd(njacd))                ; jacd = c0
      ALLOCATE (ijacd(njacd))                ; ijacd = 0

!-----------------------------------------------------------------------
!     convergence criteria for full system solution
!-----------------------------------------------------------------------

      crit = 1.e-4_dp   ! 0.1 mm/a
      ntries = 41       ! Iteration limit
      res = c1                ! Initialization

!-----------------------------------------------------------------------
!     load current ice thicknesses and surfaces into work vectors
!-----------------------------------------------------------------------

      DO j = 1,nlat
        DO i = 1,nlon
          k = i+nlon*(j-1)
          Hvectk(k)  = Hice(i,j)
          hivectk(k) = MAX(hi(i,j), sealevel)
        END DO
      END DO

!-----------------------------------------------------------------------
!     initial guesses for update
!-----------------------------------------------------------------------

      deld   = dhidt*delt
      Hvect  = Hvectk + deld
      hivect = hivectk + deld

#if defined uvic_embm
!-----------------------------------------------------------------------
!     set boundary conditions for global domain
!-----------------------------------------------------------------------

      CALL cidm_lbc_1d(Hvectk)
      CALL cidm_lbc_1d(hivectk)
      CALL cidm_lbc_1d(Hvect)
      CALL cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!     implicit values for Crank-Nicholson (or other) solution
!-----------------------------------------------------------------------

      Hvimp  = fimpd*Hvect + afimpd*Hvectk
      hivimp = fimpd*hivect + afimpd*hivectk

!-----------------------------------------------------------------------
!     calculate ice shelf (floating ice) velocities, based on
!     explicit ice sheet geometry, previous grounded fluxes
!-----------------------------------------------------------------------

      IF (ishelf == 3) THEN
        CALL shelf(ub,vb,ubk,vbk,hi,Hice,hg,fpshtk,ftshtk,&
                   Bbar,pice,ifloating,time)
      END IF

!***********************************************************************
!     Iterate to solution of new ice sheet thicknesses,
!     using an outer Newton iteration and a binconjugate gradient
!     solution to the linearized Jacobian system

      DO iter=1,ntries

!-----------------------------------------------------------------------
!       loop over grid from left to right, beginning at lower left
!       calculate residuals and sparse matrix elements
!-----------------------------------------------------------------------

        ncc = ndsys + 1            ! Counter for index in jacd of
                                   ! most recent off-diagonal element
        scalert = c1                   ! Initialize
        scalehi = c1                   ! Initialize

#if !defined uvic_embm
!-----------------------------------------------------------------------
!       call sliding routine for basal velocites
!-----------------------------------------------------------------------

        IF (islid > 0) THEN
          CALL slidxy(ub,vb,iub,ivb,hi,Hice,Bslid,time)
        END IF

#endif
!-----------------------------------------------------------------------
!       calculate ice sheet fluxes at the current iteration
!-----------------------------------------------------------------------

        CALL is_dyn_eflux(time,ifloating,tiso,Dcoeff,Hvimp,hivimp,ub, &
                          scalert,vp,fpsht,Hrt,hgprt,hgtrt,gradrt,    &
                          alphart,dbarrt)

        CALL is_dyn_nflux(time,ifloating,tiso,Dcoeff,Hvimp,hivimp,vb, &
                          scalehi,vt,ftsht,Hhi,hgphi,hgthi,gradhi,    &
                          alphahi,dbarhi)

!-----------------------------------------------------------------------
!       volume conservation control on fluxes
!-----------------------------------------------------------------------

!        CALL flux_control(ub,vb,iub,ivb,Hvimp,balance,bmelt,fpsht,&
!                          ftsht,scalert,scalehi,Hrt,Hhi)

!-----------------------------------------------------------------------
!       calculate rates of change and ice residuals.
!       coad Jacobian matrix.  Nine dependencies for each point.
!-----------------------------------------------------------------------

        CALL is_dyn_jacob(jacd,ijacd,ub,vb,iub,ivb,fpsht,ftsht,scalert,&
                         Hrt,hgtrt,hgprt,gradrt,alphart,dbarrt,scalehi,&
                         Hhi,hgthi,hgphi,gradhi,alphahi,dbarhi,balance,&
                               bmelt,Bslid,Dcoeff,dhidt,resd,Hvect,Hvectk,&
                         ncc,iland)

        jacd(ndsys+1) = -c1               ! Convention
        ijacd(ndsys+1) = ncc + 1

        CALL calres(resd,res,ndsys,ndsys)     ! Residual calculation
        IF (res < crit) EXIT                        ! Converged acceptably

!-----------------------------------------------------------------------
!       else iterate
!       solve sparse linear system; use biconjugate gradient iteration.
!       pass sparse matrix jacd, ijacd, b=resd, and return x=deld
!-----------------------------------------------------------------------

        itol = 3         ! Routine determines error
        tol = 1.e-6_dp   ! Minimum acceptable residual, m/yr
        itmax = 100      ! Cap on iterations
        CALL linbcg(jacd,ijacd,njacd,resd,deld,ndsys,ncc,&
                    itol,tol,itmax,err,iterb)

!-----------------------------------------------------------------------
!       update ice thickness with deld (1st-order Talyor expansion)
!-----------------------------------------------------------------------

        Hvect = Hvect + deld
        hivect = hivect + deld

!-----------------------------------------------------------------------
!       negative trap, and adjust surface of floating ice
!-----------------------------------------------------------------------

        DO j=1,nlat
          DO i=1,nlon
            k = i + nlon*(j-1)
            IF (Hvect(k) < c0) THEN
              Hvect(k) = c0
              hivect(k) = MAX(hg(i,j), sealevel)
            END IF
            IF ((ishelf >= 1) .and. (ifloating(i,j) == 1)) THEN
              ! Ice on the shelf (previous time step), adjust surface
              hivect(k) = sealevel + iceberg*Hvect(k)
            END IF
           END DO
        END DO

#if defined uvic_embm
!-----------------------------------------------------------------------
!       set boundary conditions for global domain
!-----------------------------------------------------------------------

        CALL cidm_lbc_1d(Hvect)
        CALL cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!       implicit values for Crank-Nicholson (or other) solution
!-----------------------------------------------------------------------

        Hvimp = fimpd*Hvect + afimpd*Hvectk
        hivimp = fimpd*hivect + afimpd*hivectk

      END DO
!***********************************************************************

#if defined uvic_embm
!-----------------------------------------------------------------------
!     set boundary conditions for global domain
!-----------------------------------------------------------------------

      CALL cidm_lbc_1d(Hvect)
      CALL cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!     write warning message
!-----------------------------------------------------------------------

      IF (iter==(ntries+1)) THEN
        WRITE(*,*) 'Warning, maximum iterations exceeded, dynamics'
        WRITE(*,*) '  time = ', time, ' res = ', REAL(res)
        IF (res > 0.1_dp) THEN
          WRITE(*,*) 'Residual values: '
          DO j = 1,nlat
            DO i = 1,nlon
              k = i + nlon*(j-1)
              IF (resd(k) > 0.1_dp) THEN
                WRITE(*,*) ' (i,j) = ', i, j, '  res = ', REAL(resd(k))
                WRITE(*,*) ' H = ', REAL(Hvect(k)), &
                           ' h = ', REAL(hivect(k))
              END IF
            END DO
          END DO
          IF (res > 100._dp) STOP
          ldiverge = .true.
        END IF
      END IF

!-----------------------------------------------------------------------
!     load updated ice thickness and ice surface altitude into "Hice"
!-----------------------------------------------------------------------

      DO j=1,nlat
        DO i=1,nlon
          k = i + nlon*(j-1)
          Hice(i,j) = Hvect(k)
        END DO
      END DO

!-----------------------------------------------------------------------
!     get freshwater flux for ocean model
!-----------------------------------------------------------------------

      fwater = c0
      IF (ishelf > 0) THEN   ! floating ice option
        WHERE ((iland == -1).AND.(Hice > c0))
          fwater = Hice
          Hice = c0
        ENDWHERE
      ELSE
        WHERE ((iland ==  0).AND.(Hice > c0))
          fwater = Hice
          Hice = c0
        ENDWHERE
      END IF

!-----------------------------------------------------------------------
!     ice surface elevation, hi [m]
!     floating ice or grounded ice over the continental shelf
!-----------------------------------------------------------------------

      CALL cidm_get_surf(iland,hg,Hice,ifloating,hi)

!-----------------------------------------------------------------------
!     Flag floating ice for next mass balance, dynamics solution
!-----------------------------------------------------------------------

      IF (ishelf > 0) THEN   ! floating ice option
        DO j=2,nlatp
          jj = j-1
          DO i=2,nlonp
            ij = i-1
            IF (ifloating(i,j) == 1) THEN
              IF ((ifloating(i+1,j)==1) .or. (Hice(i+1,j) < zerop)) &
                                                 ifloatrt(i,jj) = 1
              IF ((ifloating(i,j+1)==1) .or. (Hice(i,j+1) < zerop)) &
                                                 ifloathi(ij,j) = 1
            END IF
          END DO
        END DO
      END IF

!-----------------------------------------------------------------------
!     damage control
!-----------------------------------------------------------------------

!      DO j=1,nlat
!        DO i=1,nlon
!          IF ((hi(i,j) < -6000.0_dp).or.(hi(i,j) > 8000.0_dp)) THEN
!            WRITE(*,*) 'Blowing up!!!  dyn_full,  time ', time
!            WRITE(*,*) 'i, j, hi, dhdt '
!            WRITE(*,*)  i,j,hi(i,j),dhidt(k)
!            WRITE(*,*) 'balance= ',balance(i,j),' bmelt= ',bmelt(i,j)
!            WRITE(*,*) 'fluxlo = ',ftsht(i-1,j-1),' m^2/yr'
!            WRITE(*,*) 'fluxhi = ',ftsht(i-1,j)  ,' m^2/yr'
!            WRITE(*,*) 'fluxlt = ',ftsht(i-1,j-1),' m^2/yr'
!            WRITE(*,*) 'fluxrt = ',ftsht(i,j-1)  ,' m^2/yr'
!            STOP
!          END IF
!        END DO
!      END DO

!-----------------------------------------------------------------------
!     adjust smelt rates from `potential melt' to true ablation
!-----------------------------------------------------------------------

!      imargin = 0
      DO j=2,nlat-1
        jj = j-1
        DO i=2,nlon-1
          ij = i-1
          IF (Hice(i,j) < zerop) THEN
            fluxin = Bjvect(j)*((fpsht(i,jj) - fpsht(ij,jj))*dy & ! m^3/a
                + (ftsht(ij,jj)*delxhi(jj) - ftsht(ij,j) &
                  *delxhi(j))/Cjvect(j))
            icein = acc(i,j) + fluxin/area(j)                   ! m/a
            smelt(i,j) = icein
            IF (fluxin > c0) THEN                       ! Marginal cell
!              imargin(i,j) = 1
            END IF
          END IF
        END DO
      END DO

!-----------------------------------------------------------------------
!     store new fluxes as old
!-----------------------------------------------------------------------

      ftshtk = ftsht
      fpshtk = fpsht
      IF ((islid > 0) .or. (ishelf > 2)) THEN     ! Save basal velocities
        ubk = ub
        vbk = vb
      END IF

!-----------------------------------------------------------------------
!     find vertical velocity field for sheet/stream ice
!-----------------------------------------------------------------------

#if !defined uvic_embm
      IF (ltdcur.or.(time == etime)) THEN

        CALL wfield(vt,vp,wvel,hg,hi,Hice,Hicek,dhgdt,bmelt)

        ! Update bed coverage for permafrost evolution model
        DO j=1,nlat
          DO i=1,nlon
            IF (Hice(i,j) < zerop) THEN
              icover(i,j) = 0           ! Subaerial
            ELSE
              icover(i,j) = 1           ! Ice present
            END IF
          END DO
        END DO

      END IF

#endif
!-----------------------------------------------------------------------
!     deallocate workspace
!-----------------------------------------------------------------------

      DEALLOCATE (Hvect)
      DEALLOCATE (Hvectk)
      DEALLOCATE (Hvimp)
      DEALLOCATE (hivect)
      DEALLOCATE (hivectk)
      DEALLOCATE (hivimp)
      DEALLOCATE (resd)
      DEALLOCATE (deld)
      DEALLOCATE (jacd)
      DEALLOCATE (ijacd)

!=======================================================================
      END SUBROUTINE is_dyn
!=======================================================================
