!*****************************************************************************
! Load elements of the Jacobian matrix for either sheet or stream
! dynamics at the current outer iteration.  Also calculate the equations
! residuals at this iteration.

!***************************************************************************
  SUBROUTINE is_dyn_jacob(jacd,ijacd,ub,vb,iub,ivb,fpsht,ftsht,scalert,&
                         Hrt,hgtrt,hgprt,gradrt,alphart,dbarrt,scalehi,&
                         Hhi,hgthi,hgphi,gradhi,alphahi,dbarhi,balance,&
                               bmelt,Bslid,Dcoeff,dhidt,resd,Hvect,Hvectk,&
                         ncc,iland)

!***************************************************************************
    USE global_param
    IMPLICIT NONE
    INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: iland
    INTEGER, INTENT(IN), DIMENSION(nlon-1,nlatp) :: iub
    INTEGER, INTENT(IN), DIMENSION(nlonp,nlat-1) :: ivb
    INTEGER, INTENT(INOUT) :: ncc
    INTEGER, INTENT(INOUT), DIMENSION(njacd) :: ijacd

    REAL(dp), INTENT(IN) :: Bslid,Dcoeff
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: balance,bmelt
    REAL(dp), INTENT(IN), DIMENSION(nlon-1,nlatp) :: ub,fpsht,scalert,&
                                       Hrt,hgtrt,hgprt,gradrt,dbarrt,alphart
    REAL(dp), INTENT(IN), DIMENSION(nlonp,nlat-1) :: vb,ftsht,scalehi,&
                                       Hhi,hgthi,hgphi,gradhi,dbarhi,alphahi
    REAL(dp), INTENT(INOUT), DIMENSION(njacd) :: jacd
    REAL(dp), INTENT(IN), DIMENSION(ndsys) :: Hvectk
    REAL(dp), INTENT(INOUT), DIMENSION(ndsys) :: dhidt,resd,Hvect

    ! Local variables
    INTEGER :: i,j,ij,jj,ip,jp,k
    REAL(dp) :: Hnew,gradlttm,gradrttm,gradhitm,gradlotm,slid_ijnth,&
                slid_ijsth,slid_east,slid_west,slid_ije,slid_ijw,&
                common_east,common_west,anti_east,anti_west,&
                slid_north,slid_south,Bj,Cj

!******************************************************************************
    ! Loop over the full (numerical) model grid.
    ! (1) Assign Jacobian entries for all points.
    ! (2) Calculate rates of change and ice residuals,
    !     residual convention negative for Newton iteration

    DO j=1,nlat
      jj = j-1
      jp = j+1
      Bj = Bjvect(j)
      Cj = Cjvect(j)

      DO i=1,nlon
        ij = i-1
        ip = i+1
        k = i + nlon*jj                  ! vector

#if !defined uvic_embm
!-----------------------------------------------------------------------
!       Jump to next point when over deep water or over the ocean
!-----------------------------------------------------------------------

        IF  (ishelf > 0) THEN   ! shelf-ice option
          IF (iland(i,j) == -1) THEN
            jacd(k) = c1
            ijacd(k) = ncc + 1
            resd(k) = c0
            Hvect(k) = c0
            CYCLE
          END IF
        ELSE
          IF (iland(i,j) <= 0) THEN
            jacd(k) = c1
            ijacd(k) = ncc + 1
            resd(k) = c0
            Hvect(k) = c0
            CYCLE
          END IF
        END IF

#endif
!-----------------------------------------------------------------------
!       use domain map
!-----------------------------------------------------------------------

        SELECT CASE(idomain(i,j))

        CASE(1)

          dhidt(k) = balance(i,j) - bmelt(i,j) &
                     + ((ftsht(ij,jj)-ftsht(ij,j))/dy &
                     + Cj/dx*(fpsht(i,jj)-fpsht(ij,jj)))/Bj

          resd(k) = dhidt(k) - (Hvect(k)-Hvectk(k))/delt

          Hnew = Hvectk(k) + dhidt(k)*delt
          IF (Hnew <= c0) THEN
            jacd(k) = c1
            ijacd(k) = ncc + 1
            resd(k) = c0
            Hvect(k) = c0
            CYCLE
          END IF

!-----------------------------------------------------------------------
!         Else ice is present: load Jacobian elements
!         Make accomodation for Power(0:0) problem; null terms
!-----------------------------------------------------------------------

          IF (gradhi(ij,jj) < zerom) THEN
            gradlotm = c0
          ELSE
            gradlotm = c1    ! gradlo**derivexp   ! Uncomment when n \ne 3
          END IF
          IF (gradhi(ij,j) < zerom) THEN
            gradhitm = c0
          ELSE
            gradhitm = c1    ! gradhi**derivexp
          END IF
          IF (gradrt(ij,jj) < zerom) THEN
            gradlttm = c0
          ELSE
            gradlttm = c1    ! gradlt**derivexp
          END IF
          IF (gradrt(i,jj) < zerom) THEN
            gradrttm = c0
          ELSE
            gradrttm = c1    ! gradrt**derivexp
          END IF

!-----------------------------------------------------------------------
!         Jacobian diagonal entry
!-----------------------------------------------------------------------

          jacd(k) = c1/delt    &
              - Cj*sine(j)/(Bj*dx)* (-ub(i,jj)*fimpd/c2 &
               + scalert(i,jj)*dbarrt(i,jj)*(Hrt(i,jj)**gnp2*hgprt(i,jj) &
                 *exponent*gradrttm*hgprt(i,jj)*c2*fimpd/(-delphi*sine(j)) &
               + Hrt(i,jj)**gnp2*fimpd/(-delphi*sine(j))*alphart(i,jj) &
               + gnp2*Hrt(i,jj)**gnp1*fimpd/c2*hgprt(i,jj)*alphart(i,jj)) &
                                 + ub(ij,jj)*fimpd/c2 &
               - scalert(ij,jj)*dbarrt(ij,jj)*(Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                 *exponent*gradlttm*hgprt(ij,jj)*c2*fimpd/(delphi*sine(j)) &
               + Hrt(ij,jj)**gnp2*fimpd/(delphi*sine(j))*alphart(ij,jj) &
               + gnp2*Hrt(ij,jj)**gnp1*fimpd/c2*hgprt(ij,jj)*alphart(ij,jj))) &
            - sinehi(jj)/(Bj*dy)* (-vb(ij,jj)*fimpd/c2  &
               + scalehi(ij,jj)*dbarhi(ij,jj)*(Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                 *exponent*gradlotm*hgthi(ij,jj)*c2*fimpd/(-deltheta) &
               + Hhi(ij,jj)**gnp2*fimpd/(-deltheta)*alphahi(ij,jj) &
               + gnp2*Hhi(ij,jj)**gnp1*fimpd/c2*hgthi(ij,jj)*alphahi(ij,jj))) &
            + sinehi(j)/(Bj*dy)* (-vb(ij,j)*fimpd/c2  &
               + scalehi(ij,j)*dbarhi(ij,j)*(Hhi(ij,j)**gnp2*hgthi(ij,j) &
                 *exponent*gradhitm*hgthi(ij,j)*c2*fimpd/deltheta &
               + Hhi(ij,j)**gnp2*fimpd/deltheta*alphahi(ij,j) &
               + gnp2*Hhi(ij,j)**gnp1*fimpd/c2*hgthi(ij,j)*alphahi(ij,j)))

           ijacd(k) = ncc + 1

!-----------------------------------------------------------------------
! Off-diagonal entries
! Corresponding points      ncc+1 --> (i-1,j-1)  or  k-nlon-1
!                           ncc+2 --> (i,j-1)    or  k-nlon
!                           ncc+3 --> (i+1,j-1)  or  k-nlon+1
!                           ncc+4 --> (i-1,j)    or  k-1
!                           ncc+5 --> (i+1,j)    or  k+1
!                           ncc+6 --> (i-1,j+1)  or  k+nlon-1
!                           ncc+7 --> (i,j+1)    or  k+nlon
!                           ncc+8 --> (i+1,j+1)  or  k+nlon+1
!-----------------------------------------------------------------------

           jacd(ncc+1) = Cj*sine(j)/(Bj*dx) &
                *scalert(ij,jj)*dbarrt(ij,jj)*Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                   *exponent*gradlttm*hgtrt(ij,jj)*fimpd/(c2*deltheta) &
                       - sinehi(jj)/(Bj*dy) &
                *scalehi(ij,jj)*dbarhi(ij,jj)*Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                   *exponent*gradlotm*hgphi(ij,jj)*fimpd/(-c2*delphi*sine(jj))

           jacd(ncc+2) = -Cj*sine(j)/(Bj*dx) &
                *(scalert(i,jj)*dbarrt(i,jj)*Hrt(i,jj)**gnp2*hgprt(i,jj) &
                    *exponent*gradrttm*hgtrt(i,jj)*fimpd/(c2*deltheta) &
                - scalert(ij,jj)*dbarrt(ij,jj)*Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                    *exponent*gradlttm*hgtrt(ij,jj)*fimpd/(c2*deltheta)) &
                        - sinehi(jj)/(Bj*dy)* (-vb(ij,jj)*fimpd/c2  &
                + scalehi(ij,jj)*dbarhi(ij,jj)*(Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                    *exponent*gradlotm*hgthi(ij,jj)*c2*fimpd/deltheta &
                  + Hhi(ij,jj)**gnp2*fimpd/deltheta*alphahi(ij,jj) &
                  + gnp2*Hhi(ij,jj)**gnp1*fimpd/c2*hgthi(ij,jj)*alphahi(ij,jj)))

          jacd(ncc+3) = -Cj*sine(j)/(Bj*dx) &
               *scalert(i,jj)*dbarrt(i,jj)*Hrt(i,jj)**gnp2*hgprt(i,jj) &
                  *exponent*gradrttm*hgtrt(i,jj)*fimpd/(c2*deltheta) &
                       - sinehi(jj)/(Bj*dy) &
               *scalehi(ij,jj)*dbarhi(ij,jj)*Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                  *exponent*gradlotm*hgphi(ij,jj)*fimpd/(c2*delphi*sine(jj))

          jacd(ncc+4) = Cj*sine(j)/(Bj*dx)* (-ub(ij,jj)*fimpd/c2 &
               + scalert(ij,jj)*dbarrt(ij,jj)*(Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                   *exponent*gradlttm*hgprt(ij,jj)*c2*fimpd/(-delphi*sine(j)) &
                + Hrt(ij,jj)**gnp2*fimpd/(-delphi*sine(j))*alphart(ij,jj) &
                + gnp2*Hrt(ij,jj)**gnp1*fimpd/c2*hgprt(ij,jj)*alphart(ij,jj)))&
                      - c1/(Bj*dy) *(sinehi(jj)  &
                *scalehi(ij,jj)*dbarhi(ij,jj)*Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                  *exponent*gradlotm*hgphi(ij,jj)*fimpd/(-c2*delphi*sine(j)) &
            -sinehi(j)*scalehi(ij,j)*dbarhi(ij,j)*Hhi(ij,j)**gnp2*hgthi(ij,j) &
                  *exponent*gradhitm*hgphi(ij,j)*fimpd/(-c2*delphi*sine(j)))

          jacd(ncc+5) = -Cj*sine(j)/(Bj*dx)* (-ub(i,jj)*fimpd/c2 &
               + scalert(i,jj)*dbarrt(i,jj)*(Hrt(i,jj)**gnp2*hgprt(i,jj) &
                   *exponent*gradrttm*hgprt(i,jj)*c2*fimpd/(delphi*sine(j)) &
                 + Hrt(i,jj)**gnp2*fimpd/(delphi*sine(j))*alphart(i,jj) &
                 + gnp2*Hrt(i,jj)**gnp1*fimpd/c2*hgprt(i,jj)*alphart(i,jj))) &
                       - c1/(Bj*dy) *(sinehi(jj)  &
                *scalehi(ij,jj)*dbarhi(ij,jj)*Hhi(ij,jj)**gnp2*hgthi(ij,jj) &
                   *exponent*gradlotm*hgphi(ij,jj)*fimpd/(c2*delphi*sine(j)) &
            -sinehi(j)*scalehi(ij,j)*dbarhi(ij,j)*Hhi(ij,j)**gnp2*hgthi(ij,j) &
                   *exponent*gradhitm*hgphi(ij,j)*fimpd/(c2*delphi*sine(j)))

          jacd(ncc+6) = Cj*sine(j)/(Bj*dx) &
               *scalert(ij,jj)*dbarrt(ij,jj)*Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                   *exponent*gradlttm*hgtrt(ij,jj)*fimpd/(-c2*deltheta) &
                       + sinehi(j)/(Bj*dy) &
               *scalehi(ij,j)*dbarhi(ij,j)*Hhi(ij,j)**gnp2*hgthi(ij,j) &
                   *exponent*gradhitm*hgphi(ij,j)*fimpd/(-c2*delphi*sine(jp))

          jacd(ncc+7) = -Cj*sine(j)/(Bj*dx) &
               *(scalert(i,jj)*dbarrt(i,jj)*Hrt(i,jj)**gnp2*hgprt(i,jj) &
                   *exponent*gradrttm*hgtrt(i,jj)*fimpd/(-c2*deltheta) &
               - scalert(ij,jj)*dbarrt(ij,jj)*Hrt(ij,jj)**gnp2*hgprt(ij,jj) &
                   *exponent*gradlttm*hgtrt(ij,jj)*fimpd/(-c2*deltheta)) &
                         + sinehi(j)/(Bj*dy)* (-vb(ij,j)*fimpd/c2  &
               + scalehi(ij,j)*dbarhi(ij,j)*(Hhi(ij,j)**gnp2*hgthi(ij,j) &
                   *exponent*gradhitm*hgthi(ij,j)*c2*(-fimpd)/deltheta &
                 + Hhi(ij,j)**gnp2*(-fimpd)/deltheta*alphahi(ij,j) &
                 + gnp2*Hhi(ij,j)**gnp1*fimpd/c2*hgthi(ij,j)*alphahi(ij,j)))

          jacd(ncc+8) = -Cj*sine(j)/(Bj*dx) &
               *scalert(i,jj)*dbarrt(i,jj)*Hrt(i,jj)**gnp2*hgprt(i,jj) &
                   *exponent*gradrttm*hgtrt(i,jj)*fimpd/(-c2*deltheta) &
                        + sinehi(j)/(Bj*dy) &
               *scalehi(ij,j)*dbarhi(ij,j)*Hhi(ij,j)**gnp2*hgthi(ij,j) &
                   *exponent*gradhitm*hgphi(ij,j)*fimpd/(c2*delphi*sine(jp))

          ijacd(ncc+1) = k-nlon-1
          ijacd(ncc+2) = k-nlon
          ijacd(ncc+3) = k-nlon+1
          ijacd(ncc+4) = k-1
          ijacd(ncc+5) = k+1
          ijacd(ncc+6) = k+nlon-1
          ijacd(ncc+7) = k+nlon
          ijacd(ncc+8) = k+nlon+1

!**********************************
          IF (islid == 1) THEN           ! basal sliding, augment terms for
                                   ! a particular sliding law as needed

            ! Payne (EISMINT) sliding terms
            slid_north = ivb(ij,j)*scalehi(ij,j)*Hhi(ij,j)*fimpd &
                          *Bslid*(r2*hgthi(ij,j)/erad - Hhi(ij,j)/dy)
            slid_south = ivb(ij,jj)*scalehi(ij,jj)*Hhi(ij,jj)*fimpd &
                          *Bslid*(r2*hgthi(ij,jj)/erad + Hhi(ij,jj)/dy)
            slid_ijnth = ivb(ij,j)*scalehi(ij,j)*Hhi(ij,j)*fimpd  &
                          *Bslid*(r2*hgthi(ij,j)/erad + Hhi(ij,j)/dy)
            slid_ijsth = ivb(ij,jj)*scalehi(ij,jj)*Hhi(ij,jj)*fimpd  &
                          *Bslid*(r2*hgthi(ij,jj)/erad - Hhi(ij,jj)/dy)

            slid_east = iub(i,jj)*scalert(i,jj)*Hrt(i,jj)*fimpd  &
                          *Bslid*(r2*hgprt(i,jj)/erad + Hrt(i,jj)/delx(j))
            slid_west = iub(ij,jj)*scalert(ij,jj)*Hrt(ij,jj)*fimpd  &
                          *Bslid*(r2*hgprt(ij,jj)/erad - Hrt(ij,jj)/delx(j))
            slid_ije = iub(i,jj)*scalert(i,jj)*Hrt(i,jj)*fimpd   &
                          *Bslid*(r2*hgprt(i,jj)/erad - Hrt(i,jj)/delx(j))
            slid_ijw = iub(ij,jj)*scalert(ij,jj)*Hrt(ij,jj)*fimpd &
                          *Bslid*(r2*hgprt(ij,jj)/erad + Hrt(ij,jj)/delx(j))

            jacd(k) = jacd(k) + sinehi(jj)/(Bj*dy)*slid_ijsth &
                              - sinehi(j)/(Bj*dy)*slid_ijnth &
                          + Cj*sine(j)/(Bj*dx)*(slid_ije - slid_ijw)

            jacd(ncc+2) = jacd(ncc+2) + sinehi(jj)/(Bj*dy)*slid_south
            jacd(ncc+4) = jacd(ncc+4) - Cj*sine(j)/(Bj*dx)*slid_west
            jacd(ncc+5) = jacd(ncc+5) + Cj*sine(j)/(Bj*dx)*slid_east
            jacd(ncc+7) = jacd(ncc+7) - sinehi(j)/(Bj*dy)*slid_north

          END IF

!**********************************
          ncc = ncc + 8
!**********************************

!-----------------------------------------------------------------------
!       boundary (imaginary) points
!-----------------------------------------------------------------------

        CASE(0)

          jacd(k) = c1
          ijacd(k) = ncc + 1
          resd(k) = c0
          Hvect(k) = c0

!-----------------------------------------------------------------------
!       problematic points for convergence (usually polar region)
!-----------------------------------------------------------------------

        CASE(-1)

          jacd(k) = c1
          ijacd(k) = ncc + 1
          resd(k) = c0
!         Hvect(k) = Hvect(k)

!-----------------------------------------------------------------------
!       error
!-----------------------------------------------------------------------

        CASE DEFAULT       ! Boundary cells, H=0

          WRITE(*,*) 'program stopped due to error in is_dyn_jacob.F90'
          STOP

        END SELECT

      END DO             ! End longitude loop
    END DO             ! End latitude loop

!***************************************************************************
  END SUBROUTINE is_dyn_jacob
!***************************************************************************
