!**************************************************************************
!   Set up transform grids for ice dynamics, ice thermodynamics
!   and bed thermodynamics.  Save as MODULE grids, to be used by
!   numerical subroutines as needed.

    SUBROUTINE is_grids

!**************************************************************************
      USE global_vars
      IMPLICIT NONE

      ! Local variables
      INTEGER :: k
      REAL(KIND=dp) :: zetabot

!**************************************************************************
      ! Define vertical co-ordinate system for dynamics
      ! zeta = exp(aa(hi-z)/H);   *Use negative sense*
      zetabot = EXP(aa)
      delzeta = -(zetabot-zetatop)/DBLE(nvert)
      DO k=1,nvertp
        zeta(k) = zetabot + delzeta*(k-1)
      END DO

      ! Define vertical co-ordinate system for thermodynamics
      ! xi = (hi-z)/H;   *Use positive sense*
      delxi = (xibot-xitop)/DBLE(nvert)
      DO k=1,nvertp
        xi(k) = xitop + delxi*(k-1)
      END DO

      ! Define vertical co-ordinate system for lower bed (unfrozen)
      ! xibc = (hg-Hbedf-z)/(Hbed-Hbedf);  *Use positive sense*
      delxibc = (xibcbot-xibctop)/DBLE(nxibc-1)
      DO k=1,nxibc
        xibc(k) = xibctop + delxibc*(k-1)
      END DO

      ! Define vertical co-ordinate system for upper bed (frozen zone)
      ! xibhi = (hg-z)/Hbedf;    *Use positive sense*
      delxibf = (xibfbot-xibftop)/DBLE(nxibf-1)
      DO k=1,nxibf
        xibf(k) = xibftop + delxibf*(k-1)
      END DO

!***************************************************************************
    END SUBROUTINE is_grids
!***************************************************************************
