!****************** Numerical Recipes routine ****************************
!   (C) Copr. 1986-92 Numerical Recipes Software 5,29#
!   Uses user-supplied routines atimes, asolve, snrm
!   SJM: 95-11-14.  Modify to explicitly include sparse matrix.
!   Routines atimes, snrm, asolve modified accordingly.

!   Solve system Ax = b for x(1:nsys) given b(1:nsys).  On input,
!      x(1:nsys) should be the initial guess to the solution.
!      itol = 1,2,3,4 specifies which convergence test is applied.
!   itmax is the maximum number of iterations allowed and
!   tol is the desired convergence.   On output, x(1:nsys) is reset
!   to the improved solution and iterb is the number of iterations
!   required to get there.  ncc is the physical size of the
!   sparse matrices

!**************************************************************************
    SUBROUTINE linbcg(jac,ijac,njac,bvec,xvec,nsys,ncc,&
                      itol,tol,itmax,err,iterb)

!****************************************************************************
      USE global_param
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: njac,nsys,itmax,itol,ncc
      INTEGER, INTENT(IN) :: ijac(njac)
      INTEGER, INTENT(OUT) :: iterb
      REAL(KIND=dp), INTENT(IN) :: jac(njac),bvec(nsys),tol
      REAL(KIND=dp), INTENT(INOUT) :: xvec(nsys),err

      ! Local variables
      INTEGER :: j,itrnsp
!!!      INTEGER, PARAMETER :: nmax=11000
      REAL(KIND=dp), PARAMETER :: eps=1.e-20_dp
      REAL(KIND=dp) :: ak,akden,bk,bkden,bknum,bnrm,dxnrm,xnrm,zm1nrm,znrm
!!!                       p(nmax),pp(nmax),r(nmax),rr(nmax),z(nmax),zz(nmax)
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:) :: p,pp,r,rr,z,zz
      REAL(KIND=dp), EXTERNAL :: snrm

!**************************************************************************
      ALLOCATE (p(nsys),pp(nsys),r(nsys),rr(nsys),z(nsys),zz(nsys))
      p=c0 ; pp=c0 ; r=c0 ; rr=c0 ; z=c0 ; zz=c0

      iterb = 0
      err = c1
      itrnsp = 0                ! Calculate initial residual r
      CALL atimes(jac,ijac,njac,xvec,r,nsys,itrnsp)
      DO j=1,nsys
        r(j) = bvec(j)-r(j)
        rr(j) = r(j)
      END DO

!     CALL atimes(jac,ijac,njac,xvec,r,nsys,itrnsp)
                ! Uncomment this to give min residual variant of algorithm
      znrm = c1
      IF (itol == 1) THEN
        bnrm = snrm(bvec,nsys,itol)
      ELSE IF (itol == 2) THEN
        CALL asolve(jac,ijac,njac,bvec,z,nsys,itrnsp)
        bnrm = snrm(z,nsys,itol)
      ELSE IF (itol == 3.or.itol == 4) THEN
        CALL asolve(jac,ijac,njac,bvec,z,nsys,itrnsp)
        bnrm = snrm(z,nsys,itol)
        CALL asolve(jac,ijac,njac,r,z,nsys,itrnsp)
        znrm = snrm(z,nsys,itol)
      ELSE
        pause 'illegal itol in linbcg'
      END IF
      CALL asolve(jac,ijac,njac,r,z,nsys,itrnsp)

100   IF (iterb <= itmax) THEN                        ! Iterative loop
        iterb = iterb + 1
        zm1nrm = znrm
        itrnsp = 1
        CALL asolve(jac,ijac,njac,rr,zz,nsys,itrnsp)
        bknum = c0
        DO j=1,nsys
          bknum=bknum+z(j)*rr(j)
        END DO
        IF (iterb == 1) THEN
          DO j=1,nsys
            p(j) = z(j)
            pp(j) = zz(j)
          END DO
        ELSE
          bk=bknum/bkden
          DO j=1,nsys
            p(j) = bk*p(j)+z(j)
            pp(j) = bk*pp(j)+zz(j)
          END DO
        END IF
        bkden = bknum

        itrnsp = 0
        CALL atimes(jac,ijac,njac,p,z,nsys,itrnsp)
        akden = c0
        DO j=1,nsys
          akden = akden+z(j)*pp(j)
        END DO
        ak=bknum/akden

        itrnsp = 1
        CALL atimes(jac,ijac,njac,pp,zz,nsys,itrnsp)
        DO j=1,nsys
          xvec(j) = xvec(j) + ak*p(j)
          r(j) = r(j) - ak*z(j)
          rr(j) = rr(j) - ak*zz(j)
        END DO
        itrnsp = 0
        CALL asolve(jac,ijac,njac,r,z,nsys,itrnsp)
        IF ((itol == 1).or.(itol == 2)) THEN
          znrm = c1
          err = snrm(r,nsys,itol)/bnrm
        ELSE IF ((itol == 3).or.(itol == 4)) THEN
          znrm = snrm(z,nsys,itol)
          IF (ABS(zm1nrm-znrm) > eps*znrm) THEN
            dxnrm = ABS(ak)*snrm(p,nsys,itol)
            err = znrm/ABS(zm1nrm-znrm)*dxnrm
          ELSE
            err = znrm/bnrm
            GOTO 100
          END IF
          xnrm = snrm(xvec,nsys,itol)
          IF (err <= r2*xnrm) THEN
            err = err/xnrm
          ELSE
            err = znrm/bnrm
            GOTO 100
          END IF
        END IF
!       WRITE (*,*) ' iterb=', iterb, ' err=', err

        IF (err > tol) GOTO 100
      END IF

      DEALLOCATE (p,pp,r,rr,z,zz)

!***************************************************************************
    END SUBROUTINE linbcg
!***************************************************************************
