!************************************************************************
   SUBROUTINE load_earth(vert,Hice,load,loadscale)
!************************************************************************

    ! Read viscoelastic Maxwell Earth response (Green's functions)
    ! from Tom James table lookup for a 1 kyr, 1000 m ice load.
    ! The load is a circular disk with an area equivalent to 55 x 55 km.

    ! The range and time of influence are taken to be 20 degrees
    ! and 20 kyr.  Hence, the response at each point (i,j) is
    ! calculated from the summation of all loads within a 20 degree
    ! radius, for the past 20 kyr.  Solved every 1000 yrs.

!************************************************************************
    USE global_param
    IMPLICIT NONE
    REAL(dp), DIMENSION(nlon,nlat), INTENT(IN) :: Hice
    REAL(dp), DIMENSION(nlat), INTENT(OUT) :: loadscale
    REAL(dp), DIMENSION(0:ntisos,nlon,nlat), INTENT(OUT) :: load
    REAL(dp), DIMENSION(0:200,0:ntisos+1), INTENT(OUT) :: vert
    REAL(dp), DIMENSION(0:200) :: dg

    INTEGER :: ndist,ntim,idist,itim,i,j,nstart
    REAL :: dum1,dum2,Hload(nlon,nlat)

!************************************************************************
    ! Read in the Green's function
    OPEN (unit=4, file='infiles/greens.out', access='sequential', &
                                    form='formatted',   status='old')
    READ (4,*) ndist
    READ (4,*) ntim
    DO idist=0,ndist-1                ! 0,75
      DO itim=0,ntim                ! 0,151
        READ (4,*) dum1,dum2,vert(idist,itim)
      END DO
      dg(idist) = dum1
    END DO
    CLOSE (4)

    ! Initialize for current load
    DO j=1,nlat
      DO i=1,nlon
        load(0,i,j) = Hice(i,j)
      END DO
    END DO
    IF (init == 3) THEN                ! Restart, load in load history
       OPEN (unit=4, file= 'infiles/loadhist.dat')      ! 121-70 ka
       nstart = 121 + stime/1000
       DO ntim=nstart,0,-1
          READ (4,*)
          READ (4,*) Hload
          DO j=1,nlat
            DO i=1,nlon
               load(ntim,i,j) = DBLE(Hload(i,j))
            END DO
          END DO
       END DO
       CLOSE (4)
    END IF

    IF (igrid > 1) THEN
      ! Load scaling for Cordilleran-scale Green's functions
      DO j=1,nlat
        loadscale(j) = dy*delx(j)/25560.0_dp**2
      END DO

    ELSE
      ! Load scaling for North American Green's functions
      DO j=1,nlat
        loadscale(j) = dy*delx(j)/55000.0_dp**2
      END DO
    END IF

!************************************************************************
  END SUBROUTINE load_earth
!************************************************************************
