!**********************************************************************
!   Load geothermal heat flux field (W/m^2), from file nahtgr.dat.
!   Data from DNAG North American geothermal maps (GSA),
!   with hints from Trevor Lewis.

    SUBROUTINE loadgeo(geo)

!**********************************************************************
      USE global_param
      IMPLICIT NONE
      REAL(dp), INTENT(INOUT) :: geo(nlon,nlat)

      ! Local variables
      REAL(dp) :: gtflux
      INTEGER :: i,j,ndata

      IF (iheat == 1) THEN           ! Specify
        geo = .045_dp*year

      ELSE                           ! Load gt flux map
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        DO j=1,nlat
          READ (63,*)
          READ(63,100) (geo(i,j), i=1,nlon)
        END DO
        geo = geo*year/1000.0_dp
      END IF
      CLOSE (63)
 100  FORMAT(15(8f8.3,/))

!***********************************************************************
    END SUBROUTINE loadgeo
!***********************************************************************
