!****************************************************************************
!   Load initial temperature field

    SUBROUTINE loadtfld(tiso,tsole,hi,Hice)

!*****************************************************************************
      USE icetd_arrays
      IMPLICIT NONE
      REAL(dp), INTENT(IN) :: hi(nlon,nlat),Hice(nlon,nlat)
      REAL(dp), INTENT(INOUT) :: tiso,tsole(nlon,nlat)

      ! Local variables
      INTEGER :: k,kd,i,j,ij,jj
      REAL(dp) :: tss,delz,tbed,tsurf,dtdz
      REAL(dp), EXTERNAL :: tlapse

!*****************************************************************************
      tss = 270.0_dp                ! Sea surface temperature
      tiso = 265._dp                ! Isothermal calculation temperature

      IF (init < 3) THEN            ! Linear initial temperature field
        DO i=2,nlon-1
          ij = i-1
          DO j=2,nlat-1
            jj = j-1
            IF (Hice(i,j) > zerop) THEN
              delz = Hice(i,j)/REAL(nvert)
              tbed = 260.0_dp
              tsurf = MIN(tlapse(tss,hi(i,j)),triplept)
              dtdz = (tbed-tsurf)/Hice(i,j)
              DO k=1,nvertp
                ticev(k,ij,jj) = tbed-dtdz*delz*(k-1)  ! Positive sense
                tice(k,ij,jj) = tsurf+dtdz*delz*(k-1)  ! Negative sense
                ticek(k,ij,jj) = tice(k,ij,jj)
              END DO
            ELSE
              DO k=1,nvertp
                tice(k,ij,jj) = tnoice
                ticek(k,ij,jj) = tnoice
                ticev(k,ij,jj) = tnoice
              END DO
            END IF
            tsole(i,j) = tice(nvertp,ij,jj)
          END DO
        END DO

      ELSE IF (init == 3) THEN            ! Continuation run
        READ(30,*)
        READ(30,*) tice
        DO jj=1,nlatp
          j = jj+1
          DO ij=1,nlonp
            i = ij+1
            DO k=1,nvertp
              kd = nvertp + 1 - k
              ticek(k,ij,jj) = tice(k,ij,jj)
              ticev(kd,ij,jj) = tice(k,ij,jj)
            END DO
            tsole(i,j) = tice(nvertp,ij,jj)
          END DO
        END DO
      END IF

!***************************************************************************
    END SUBROUTINE loadtfld
!***************************************************************************
