!**********************************************************************
!   Calculate ice shelf geometry and velocities

    SUBROUTINE shelf(ub,vb,ubk,vbk,hi,Hice,hg,fpshtk,ftshtk,&
                     Bbar,pice,ifloating,time)

!**********************************************************************
      USE shelf_arrays
      USE icetd_arrays
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hi,hg,Hice,pice
      REAL(dp), INTENT(IN), DIMENSION(nlon-1,nlatp) :: fpshtk,ubk
      REAL(dp), INTENT(IN), DIMENSION(nlonp,nlat-1) :: ftshtk,vbk
      REAL(dp), INTENT(INOUT), DIMENSION(nlon,nlat) :: Bbar
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

      ! Local variables
      INTEGER :: i,ij,j,jj,ip,jp,k,kp
      REAL(dp) :: dudx,dvdy,dudy,dvdx,Bint,tcur,tbar,Aeff,thinice
      REAL(dp), EXTERNAL :: Binv

      Aeff = 3.e7_dp
      thinice = 20.0_dp

!**********************************************************************
      ! Initialize
      ioutlet = 0
      icefront = 0
      nfront = 0

      ! Zero basal velocities for initialization
      IF (islid == 0) THEN                ! No grounded sliding
        ub = c0                                ! Zero all velocities
        vb = c0
      END IF

      DO j=3,nlatp
        jj = j-1
        jp = j+1
        DO i=3,nlonp
          ij = i-1
          ip = i+1

!**********************************************************************
          IF (ifloating(i,j) == 1) THEN                ! Floating

            ! Zero floating velocities only
            IF (ifloatrt(i,jj) == 1)  ub(i,jj) = c0
            IF (ifloathi(ij,j) == 1)  vb(ij,j) = c0

!***************************************************
            ! Calculate effective viscosity, \bar A

            IF (Hice(i,j) < thinice) THEN           ! A = constant
               Bbar(i,j) = Aeff                           ! Pa yr
               CYCLE                                   ! next point
            END IF

            ! Calculate strain rate invariant and effective viscosity
            ! Employ previous velocity field
            dudx = (ubk(i,jj) - ubk(ij,jj))/delx(j)
            dvdy = (vbk(ij,jj) - vbk(ij,j))/dy
            dvdx = (vbk(i,jj) + vbk(i,j) &
                   -vbk(ij-1,jj) - vbk(ij-1,j))/(c4*delx(j))
            dudy = (ubk(ij,jj-1) + ubk(i,jj-1) &
                         -ubk(ij,j) - ubk(i,j))/(c4*dy)
            strinv(i,j) = zerom + dudx**2 + dvdy**2 + dudx*dvdy &
                       + (dvdx**2 + dudy**2)/c4 + dudy*dvdx/c2

            ! Vertically-integrate for Glen stiffness parameter
            ! using Coulomb rheology from MacAyeal et al, 1982
            IF ((itherm > 0).and.(itdcoup==1)) THEN     ! Thermal coupling
              Bint = c0
              DO k=1,nvert
                ! Calculate vertically-integrated temperatures
                kp = k+1
                tcur = r2*(tice(ij,jj,k) + tice(ij,jj,kp))
                Bint = Bint + Binv(tcur)*delxi
              END DO
            ELSE
              tbar = 260.0_dp                           ! Isothermal
              Bint = Binv(tbar)
            END IF
            Bbar(i,j) = MAX(Bint*strinv(i,j)**strinvexp, Aeff)

!********************************************************
            ! Calculate marginal drag terms
            ! E-W drag from the northern and southern neighbours
            IF ((Hice(i,jp) > thinice) .or. (hg(i,jp) > c0)) THEN
              IF ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) THEN
                  taumar(1,i,j) = Aeff*(c2*(ubk(i,j) + ubk(ij,j)) - ubk(i,jp) &
                             - ubk(ij,jp) - ubk(i,jj) - ubk(ij,jj))/(c4*dy)
              ELSE        ! No drag from the south
                  taumar(1,i,j) = Aeff*(ubk(i,j) + ubk(ij,j) &
                                        - ubk(i,jp) - ubk(ij,jp))/(c2*dy)
              END IF
            ELSE        ! No drag from the north
              IF ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) THEN
                  taumar(1,i,j) = Aeff*(ubk(i,j) + ubk(ij,j) &
                                        - ubk(i,jj) - ubk(ij,jj))/(c2*dy)
              ELSE        ! No drag
                  taumar(1,i,j) = c0
              END IF
            END IF

            ! N-S drag from the eastern and western neighbours
            IF ((Hice(ip,j) > thinice) .or. (hg(ip,j) > c0)) THEN
              IF ((Hice(ij,j) > thinice) .or. (hg(ij,j) > c0)) THEN
                  taumar(2,i,j) = Aeff*(c2*(vbk(i,j) + vbk(i,jj)) - vbk(ip,j) &
                            - vbk(ip,jj) - vbk(ij,j) - vbk(ij,jj))/(c4*delx(j))
              ELSE        ! No drag from the west
                  taumar(2,i,j) = Aeff*(vbk(i,j) + vbk(i,jj) &
                                    - vbk(ip,j) - vbk(ip,jj))/(c2*delx(j))
              END IF
            ELSE        ! No drag from the east
              IF ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) THEN
                  taumar(2,i,j) = Aeff*(vbk(i,j) + vbk(ij,jj) &
                                    - vbk(ij,j) - vbk(ij,jj))/(c2*delx(j))
              ELSE        ! No drag
                  taumar(2,i,j) = c0
              END IF
            END IF

          END IF                ! ifloating ifblock

        END DO
      END DO

!**********************************************************************
      ! Find floating outlet position, geometry, velocity

      CALL shelf_front(ub,vb,ubk,vbk,Hice,fpshtk,ftshtk,Bbar,pice,&
                       thinice,ifloating,time)

!**********************************************************************
      ! Interpolate floating velocites for interior shelf points
      ! Assign eastern and northern interface velocities here

      CALL shelf_vel(ub,vb,Hice,thinice,ifloating,time)

!***************************************************************************
    END SUBROUTINE shelf
!***************************************************************************
